package io.quarkus.arc.test.configproperties;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNull;
import static org.junit.jupiter.api.Assertions.assertTrue;

import java.util.Set;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

import io.quarkus.arc.config.ConfigIgnore;
import io.quarkus.arc.config.ConfigProperties;
import io.quarkus.test.QuarkusUnitTest;

public class NestedClassAndSuperclassConfigPropertiesTest {

    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest()
            .setArchiveProducer(() -> ShrinkWrap.create(JavaArchive.class)
                    .addClasses(DummyBean.class, DummyProperties.class, DummyProperties.NestedDummyProperties.class)
                    .addAsResource(new StringAsset(
                            "dummy.lastname=redhat\ndummy.name=quarkus\ndummy.nested.ages=1,2,3,4\ndummy.supernested.heights=100,200\ndummy.unused=whatever\ndummy.nested.unused=whatever2"),
                            "application.properties"));

    @Inject
    DummyBean dummyBean;

    @Test
    public void testConfiguredValues() {
        DummyProperties dummyProperties = dummyBean.dummyProperties;

        assertEquals("quarkus", dummyProperties.getName());
        assertEquals("redhat", dummyProperties.getLastname());
        Set<Integer> ages = dummyProperties.nested.ages;
        assertEquals(4, ages.size());
        assertTrue(ages.contains(1));
        assertTrue(ages.contains(2));
        assertTrue(ages.contains(3));
        assertTrue(ages.contains(4));
        Set<Integer> heights = dummyProperties.getSupernested().heights;
        assertEquals(2, heights.size());
        assertTrue(heights.contains(100));
        assertTrue(heights.contains(200));
        assertNull(dummyProperties.getSupernested().ignored);
    }

    @Singleton
    public static class DummyBean {
        @Inject
        DummyProperties dummyProperties;
    }

    @ConfigProperties(prefix = "dummy")
    public static class DummyProperties extends SuperDummyProperties {

        private String name;
        public NestedDummyProperties nested;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public static class NestedDummyProperties {

            public Set<Integer> ages;
        }
    }

    public static class SuperDummyProperties {
        private String lastname;
        private NestedSuperDummyProperties supernested;

        public String getLastname() {
            return lastname;
        }

        public void setLastname(String lastname) {
            this.lastname = lastname;
        }

        public NestedSuperDummyProperties getSupernested() {
            return supernested;
        }

        public void setSupernested(NestedSuperDummyProperties supernested) {
            this.supernested = supernested;
        }

        public static class NestedSuperDummyProperties {

            public Set<Integer> heights;
            @ConfigIgnore
            public Integer ignored;
        }
    }
}
