/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.io.File;
import java.util.Date;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="JBWEB")
public interface CatalinaLogger
extends BasicLogger {
    public static final CatalinaLogger ROOT_LOGGER = (CatalinaLogger)Logger.getMessageLogger(CatalinaLogger.class, (String)"org.apache.catalina");
    public static final CatalinaLogger AUTH_LOGGER = (CatalinaLogger)Logger.getMessageLogger(CatalinaLogger.class, (String)"org.apache.catalina.authenticator");
    public static final CatalinaLogger VALVES_LOGGER = (CatalinaLogger)Logger.getMessageLogger(CatalinaLogger.class, (String)"org.apache.catalina.valves");
    public static final CatalinaLogger REALM_LOGGER = (CatalinaLogger)Logger.getMessageLogger(CatalinaLogger.class, (String)"org.apache.catalina.realm");
    public static final CatalinaLogger CONNECTOR_LOGGER = (CatalinaLogger)Logger.getMessageLogger(CatalinaLogger.class, (String)"org.apache.catalina.connector");
    public static final CatalinaLogger FILTERS_LOGGER = (CatalinaLogger)Logger.getMessageLogger(CatalinaLogger.class, (String)"org.apache.catalina.filters");
    public static final CatalinaLogger STARTUP_LOGGER = (CatalinaLogger)Logger.getMessageLogger(CatalinaLogger.class, (String)"org.apache.catalina.startup");
    public static final CatalinaLogger SESSION_LOGGER = (CatalinaLogger)Logger.getMessageLogger(CatalinaLogger.class, (String)"org.apache.catalina.session");
    public static final CatalinaLogger CORE_LOGGER = (CatalinaLogger)Logger.getMessageLogger(CatalinaLogger.class, (String)"org.apache.catalina.core");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1000, value="A valid entry has been removed from client nonce cache to make room for new entries. A replay attack is now possible. To prevent the possibility of replay attacks, reduce nonceValidity or increase cnonceCacheSize. Further warnings of this type will be suppressed for 5 minutes.")
    public void digestCacheRemove();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1001, value="Failed to process certificate string [%s] to create a java.security.cert.X509Certificate object")
    public void certificateProcessingFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1002, value="The SSL provider specified on the connector associated with this request of [%s] is invalid. The certificate data could not be processed.")
    public void missingSecurityProvider(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1003, value="Error digesting user credentials")
    public void errorDigestingCredentials(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1004, value="Failed realm [%s] JMX registration")
    public void failedRealmJmxRegistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1005, value="Failed realm [%s] JMX unregistration")
    public void failedRealmJmxUnregistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1006, value="Missing parent [%s]")
    public void missingParentJmxRegistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1007, value="The connector has already been initialized")
    public void connectorAlreadyInitialized();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1008, value="Failed connector [%s] JMX registration")
    public void failedConnectorJmxRegistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1009, value="Failed connector [%s] JMX unregistration")
    public void failedConnectorJmxUnregistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1010, value="Protocol handler pause failed")
    public void protocolHandlerPauseFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1011, value="Protocol handler resume failed")
    public void protocolHandlerResumeFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1012, value="The connector has already been started")
    public void connectorAlreadyStarted();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1013, value="Cannot proceed with protocol handler JMX registration")
    public void failedProtocolJmxRegistration();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1014, value="The connector has not been started")
    public void connectorNotStarted();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1015, value="Failed protocol handler [%s] JMX unregistration.")
    public void failedProtocolJmxUnregistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1016, value="Connector stop failure")
    public void connectorStopFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1017, value="The Servlet did not read all available bytes during the processing of the read event")
    public void servletDidNotReadAvailableData();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1018, value="An exception or error occurred in the container during the request processing")
    public void exceptionDuringService(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1019, value="The AsyncLisnener %s onComplete threw an exception, which will be ignored")
    public void exceptionDuringComplete(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1020, value="Invalid URI encoding, will use HTTP default")
    public void invalidEncodingUseHttpDefault(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1021, value="Invalid URI encoding, will use straight conversion")
    public void invalidEncoding(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1022, value="Exception thrown whilst processing multipart")
    public void exceptionProcessingMultipart(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1023, value="Parameters were not parsed because the size of the posted data was too big. Use the maxPostSize attribute of the connector to resolve this if the application should accept large POSTs.")
    public void postDataTooLarge();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1024, value="Exception thrown whilst processing POSTed parameters")
    public void exceptionProcessingParameters(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1025, value="Request [%s], can not apply ExpiresFilter on already committed response")
    public void expiresResponseAlreadyCommitted(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1026, value="Unknown parameter %s with value %s is ignored")
    public void expiresUnknownParameter(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1027, value="Request [%s] with response status %s content-type %s, expiration header already defined")
    public void expiresHeaderAlreadyDefined(String var1, int var2, String var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1028, value="Request [%s] with response status %s content-type %s, skip expiration header generation for given status")
    public void expiresSkipStatusCode(String var1, int var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1029, value="Error copying %s to %s")
    public void fileCopyError(File var1, File var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1030, value="%s could not be completely deleted. The presence of the remaining files may cause problems")
    public void fileDeleteError(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1031, value="No Realm has been configured to authenticate against")
    public void noRealmFound();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1032, value="Cannot load authenticators mapping list")
    public void cannotFindAuthenticatoMappings();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1033, value="Cannot load authenticators mapping list")
    public void failedLoadingAuthenticatoMappings(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1034, value="Cannot configure an authenticator for method %s")
    public void noAuthenticatorForAuthMethod(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1035, value="Cannot instantiate an authenticator of class %s")
    public void failedLoadingAuthenticator(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1036, value="Configured an authenticator for method %s")
    public void authenticatorConfigured(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1037, value="Marking this application unavailable due to previous error(s)")
    public void contextUnavailable();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1038, value="Security role name %s used in an <auth-constraint> without being defined in a <security-role>")
    public void roleValidationAuth(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1039, value="Security role name %s used in a <role-link> without being defined in a <security-role>")
    public void roleValidationRunAs(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1040, value="Security role name %s used in a <run-as> without being defined in a <security-role>")
    public void roleValidationLink(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1041, value="Failed session manager [%s] JMX registration.")
    public void failedSessionManagerJmxRegistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1042, value="Exception loading persisted sessions.")
    public void managerLoadFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1043, value="Exception unloading persisted sessions.")
    public void managerUnloadFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1044, value="Invalid session timeout setting %s")
    public void managerInvalidSessionTimeout(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1045, value="Exception checking load state for session %s")
    public void persistentManagerIsLoadedException(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1046, value="Exception clearing session store")
    public void persistentManagerStoreClearException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1047, value="Error loading persisted sessions")
    public void persistentManagerLoadFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1048, value="Error removing session %s")
    public void persistentManagerSessionRemoveFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1049, value="Unloading %s sessions")
    public void persistentManagerSessionUnloadCount(int var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1050, value="Error swapping in session %s")
    public void persistentManagerSwapInFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1051, value="Error swapping out session %s")
    public void persistentManagerSwapOutFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1052, value="Swapped in invalid session %s")
    public void persistentManagerSwapInInvalid(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1053, value="Swapped in session %s")
    public void sessionSwapIn(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1054, value="Error saving session %s to store")
    public void persistentManagerStoreSaveError(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1055, value="No store is configured, persistence disabled")
    public void noStoreConfigured();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1056, value="Swapping session %s to Store, idle for %s seconds")
    public void sessionSwapOut(String var1, int var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1057, value="Too many active sessions [%s] looking for idle sessions to swap out")
    public void persistentManagerCheckIdle(int var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1058, value="Swapping out session %s, idle for %s seconds too many sessions active")
    public void persistentManagerSwapIdleSession(String var1, int var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1059, value="Backing up session %s to Store, idle for %s seconds")
    public void persistentManagerBackupSession(String var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1060, value="JMX registration failed for filter of type [%s] and name [%s]")
    public void filterJmxRegistrationFailed(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1061, value="JMX unregistration failed for filter of type [%s] and name [%s]")
    public void filterJmxUnregistrationFailed(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1062, value="Failed to initialize the SSLEngine")
    public void aprSslEngineInitFailedWithThrowable(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1063, value="Failed to initialize the SSLEngine")
    public void aprSslEngineInitFailed();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1064, value="The native library which allows optimal performance in production environments was not found on the java.library.path: %s")
    public void aprInitFailedWithThrowable(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1065, value="The native library which allows optimal performance in production environments was not found on the java.library.path: %s")
    public void aprInitFailed(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1066, value="An incompatible version %s.%s.%s of the native library is installed, while JBoss Web requires version %s.%s.%s")
    public void aprInvalidVersion(int var1, int var2, int var3, int var4, int var5, int var6);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1067, value="An older version %s.%s.%s of the native library is installed, while JBoss Web recommends version greater than %s.%s.%s")
    public void aprRecommendedVersion(int var1, int var2, int var3, int var4, int var5, int var6);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1068, value="Loaded native library %s.%s.%s with APR capabilities: IPv6 [%s], sendfile [%s], random [%s]")
    public void aprInit(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1069, value="Error stopping loader")
    public void errorStoppingLoader(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1070, value="Error starting loader")
    public void errorStartingLoader(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1071, value="Error stopping manager")
    public void errorStoppingManager(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1072, value="Error starting manager")
    public void errorStartingManager(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1073, value="Error stopping cluster")
    public void errorStoppingCluster(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1074, value="Error starting cluster")
    public void errorStartingCluster(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1075, value="Error stopping realm")
    public void errorStoppingRealm(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1076, value="Error starting realm")
    public void errorStartingRealm(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1077, value="Error starting realm")
    public void errorStoppingChild(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1078, value="Container %s has already been started")
    public void containerAlreadyStarted(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1079, value="Container %s has not been started")
    public void containerNotStarted(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1080, value="Failed container [%s] JMX unregistration")
    public void failedContainerJmxUnregistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1081, value="Error invoking periodic operation")
    public void errorInPeriodicOperation(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1082, value="Background processing error in [%s]")
    public void backgroundProcessingError(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1083, value="Failed engine [%s] JMX registration")
    public void failedEngineJmxRegistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1084, value="Error setting up service")
    public void failedServiceCreation(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1085, value="Failed loding specified error report valve class: %s")
    public void invalidErrorReportValveClass(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1086, value="Failed host [%s] JMX registration")
    public void failedHostJmxRegistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1087, value="Error instantiating servlet class %s")
    public void errorInstantiatingServletClass(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1088, value="Failed Servlet [%s] JMX registration")
    public void failedServletJmxRegistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1089, value="Failed Servlet [%s] JSP monitoring JMX registration")
    public void failedServletJspMonitorJmxRegistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1090, value="Form login page %s must start with a ''/'' in Servlet 2.4")
    public void loginPageStartsWithSlash(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1091, value="Error page location %s must start with a ''/'' in Servlet 2.4")
    public void errorPageStartsWithSlash(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1092, value="Failed access to work directory for Context %s")
    public void failedObtainingWorkDirectory(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1093, value="The listener %s is already configured for this context, the duplicate definition has been ignored")
    public void duplicateListener(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1094, value="JSP file %s must start with a ''/'' in Servlet 2.4")
    public void jspFileStartsWithSlash(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1095, value="Cannot find JSP Servlet, so ignoring jsp-property-group mappings")
    public void missingJspServlet();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1096, value="Error stopping context %s")
    public void errorStoppingContext(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1097, value="Error starting context %s")
    public void errorStartingContext(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1098, value="Starting filter %s")
    public void startingFilter(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1099, value="Stopping filter %s")
    public void stoppingFilter(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1100, value="Error starting context")
    public void errorStartingResources(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1101, value="Error stopping context")
    public void errorStoppingResources(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1102, value="Error initializing resources")
    public void errorInitializingResources(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1103, value="Error detected during context %s start, will stop it")
    public void errorStartingContextWillStop(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1104, value="Error performing failed context %s start cleanup")
    public void errorStartingContextCleanup(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1105, value="Error resetting context %s")
    public void errorResettingContext(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1106, value="URL pattern %s must start with a ''/'' in Servlet 2.4")
    public void urlPatternStartsWithSlash(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1107, value="Suspicious url pattern: %s in context %s - see section SRV.11.2 of the Servlet specification")
    public void suspiciousUrlPattern(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1108, value="Context %s object name creation failed")
    public void contextObjectNameCreationFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1109, value="Cannot find context %s parent Host JMX name")
    public void cannotFindContextJmxParentName(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1110, value="JSP container initialization failed")
    public void jspContainerInitializationFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1111, value="Thread %s (id=%s) has been active for %s milliseconds (since %s) to serve the same request for %s and may be stuck (configured threshold for this StuckThreadDetectionValve is %s seconds). There is/are %s thread(s) in total that are monitored by this Valve and may be stuck.")
    public void stuckThreadDetected(String var1, long var2, long var4, Date var6, String var7, int var8, int var9, @Cause Throwable var10);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1112, value="Thread %s (id=%s) was previously reported to be stuck but has completed. It was active for approximately %s milliseconds. There is/are still %s thread(s) that are monitored by this Valve and may be stuck.")
    public void stuckThreadCompleted(String var1, long var2, long var4, int var6);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1113, value="Failed to trigger creation of the GC Daemon thread during start to prevent possible memory leaks. This is expected on non-Sun JVMs.")
    public void errorCreatingGcDaemon(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1114, value="Error whilst attempting to prevent memory leak in javax.security.auth.Policy class")
    public void errorLoadingPolicy(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1115, value="Failed to disable Jar URL connection caching by default")
    public void errorDisablingUrlConnectionCaching(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1116, value="Error whilst attempting to prevent memory leaks during XML parsing")
    public void errorLoadingJaxp(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1117, value="Failed to trigger creation of the com.sun.jndi.ldap.LdapPoolManager class during Tomcat start to prevent possible memory leaks. This is expected on non-Sun JVMs.")
    public void errorLoadingLdapPoolManager(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1118, value="Failed to load class %s during Tomcat start to prevent possible memory leaks.")
    public void errorLoadingLeakClass(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1119, value="Client abort exception: %s")
    public void clientAbortException(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1120, value="Pipeline already started")
    public void pipelineAlreadyStarted();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1121, value="Pipeline has not been started")
    public void pipelineNotStarted();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1122, value="Failed valve [%s] JMX registration")
    public void failedValveJmxRegistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1123, value="Failed valve [%s] JMX unregistration")
    public void failedValveJmxUnregistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1124, value="Error stopping valve")
    public void errorStoppingValve(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1125, value="Error starting valve")
    public void errorStartingValve(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1126, value="Error starting service")
    public void errorStartingService(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1127, value="Error initializing service")
    public void errorInitializingService(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1128, value="Failed service [%s] JMX registration")
    public void failedServiceJmxRegistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1129, value="Error starting connector")
    public void errorStartingConnector(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1130, value="Error initializing connector")
    public void errorInitializingConnector(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1131, value="Error stopping connector")
    public void errorStoppingConnector(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1132, value="Error starting executor")
    public void errorStartingExecutor(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1133, value="Error stopping executor")
    public void errorStoppingExecutor(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1134, value="This service has already been started")
    public void serviceAlreadyStarted();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1135, value="This service has not been started")
    public void serviceNotStarted();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1136, value="Starting service %s")
    public void startingService(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1137, value="Stopping service %s")
    public void stoppingService(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1138, value="Failed server [%s] JMX registration")
    public void failedServerJmxRegistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1139, value="Context %s JMX registration failed")
    public void contextJmxRegistrationFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1140, value="Failed protocol handler [%s] JMX registration")
    public void failedProtocolJmxRegistration(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1141, value="NIO 2 is not available, the java.io connector will be used instead")
    public void usingJavaIoConnector();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1142, value="Access log rotation failed")
    public void errorRotatingAccessLog(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1143, value="Error closing old log file")
    public void errorClosingOldAccessLog(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1144, value="Pattern was just empty or whitespace")
    public void extendedAccessLogEmptyPattern();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1145, value="Pattern parse error")
    public void extendedAccessLogPatternParseError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1146, value="Unable to decode with rest of chars starting: %s")
    public void extendedAccessLogUnknownToken(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1147, value="No closing ) found for in decode")
    public void extendedAccessLogMissingClosing();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1148, value="The next characters couldn't be decoded: %s")
    public void extendedAccessLogCannotDecode(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1149, value="X param for servlet request, couldn't decode value: %s")
    public void extendedAccessLogCannotDecodeXParamValue(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1150, value="X param in wrong format. Needs to be 'x-#(...)'")
    public void extendedAccessLogBadXParam();
}

