/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.realm.RealmPropertiesBase;
import com.sun.identity.console.realm.ServicesEditViewBean;
import com.sun.identity.console.realm.ServicesSelectViewBean;
import com.sun.identity.console.realm.ServicesTiledView;
import com.sun.identity.console.realm.model.ServicesModel;
import com.sun.identity.console.realm.model.ServicesModelImpl;
import com.sun.identity.console.service.model.SCUtils;
import com.sun.identity.shared.locale.Locale;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServicesViewBean
extends RealmPropertiesBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/realm/Services.jsp";
    private static final String CHILD_TBL_TILED_VIEW = "tableTiledView";
    private static final String TBL_SEARCH = "tblSearch";
    private static final String TBL_BUTTON_ADD = "tblButtonAdd";
    private static final String TBL_BUTTON_DELETE = "tblButtonDelete";
    private static final String TBL_COL_NAME = "tblColName";
    private static final String TBL_DATA_NAME = "tblDataName";
    private static final String TF_DATA_NAME = "tfDataName";
    private static final String TBL_COL_ACTION = "tblColAction";
    private static final String TBL_DATA_ACTION_LABEL = "tblDataActionLabel";
    private static final String PAGETITLE = "pgtitle";
    static final String TBL_DATA_ACTION_HREF = "tblDataActionHref";
    private CCActionTableModel tblModel = null;

    public ServicesViewBean() {
        super("Services");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createTableModel();
        this.createPageTitleModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PAGETITLE, CCPageTitle.class);
        this.registerChild(TBL_SEARCH, CCActionTable.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblModel.registerChildren((ContainerViewBase)this);
        this.registerChild(CHILD_TBL_TILED_VIEW, ServicesTiledView.class);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(CHILD_TBL_TILED_VIEW)) {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            this.populateTableModel((Map)szCache.getSerializedObj());
            view = new ServicesTiledView((View)this, this.tblModel, name);
        } else if (name.equals(TBL_SEARCH)) {
            ServicesTiledView tView = (ServicesTiledView)this.getChild(CHILD_TBL_TILED_VIEW);
            CCActionTable child = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name);
            child.setTiledView((ContainerView)tView);
            view = child;
        } else {
            view = name.equals(PAGETITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name)));
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.resetButtonState(TBL_BUTTON_DELETE);
        this.getServiceNames();
        this.setPageTitle(this.getModel(), "page.title.realms.services");
        ServicesModel model = (ServicesModel)this.getModel();
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        try {
            if (model.getAssignableServiceNames(curRealm).isEmpty()) {
                CCButton btnAdd = (CCButton)this.getChild(TBL_BUTTON_ADD);
                btnAdd.setDisabled(true);
                this.setInlineAlertMessage("info", "message.information", "services.noservices.for.assignment.message");
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            CCButton btnAdd = (CCButton)this.getChild(TBL_BUTTON_ADD);
            btnAdd.setDisabled(true);
        }
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        HttpServletRequest req = rc.getRequest();
        return new ServicesModelImpl(req, this.getPageSessionAttributes());
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/oneBtnPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)this.getBackButtonLabel());
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblRMServices.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_BUTTON_ADD, (Object)"table.services.button.new");
        this.tblModel.setActionValue(TBL_BUTTON_DELETE, (Object)"table.services.button.delete");
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)"table.services.name.column.name");
        this.tblModel.setActionValue(TBL_COL_ACTION, (Object)"table.services.action.column.name");
    }

    private void getServiceNames() {
        ServicesModel model = (ServicesModel)this.getModel();
        try {
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            this.populateTableModel(model.getAssignedServiceNames(curRealm));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    private void populateTableModel(Map nameToDisplayNames) {
        this.tblModel.clearAll();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        if (nameToDisplayNames != null && !nameToDisplayNames.isEmpty()) {
            Map reverseMap = AMFormatUtils.reverseStringMap(nameToDisplayNames);
            ServicesModel model = (ServicesModel)this.getModel();
            List list = AMFormatUtils.sortKeyInMap(reverseMap, model.getUserLocale());
            boolean firstEntry = true;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblModel.appendRow();
                }
                String displayName = (String)iter.next();
                String name = (String)reverseMap.get(displayName);
                this.tblModel.setValue(TF_DATA_NAME, (Object)name);
                this.tblModel.setValue(TBL_DATA_NAME, (Object)displayName);
                this.tblModel.setValue(TBL_DATA_ACTION_HREF, (Object)name);
                this.tblModel.setValue(TBL_DATA_ACTION_LABEL, (Object)"table.services.action.edit");
            }
            szCache.setValue((Serializable)((Object)nameToDisplayNames));
        } else {
            szCache.setValue(null);
        }
    }

    public void handleTblButtonAddRequest(RequestInvocationEvent event) {
        ServicesSelectViewBean vb = (ServicesSelectViewBean)this.getViewBean(ServicesSelectViewBean.class);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblDataActionHrefRequest(String serviceName) {
        ServicesModel model = (ServicesModel)this.getModel();
        SCUtils utils = new SCUtils(serviceName, model);
        String propertiesViewBeanURL = utils.getServiceDisplayURL();
        if (propertiesViewBeanURL != null && propertiesViewBeanURL.trim().length() > 0) {
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            if (curRealm == null) {
                curRealm = AMModelBase.getStartDN(this.getRequestContext().getRequest());
            }
            try {
                String pageTrailID = (String)this.getPageSessionAttribute("pageTrailID");
                propertiesViewBeanURL = propertiesViewBeanURL + "?ServiceName=" + serviceName + "&Location=" + Locale.URLEncodeField((String)curRealm, (String)this.getCharset(model)) + "&Template=true&Op=" + "edit" + "&" + "pageTrailID" + "=" + pageTrailID;
                HttpServletResponse response = this.getRequestContext().getResponse();
                response.sendRedirect(propertiesViewBeanURL);
            }
            catch (UnsupportedEncodingException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
            catch (IOException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
        } else {
            ServicesEditViewBean vb = (ServicesEditViewBean)this.getViewBean(ServicesEditViewBean.class);
            this.setPageSessionAttribute("serviceName", (Serializable)((Object)serviceName));
            this.setPageSessionAttribute("returnToViewBean", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
    }

    public void handleTblButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_SEARCH);
        table.restoreStateData();
        Integer[] selected = this.tblModel.getSelectedRows();
        HashSet<String> names = new HashSet<String>(selected.length * 2);
        for (int i = 0; i < selected.length; ++i) {
            this.tblModel.setRowIndex(selected[i].intValue());
            names.add((String)this.tblModel.getValue(TF_DATA_NAME));
        }
        try {
            ServicesModel model = (ServicesModel)this.getModel();
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            model.unassignServices(curRealm, names);
            if (selected.length == 1) {
                this.setInlineAlertMessage("info", "message.information", "services.message.deleted");
            } else {
                this.setInlineAlertMessage("info", "message.information", "services.message.deleted.pural");
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToRealmView(event);
    }
}

