/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import com.sun.identity.authentication.internal.server.SMSAuthModule;
import com.sun.identity.setup.BootstrapData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.security.auth.login.LoginException;

public class InitializeSystem {
    private String rootsuffix;
    private BootstrapData bData;
    private String instanceName;

    public InitializeSystem() throws FileNotFoundException, IOException, UnsupportedEncodingException, LDAPServiceException {
        String basedir = System.getProperty("bootstrap.dir");
        this.load(basedir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String basedir) throws FileNotFoundException, IOException, UnsupportedEncodingException, LDAPServiceException {
        String amConfigProperties;
        File file;
        if (!basedir.endsWith(File.separator)) {
            basedir = basedir + File.separator;
        }
        if ((file = new File(amConfigProperties = basedir + "AMConfig.properties")).exists()) {
            Properties prop = new Properties();
            FileInputStream propIn = new FileInputStream(amConfigProperties);
            try {
                prop.load(propIn);
            }
            finally {
                ((InputStream)propIn).close();
            }
            SystemProperties.initializeProperties(prop);
        } else {
            this.bData = new BootstrapData(basedir);
            this.bData.initSMS(false);
            AdminUtils.initialize();
            SMSAuthModule.initialize();
            this.rootsuffix = this.bData.getBaseDN();
            this.instanceName = this.bData.getInstanceName();
        }
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getServerConfigXML() throws UnsupportedEncodingException, MalformedURLException {
        return this.bData.getServerConfigXML(true);
    }

    public String getRootSuffix() {
        return this.rootsuffix;
    }

    public SSOToken getSSOToken(String bindPwd) throws LoginException, InvalidAuthContextException {
        AuthPrincipal principal;
        SSOToken ssoToken = null;
        String userRootSuffix = this.bData.getUserBaseDN();
        AuthContext ac = new AuthContext(userRootSuffix, principal = new AuthPrincipal("cn=dsameuser,ou=DSAME Users," + userRootSuffix), bindPwd.toCharArray());
        if (ac.getLoginStatus() == 3) {
            ssoToken = ac.getSSOToken();
        }
        return ssoToken;
    }
}

