/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ClosedWorkerException;
import org.xnio.FailedIoFuture;
import org.xnio.FinishedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.StreamChannel;
import org.xnio.nio.BioMulticastUdpChannel;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioPipeChannel;
import org.xnio.nio.NioSetter;
import org.xnio.nio.NioTcpChannel;
import org.xnio.nio.NioTcpServer;
import org.xnio.nio.NioUdpChannel;
import org.xnio.nio.NioXnio;
import org.xnio.nio.WorkerThread;

final class NioXnioWorker
extends XnioWorker {
    private static final int CLOSE_REQ = Integer.MIN_VALUE;
    private static final int CLOSE_COMP = 0x40000000;
    private volatile int state = 1;
    private final WorkerThread[] readWorkers;
    private final WorkerThread[] writeWorkers;
    private volatile Thread[] shutdownWaiters = NONE;
    private static final Thread[] NONE = new Thread[0];
    private static final Thread[] SHUTDOWN_COMPLETE = new Thread[0];
    private static final AtomicReferenceFieldUpdater<NioXnioWorker, Thread[]> shutdownWaitersUpdater = AtomicReferenceFieldUpdater.newUpdater(NioXnioWorker.class, Thread[].class, "shutdownWaiters");
    private static final AtomicIntegerFieldUpdater<NioXnioWorker> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(NioXnioWorker.class, "state");
    private static final WorkerThread[] NO_WORKERS = new WorkerThread[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NioXnioWorker(NioXnio xnio, ThreadGroup threadGroup, OptionMap optionMap, Runnable terminationTask) throws IOException {
        super(xnio, threadGroup, optionMap, terminationTask);
        int readCount = optionMap.get(Options.WORKER_READ_THREADS, 1);
        if (readCount < 0) {
            throw new IllegalArgumentException("Worker read thread count must be >= 0");
        }
        int writeCount = optionMap.get(Options.WORKER_WRITE_THREADS, 1);
        if (writeCount < 0) {
            throw new IllegalArgumentException("Worker write thread count must be >= 0");
        }
        long workerStackSize = optionMap.get(Options.STACK_SIZE, 0L);
        if (workerStackSize < 0L) {
            throw new IllegalArgumentException("Worker stack size must be >= 0");
        }
        String workerName = this.getName();
        WorkerThread[] readWorkers = new WorkerThread[readCount];
        WorkerThread[] writeWorkers = new WorkerThread[writeCount];
        boolean markWorkerThreadAsDaemon = optionMap.get(Options.THREAD_DAEMON, false);
        boolean ok = false;
        try {
            int i;
            for (i = 0; i < readCount; ++i) {
                WorkerThread readWorker = new WorkerThread(this, Selector.open(), String.format("%s read-%d", workerName, i + 1), threadGroup, workerStackSize);
                if (markWorkerThreadAsDaemon) {
                    readWorker.setDaemon(true);
                }
                readWorkers[i] = readWorker;
            }
            for (i = 0; i < writeCount; ++i) {
                WorkerThread writeWorker = new WorkerThread(this, Selector.open(), String.format("%s write-%d", workerName, i + 1), threadGroup, workerStackSize);
                if (markWorkerThreadAsDaemon) {
                    writeWorker.setDaemon(true);
                }
                writeWorkers[i] = writeWorker;
            }
            ok = true;
        }
        finally {
            if (!ok) {
                for (WorkerThread worker : readWorkers) {
                    if (worker == null) continue;
                    IoUtils.safeClose(worker.getSelector());
                }
                for (WorkerThread worker : writeWorkers) {
                    if (worker == null) continue;
                    IoUtils.safeClose(worker.getSelector());
                }
            }
        }
        this.readWorkers = readWorkers;
        this.writeWorkers = writeWorkers;
    }

    void start() {
        for (WorkerThread worker : this.readWorkers) {
            this.openResourceUnconditionally();
            worker.start();
        }
        for (WorkerThread worker : this.writeWorkers) {
            this.openResourceUnconditionally();
            worker.start();
        }
    }

    WorkerThread choose() {
        WorkerThread[] write = this.writeWorkers;
        WorkerThread[] read = this.readWorkers;
        int writeLength = write.length;
        int readLength = read.length;
        if (writeLength == 0) {
            return this.choose(false);
        }
        if (readLength == 0) {
            return this.choose(true);
        }
        Random random = IoUtils.getThreadLocalRandom();
        int idx = random.nextInt(writeLength + readLength);
        return idx >= readLength ? write[idx - readLength] : read[idx];
    }

    WorkerThread chooseOptional(boolean write) {
        WorkerThread[] orig = write ? this.writeWorkers : this.readWorkers;
        int length = orig.length;
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return orig[0];
        }
        Random random = IoUtils.getThreadLocalRandom();
        return orig[random.nextInt(length)];
    }

    WorkerThread choose(boolean write) {
        WorkerThread result = this.chooseOptional(write);
        if (result == null) {
            throw new IllegalArgumentException("No threads configured");
        }
        return result;
    }

    WorkerThread[] choose(int count, boolean write) {
        HashSet<Object> set;
        if (count == 0) {
            return NO_WORKERS;
        }
        WorkerThread[] orig = write ? this.writeWorkers : this.readWorkers;
        int length = orig.length;
        int halfLength = length >> 1;
        if (length == 0) {
            throw new IllegalArgumentException("No threads configured");
        }
        if (count == length) {
            return orig;
        }
        if (count > length) {
            throw new IllegalArgumentException("Not enough " + (write ? "write" : "read") + " threads configured");
        }
        WorkerThread[] result = new WorkerThread[count];
        Random random = IoUtils.getThreadLocalRandom();
        if (count == 1) {
            result[0] = orig[random.nextInt(length)];
            return result;
        }
        if (length < 32) {
            if (count >= halfLength) {
                int bits = (1 << length) - 1;
                while (Integer.bitCount(bits &= ~(1 << random.nextInt(length))) > count) {
                }
                for (int i = 0; i < count; ++i) {
                    int bit = Integer.numberOfTrailingZeros(bits);
                    result[i] = orig[bit];
                    bits ^= Integer.lowestOneBit(bits);
                }
                return result;
            }
            int bits = 0;
            while (Integer.bitCount(bits |= 1 << random.nextInt(length)) < count) {
            }
            for (int i = 0; i < count; ++i) {
                int bit = Integer.numberOfTrailingZeros(bits);
                result[i] = orig[bit];
                bits ^= Integer.lowestOneBit(bits);
            }
            return result;
        }
        if (length < 64) {
            if (count >= halfLength) {
                long bits = (1L << (int)((long)length)) - 1L;
                while (Long.bitCount(bits &= 1L << (int)((long)random.nextInt(length)) ^ 0xFFFFFFFFFFFFFFFFL) > count) {
                }
                for (int i = 0; i < count; ++i) {
                    int bit = Long.numberOfTrailingZeros(bits);
                    result[i] = orig[bit];
                    bits ^= Long.lowestOneBit(bits);
                }
                return result;
            }
            long bits = 0L;
            while (Long.bitCount(bits |= 1L << (int)((long)random.nextInt(length))) < count) {
            }
            for (int i = 0; i < count; ++i) {
                int bit = Long.numberOfTrailingZeros(bits);
                result[i] = orig[bit];
                bits ^= Long.lowestOneBit(bits);
            }
            return result;
        }
        if (count >= halfLength) {
            set = new HashSet<WorkerThread>(Arrays.asList(orig));
            while (set.size() > count) {
                set.remove(orig[random.nextInt(length)]);
            }
        } else {
            set = new HashSet(length);
            while (set.size() < count) {
                set.add(orig[random.nextInt(length)]);
            }
        }
        return set.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AcceptingChannel<? extends ConnectedStreamChannel> createTcpServer(InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        boolean ok = false;
        ServerSocketChannel channel = ServerSocketChannel.open();
        try {
            channel.configureBlocking(false);
            channel.socket().bind(bindAddress);
            NioTcpServer server = new NioTcpServer(this, channel, optionMap);
            ChannelListener.Setter setter = server.getAcceptSetter();
            ((ChannelListener.SimpleSetter)setter).set(acceptListener);
            ok = true;
            NioTcpServer nioTcpServer = server;
            return nioTcpServer;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose(channel);
            }
        }
    }

    @Override
    protected IoFuture<ConnectedStreamChannel> connectTcpStream(InetSocketAddress bindAddress, InetSocketAddress destinationAddress, final ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, final OptionMap optionMap) {
        try {
            final SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(bindAddress);
            final NioTcpChannel tcpChannel = new NioTcpChannel(this, channel);
            final NioHandle connectHandle = optionMap.get(Options.WORKER_ESTABLISH_WRITING, false) ? tcpChannel.getWriteHandle() : tcpChannel.getReadHandle();
            ChannelListeners.invokeChannelListener(tcpChannel.getBoundChannel(), bindListener);
            if (channel.connect(destinationAddress)) {
                connectHandle.getWorkerThread().execute(ChannelListeners.getChannelListenerTask(tcpChannel, openListener));
                return new FinishedIoFuture<ConnectedStreamChannel>(tcpChannel);
            }
            ChannelListener.SimpleSetter setter = connectHandle.getHandlerSetter();
            final FutureResult futureResult = new FutureResult();
            setter.set(new ChannelListener<NioTcpChannel>(){

                @Override
                public void handleEvent(NioTcpChannel channel2) {
                    SocketChannel socketChannel = channel2.getReadChannel();
                    try {
                        if (socketChannel.finishConnect()) {
                            connectHandle.suspend();
                            connectHandle.getHandlerSetter().set(null);
                            if (!futureResult.setResult(tcpChannel)) {
                                IoUtils.safeClose(channel2);
                            } else {
                                tcpChannel.configureFrom(optionMap);
                                ChannelListeners.invokeChannelListener(tcpChannel, openListener);
                            }
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose(channel2);
                        futureResult.setException(e);
                    }
                }

                public String toString() {
                    return "Connection finisher for " + channel;
                }
            });
            futureResult.addCancelHandler(new Cancellable(){

                @Override
                public Cancellable cancel() {
                    if (futureResult.setCancelled()) {
                        IoUtils.safeClose(tcpChannel);
                    }
                    return this;
                }

                public String toString() {
                    return "Cancel handler for " + channel;
                }
            });
            connectHandle.resume(8);
            return futureResult.getIoFuture();
        }
        catch (IOException e) {
            return new FailedIoFuture<ConnectedStreamChannel>(e);
        }
    }

    @Override
    protected IoFuture<ConnectedStreamChannel> acceptTcpStream(InetSocketAddress destination, final ChannelListener<? super ConnectedStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, final OptionMap optionMap) {
        WorkerThread connectThread = this.choose(optionMap.get(Options.WORKER_ESTABLISH_WRITING, false));
        try {
            final ServerSocketChannel channel = ServerSocketChannel.open();
            channel.configureBlocking(false);
            channel.socket().bind(destination);
            final NioSetter closeSetter = new NioSetter();
            ChannelListeners.invokeChannelListener(new BoundChannel(){

                @Override
                public XnioWorker getWorker() {
                    return NioXnioWorker.this;
                }

                @Override
                public SocketAddress getLocalAddress() {
                    return channel.socket().getLocalSocketAddress();
                }

                @Override
                public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
                    SocketAddress address = this.getLocalAddress();
                    return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
                }

                @Override
                public ChannelListener.Setter<? extends BoundChannel> getCloseSetter() {
                    return closeSetter;
                }

                @Override
                public boolean isOpen() {
                    return channel.isOpen();
                }

                @Override
                public boolean supportsOption(Option<?> option) {
                    return false;
                }

                @Override
                public <T> T getOption(Option<T> option) throws IOException {
                    return null;
                }

                @Override
                public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                    return null;
                }

                @Override
                public void close() throws IOException {
                    channel.close();
                }

                public String toString() {
                    return String.format("TCP acceptor bound channel (NIO) <%h>", this);
                }
            }, bindListener);
            SocketChannel accepted = channel.accept();
            if (accepted != null) {
                IoUtils.safeClose(channel);
                NioTcpChannel tcpChannel = new NioTcpChannel(this, accepted);
                tcpChannel.configureFrom(optionMap);
                ChannelListeners.invokeChannelListener(tcpChannel, openListener);
                return new FinishedIoFuture<ConnectedStreamChannel>(tcpChannel);
            }
            ChannelListener.SimpleSetter<ServerSocketChannel> setter = new ChannelListener.SimpleSetter<ServerSocketChannel>();
            final FutureResult futureResult = new FutureResult();
            final NioHandle<ServerSocketChannel> handle = connectThread.addChannel(channel, channel, 0, setter);
            setter.set(new ChannelListener<ServerSocketChannel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleEvent(ServerSocketChannel channel2) {
                    SocketChannel accepted;
                    try {
                        accepted = channel2.accept();
                        if (accepted == null) {
                            return;
                        }
                    }
                    catch (IOException e) {
                        IoUtils.safeClose(channel2);
                        handle.cancelKey();
                        futureResult.setException(e);
                        return;
                    }
                    boolean ok = false;
                    try {
                        handle.cancelKey();
                        IoUtils.safeClose(channel2);
                        try {
                            accepted.configureBlocking(false);
                            NioTcpChannel tcpChannel = new NioTcpChannel(NioXnioWorker.this, accepted);
                            tcpChannel.configureFrom(optionMap);
                            futureResult.setResult(tcpChannel);
                            ok = true;
                            ChannelListeners.invokeChannelListener(tcpChannel, openListener);
                        }
                        catch (IOException e) {
                            futureResult.setException(e);
                            if (!ok) {
                                IoUtils.safeClose(accepted);
                            }
                            return;
                        }
                    }
                    finally {
                        if (!ok) {
                            IoUtils.safeClose(accepted);
                        }
                    }
                }

                public String toString() {
                    return "Accepting finisher for " + channel;
                }
            });
            handle.resume(16);
            return futureResult.getIoFuture();
        }
        catch (IOException e) {
            return new FailedIoFuture<ConnectedStreamChannel>(e);
        }
    }

    @Override
    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        if (!NioXnio.NIO2 && optionMap.get(Options.MULTICAST, false)) {
            MulticastSocket socket = new MulticastSocket(bindAddress);
            BioMulticastUdpChannel channel = new BioMulticastUdpChannel((XnioWorker)this, optionMap.get(Options.SEND_BUFFER, 8192), optionMap.get(Options.RECEIVE_BUFFER, 8192), socket, this.chooseOptional(false), this.chooseOptional(true));
            channel.open();
            ChannelListeners.invokeChannelListener(channel, bindListener);
            return channel;
        }
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        channel.socket().bind(bindAddress);
        NioUdpChannel udpChannel = new NioUdpChannel(this, channel);
        ChannelListeners.invokeChannelListener(udpChannel, bindListener);
        return udpChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createPipe(ChannelListener<? super StreamChannel> leftOpenListener, ChannelListener<? super StreamChannel> rightOpenListener, OptionMap optionMap) throws IOException {
        boolean ok = false;
        Pipe in = Pipe.open();
        try {
            Pipe out = Pipe.open();
            try {
                NioPipeChannel outbound = new NioPipeChannel(this, in.sink(), out.source());
                try {
                    NioPipeChannel inbound = new NioPipeChannel(this, out.sink(), in.source());
                    try {
                        boolean establishWriting = optionMap.get(Options.WORKER_ESTABLISH_WRITING, false);
                        XnioExecutor outboundExec = establishWriting ? outbound.getWriteThread() : outbound.getReadThread();
                        XnioExecutor inboundExec = establishWriting ? inbound.getWriteThread() : inbound.getReadThread();
                        outboundExec.execute(ChannelListeners.getChannelListenerTask(outbound, leftOpenListener));
                        inboundExec.execute(ChannelListeners.getChannelListenerTask(inbound, rightOpenListener));
                        ok = true;
                    }
                    catch (RejectedExecutionException e) {
                        throw new IOException("Failed to execute open task(s)", e);
                    }
                    finally {
                        if (!ok) {
                            IoUtils.safeClose(inbound);
                        }
                    }
                }
                finally {
                    if (!ok) {
                        IoUtils.safeClose(outbound);
                    }
                }
            }
            finally {
                if (!ok) {
                    IoUtils.safeClose(out.sink());
                    IoUtils.safeClose(out.source());
                }
            }
        }
        finally {
            if (!ok) {
                IoUtils.safeClose(in.sink());
                IoUtils.safeClose(in.source());
            }
        }
    }

    @Override
    public boolean isShutdown() {
        return (this.state & Integer.MIN_VALUE) != 0;
    }

    @Override
    public boolean isTerminated() {
        return (this.state & 0x40000000) != 0;
    }

    void openResourceUnconditionally() {
        int oldState = stateUpdater.getAndIncrement(this);
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, (Object)oldState, (Object)(oldState + 1));
        }
    }

    void openResource() throws ClosedWorkerException {
        int oldState;
        do {
            if (((oldState = this.state) & Integer.MIN_VALUE) == 0) continue;
            throw new ClosedWorkerException("Worker is shutting down");
        } while (!stateUpdater.compareAndSet(this, oldState, oldState + 1));
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, (Object)oldState, (Object)(oldState + 1));
        }
    }

    void closeResource() {
        int oldState = stateUpdater.decrementAndGet(this);
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, (Object)(oldState + 1), (Object)oldState);
        }
        while (oldState == Integer.MIN_VALUE) {
            if (stateUpdater.compareAndSet(this, Integer.MIN_VALUE, -1073741824)) {
                Thread[] waiters;
                Log.log.tracef("CAS %s %08x -> %08x (close complete)", (Object)this, (Object)Integer.MIN_VALUE, (Object)-1073741824);
                for (Thread waiter : waiters = shutdownWaitersUpdater.getAndSet(this, SHUTDOWN_COMPLETE)) {
                    LockSupport.unpark(waiter);
                }
                Runnable task = this.getTerminationTask();
                if (task != null) {
                    try {
                        task.run();
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                }
                return;
            }
            oldState = this.state;
        }
    }

    @Override
    public void shutdown() {
        int oldState = this.state;
        while ((oldState & Integer.MIN_VALUE) == 0) {
            if (!stateUpdater.compareAndSet(this, oldState, oldState | Integer.MIN_VALUE)) {
                oldState = this.state;
                continue;
            }
            Log.log.tracef("Initiating shutdown of %s", (Object)this);
            for (WorkerThread worker : this.readWorkers) {
                worker.shutdown();
            }
            for (WorkerThread worker : this.writeWorkers) {
                worker.shutdown();
            }
            this.shutDownTaskPool();
            return;
        }
        Log.log.tracef("Idempotent shutdown of %s", (Object)this);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return this.shutDownTaskPoolNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Thread[] newWaiters;
        Thread[] waiters;
        int oldState = this.state;
        if ((oldState & 0x40000000) != 0) {
            return true;
        }
        long start = System.nanoTime();
        long elapsed = 0L;
        block0: do {
            if ((waiters = this.shutdownWaiters) == SHUTDOWN_COMPLETE) {
                return true;
            }
            Thread myThread = Thread.currentThread();
            for (Thread waiter : waiters) {
                if (waiter == myThread) break block0;
            }
            newWaiters = Arrays.copyOf(waiters, waiters.length + 1);
            newWaiters[waiters.length] = myThread;
        } while (!shutdownWaitersUpdater.compareAndSet(this, waiters, newWaiters));
        long nanos = unit.toNanos(timeout);
        while (((oldState = this.state) & 0x40000000) == 0) {
            LockSupport.parkNanos(this, nanos - elapsed);
            elapsed = System.nanoTime() - start;
            if (elapsed <= nanos) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void taskPoolTerminated() {
        this.closeResource();
    }

    @Override
    public NioXnio getXnio() {
        return (NioXnio)super.getXnio();
    }
}

