/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol.v1;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import org.jboss.logging.Logger;
import org.jboss.marshalling.AbstractClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remotingjmx.ServerMessageEventHandler;
import org.jboss.remotingjmx.VersionedProxy;
import org.jboss.remotingjmx.WrappedMBeanServerConnection;
import org.jboss.remotingjmx.protocol.v1.Common;
import org.xnio.IoUtils;

class ServerProxy
extends Common
implements VersionedProxy {
    private static final Logger log = Logger.getLogger(ServerProxy.class);
    private final Channel channel;
    private final WrappedMBeanServerConnection server;
    private UUID connectionId;
    private final Executor executor;
    private final ServerMessageEventHandler serverMessageEventHandler;
    private final Map<Byte, Common.MessageHandler> handlerRegistry;
    private final RemoteNotificationManager remoteNotificationManager;

    ServerProxy(Channel channel, WrappedMBeanServerConnection server, Executor executor, ServerMessageEventHandler serverMessageEventHandler) {
        super(channel);
        this.channel = channel;
        this.server = server;
        this.handlerRegistry = this.createHandlerRegistry();
        this.remoteNotificationManager = new RemoteNotificationManager();
        this.executor = executor;
        this.serverMessageEventHandler = serverMessageEventHandler;
    }

    private Map<Byte, Common.MessageHandler> createHandlerRegistry() {
        HashMap<Byte, Common.MessageHandler> registry = new HashMap<Byte, Common.MessageHandler>();
        registry.put((byte)17, new AddNotificationListenerHandler());
        registry.put((byte)1, new CreateMBeanHandler());
        registry.put((byte)8, new GetAttributeHandler());
        registry.put((byte)9, new GetAttributesHandler());
        registry.put((byte)13, new GetDefaultDomainHandler());
        registry.put((byte)14, new GetDomainsHandler());
        registry.put((byte)7, new GetMBeanCountHandler());
        registry.put((byte)15, new GetMBeanInfoHandler());
        registry.put((byte)3, new GetObjectInstanceHandler());
        registry.put((byte)16, new InstanceofHandler());
        registry.put((byte)12, new InvokeHandler());
        registry.put((byte)6, new IsRegisteredHandler());
        registry.put((byte)4, new QueryMBeansHandler());
        registry.put((byte)5, new QueryNamesHandler());
        registry.put((byte)18, new RemoveNotificationListenerHandler());
        registry.put((byte)10, new SetAttributeHandler());
        registry.put((byte)11, new SetAttributesHandler());
        registry.put((byte)2, new UnregisterMBeanHandler());
        return Collections.unmodifiableMap(registry);
    }

    void start() throws IOException {
        this.connectionId = UUID.randomUUID();
        log.debugf("Created connectionID %s", (Object)this.connectionId.toString());
        this.sendConnectionId();
        this.server.connectionOpened(this);
        this.channel.receiveMessage(new MessageReciever());
    }

    private void sendConnectionId() throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeBytes("JMX");
                output.writeUTF(ServerProxy.this.connectionId.toString());
            }
        });
        log.tracef("Written connectionId %s", (Object)this.connectionId.toString());
    }

    @Override
    public String getConnectionId() {
        return this.connectionId.toString();
    }

    @Override
    public void close() {
        try {
            this.channel.writeShutdown();
            this.channel.close();
        }
        catch (IOException e) {
            log.warn("Unable to close channel");
            this.remoteNotificationManager.removeNotificationListener();
        }
    }

    private void writeResponse(final byte inResponseTo, final int correlationId) throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(inResponseTo ^ 0xFFFFFF80);
                output.writeInt(correlationId);
                output.writeByte(0);
            }
        });
    }

    private void writeResponse(final Exception e, final byte inResponseTo, final int correlationId) throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(inResponseTo ^ 0xFFFFFF80);
                output.writeInt(correlationId);
                output.writeByte(1);
                output.writeByte(3);
                Marshaller marshaller = ServerProxy.this.prepareForMarshalling(output);
                marshaller.writeObject(e);
                marshaller.finish();
            }
        });
    }

    private void writeResponse(final boolean response, final byte inResponseTo, final int correlationId) throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(inResponseTo ^ 0xFFFFFF80);
                output.writeInt(correlationId);
                output.writeByte(0);
                output.writeByte(10);
                output.writeBoolean(response);
            }
        });
    }

    private void writeResponse(final Integer response, final byte inResponseTo, final int correlationId) throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(inResponseTo ^ 0xFFFFFF80);
                output.writeInt(correlationId);
                output.writeByte(0);
                output.writeByte(11);
                output.writeInt(response);
            }
        });
    }

    private void writeResponse(final Object response, final byte type, final byte inResponseTo, final int correlationId) throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(inResponseTo ^ 0xFFFFFF80);
                output.writeInt(correlationId);
                output.writeByte(0);
                output.writeByte(type);
                Marshaller marshaller = ServerProxy.this.prepareForMarshalling(output);
                marshaller.writeObject(response);
                marshaller.finish();
            }
        });
    }

    private void writeResponse(final String response, final byte inResponseTo, final int correlationId) throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(inResponseTo ^ 0xFFFFFF80);
                output.writeInt(correlationId);
                output.writeByte(0);
                output.writeByte(8);
                output.writeUTF(response);
            }
        });
    }

    private void writeResponse(final String[] response, final byte inResponseTo, final int correlationId) throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(inResponseTo ^ 0xFFFFFF80);
                output.writeInt(correlationId);
                output.writeByte(0);
                output.writeByte(9);
                output.writeInt(response.length);
                for (String currentDomain : response) {
                    output.writeUTF(currentDomain);
                }
            }
        });
    }

    private void writeNotification(final int listenerId, final Notification notification, final Object handback) throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeByte(19);
                output.writeInt(0);
                output.writeByte(11);
                output.writeInt(listenerId);
                output.writeByte(17);
                Marshaller marshaller = ServerProxy.this.prepareForMarshalling(output);
                marshaller.writeObject(notification);
                marshaller.writeByte(4);
                marshaller.writeObject(handback);
                marshaller.finish();
            }
        });
    }

    private void switchClassLoaderForMBean(ObjectName name, ClassLoaderSwitchingClassResolver resolver) {
        try {
            MBeanServerConnection connection = this.server.getMBeanServerConnection();
            if (connection instanceof MBeanServer) {
                MBeanServer server = (MBeanServer)connection;
                resolver.switchClassLoader(server.getClassLoaderFor(name));
            }
        }
        catch (InstanceNotFoundException e) {
            log.debugf((Throwable)e, "Could not get class loader for %s", (Object)name);
        }
    }

    private void switchClassLoaderForLoader(ObjectName name, ClassLoaderSwitchingClassResolver resolver) {
        try {
            MBeanServerConnection connection = this.server.getMBeanServerConnection();
            if (connection instanceof MBeanServer) {
                MBeanServer server = (MBeanServer)connection;
                resolver.switchClassLoader(server.getClassLoader(name));
            }
        }
        catch (InstanceNotFoundException e) {
            log.debugf((Throwable)e, "Could not get class loader for %s", (Object)name);
        }
    }

    static /* synthetic */ void access$3900(ServerProxy x0, ObjectName x1, ClassLoaderSwitchingClassResolver x2) {
        x0.switchClassLoaderForLoader(x1, x2);
    }

    private class ClassLoaderSwitchingClassResolver
    extends AbstractClassResolver {
        private ClassLoader currentClassLoader;

        ClassLoaderSwitchingClassResolver(ClassLoader classLoader) {
            this.currentClassLoader = classLoader;
        }

        void switchClassLoader(ClassLoader newCL) {
            this.currentClassLoader = newCL;
        }

        @Override
        protected ClassLoader getClassLoader() {
            return this.currentClassLoader;
        }
    }

    private class UnregisterMBeanHandler
    implements Common.MessageHandler {
        private UnregisterMBeanHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            ObjectName objectName;
            log.trace("UnregisterMBean");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input);
            try {
                objectName = unmarshaller.readObject(ObjectName.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            try {
                ServerProxy.this.server.getMBeanServerConnection().unregisterMBean(objectName);
                ServerProxy.this.writeResponse((byte)2, correlationId);
                log.tracef("[%d] UnregisterMBean - Success Response Sent", (Object)correlationId);
            }
            catch (MBeanRegistrationException e) {
                ServerProxy.this.writeResponse(e, (byte)2, correlationId);
                log.tracef("[%d] UnregisterMBean - Failure Response Sent", (Object)correlationId);
            }
            catch (InstanceNotFoundException e) {
                ServerProxy.this.writeResponse(e, (byte)2, correlationId);
                log.tracef("[%d] UnregisterMBean - Failure Response Sent", (Object)correlationId);
            }
        }
    }

    private class SetAttributesHandler
    implements Common.MessageHandler {
        private SetAttributesHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            AttributeList attributes;
            ObjectName objectName;
            log.trace("SetAttributes");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            ClassLoaderSwitchingClassResolver resolver = new ClassLoaderSwitchingClassResolver(ServerProxy.class.getClassLoader());
            Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input, resolver);
            try {
                objectName = unmarshaller.readObject(ObjectName.class);
                ServerProxy.this.switchClassLoaderForMBean(objectName, resolver);
                paramType = unmarshaller.readByte();
                if (paramType != 2) {
                    throw new IOException("Unexpected paramType");
                }
                attributes = unmarshaller.readObject(AttributeList.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            try {
                AttributeList attributeValues = ServerProxy.this.server.getMBeanServerConnection().setAttributes(objectName, attributes);
                ServerProxy.this.writeResponse(attributeValues, (byte)2, (byte)11, correlationId);
                log.tracef("[%d] SetAttributes - Success Response Sent", (Object)correlationId);
            }
            catch (InstanceNotFoundException e) {
                ServerProxy.this.writeResponse(e, (byte)11, correlationId);
                log.tracef("[%d] SetAttributes - Failure Response Sent", (Object)correlationId);
            }
            catch (ReflectionException e) {
                ServerProxy.this.writeResponse(e, (byte)11, correlationId);
                log.tracef("[%d] SetAttributes - Failure Response Sent", (Object)correlationId);
            }
        }
    }

    private class SetAttributeHandler
    implements Common.MessageHandler {
        private SetAttributeHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            Attribute attr;
            ObjectName objectName;
            log.trace("SetAttribute");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            ClassLoaderSwitchingClassResolver resolver = new ClassLoaderSwitchingClassResolver(ServerProxy.class.getClassLoader());
            Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input, resolver);
            try {
                objectName = unmarshaller.readObject(ObjectName.class);
                ServerProxy.this.switchClassLoaderForMBean(objectName, resolver);
                paramType = unmarshaller.readByte();
                if (paramType != 1) {
                    throw new IOException("Unexpected paramType");
                }
                attr = unmarshaller.readObject(Attribute.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            try {
                ServerProxy.this.server.getMBeanServerConnection().setAttribute(objectName, attr);
                ServerProxy.this.writeResponse((byte)10, correlationId);
                log.tracef("[%d] SetAttribute - Success Response Sent", (Object)correlationId);
            }
            catch (InstanceNotFoundException e) {
                ServerProxy.this.writeResponse(e, (byte)10, correlationId);
                log.tracef("[%d] SetAttribute - Failure Response Sent", (Object)correlationId);
            }
            catch (InvalidAttributeValueException e) {
                ServerProxy.this.writeResponse(e, (byte)10, correlationId);
                log.tracef("[%d] SetAttribute - Failure Response Sent", (Object)correlationId);
            }
            catch (AttributeNotFoundException e) {
                ServerProxy.this.writeResponse(e, (byte)10, correlationId);
                log.tracef("[%d] SetAttribute - Failure Response Sent", (Object)correlationId);
            }
            catch (ReflectionException e) {
                ServerProxy.this.writeResponse(e, (byte)10, correlationId);
                log.tracef("[%d] SetAttribute - Failure Response Sent", (Object)correlationId);
            }
            catch (MBeanException e) {
                ServerProxy.this.writeResponse(e, (byte)10, correlationId);
                log.tracef("[%d] SetAttribute - Failure Response Sent", (Object)correlationId);
            }
        }
    }

    private class QueryNamesHandler
    implements Common.MessageHandler {
        private QueryNamesHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            QueryExp query;
            ObjectName objectName;
            log.trace("QueryNames");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            try {
                Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input);
                objectName = unmarshaller.readObject(ObjectName.class);
                paramType = unmarshaller.readByte();
                if (paramType != 7) {
                    throw new IOException("Unexpected paramType");
                }
                query = unmarshaller.readObject(QueryExp.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            Set<ObjectName> instances = ServerProxy.this.server.getMBeanServerConnection().queryNames(objectName, query);
            ServerProxy.this.writeResponse(instances, (byte)15, (byte)5, correlationId);
            log.tracef("[%d] QueryNames - Success Response Sent", (Object)correlationId);
        }
    }

    private class QueryMBeansHandler
    implements Common.MessageHandler {
        private QueryMBeansHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            QueryExp query;
            ObjectName objectName;
            log.trace("QueryMBeans");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            try {
                Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input);
                objectName = unmarshaller.readObject(ObjectName.class);
                paramType = unmarshaller.readByte();
                if (paramType != 7) {
                    throw new IOException("Unexpected paramType");
                }
                query = unmarshaller.readObject(QueryExp.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            Set<ObjectInstance> instances = ServerProxy.this.server.getMBeanServerConnection().queryMBeans(objectName, query);
            ServerProxy.this.writeResponse(instances, (byte)13, (byte)4, correlationId);
            log.tracef("[%d] QueryMBeans - Success Response Sent", (Object)correlationId);
        }
    }

    private class RemoveNotificationListenerHandler
    implements Common.MessageHandler {
        private RemoveNotificationListenerHandler() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            ServerProxy.access$2200().trace("RemoveNotificationListener");
            paramType = input.readByte();
            if (paramType != 11) {
                throw new IOException("Unexpected paramType");
            }
            count = input.readInt();
            if (count != 1 && count != 2 && count != 4) {
                throw new IOException("Invalid count received.");
            }
            toRemove = null;
            name = null;
            listener = null;
            filter = null;
            handback = null;
            if (count == 1) {
                paramType = input.readByte();
                if (paramType != 18) {
                    throw new IOException("Unexpected paramType");
                }
                itemCount = input.readInt();
                toRemove = new int[itemCount];
                for (i = 0; i < itemCount; ++i) {
                    toRemove[i] = input.readInt();
                }
            } else {
                paramType = input.readByte();
                if (paramType != 6) {
                    throw new IOException("Unexpected paramType");
                }
                unmarshaller = ServerProxy.this.prepareForUnMarshalling(input);
                try {
                    name = unmarshaller.readObject(ObjectName.class);
                    paramType = unmarshaller.readByte();
                    if (paramType != 6) {
                        throw new IOException("Unexpected paramType");
                    }
                    listener = unmarshaller.readObject(ObjectName.class);
                    if (count != 4) ** GOTO lbl45
                    paramType = unmarshaller.readByte();
                    if (paramType != 16) {
                        throw new IOException("Unexpected paramType");
                    }
                    filter = unmarshaller.readObject(NotificationFilter.class);
                    paramType = unmarshaller.readByte();
                    if (paramType != 4) {
                        throw new IOException("Unexpected paramType");
                    }
                    handback = unmarshaller.readObject();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IOException(cnfe);
                }
            }
lbl45:
            // 3 sources

            try {
                if (count == 1) {
                    RemoteNotificationManager.access$4600(ServerProxy.access$2700(ServerProxy.this), toRemove);
                } else if (count == 2) {
                    ServerProxy.access$2800(ServerProxy.this).getMBeanServerConnection().removeNotificationListener(name, listener);
                } else {
                    ServerProxy.access$2800(ServerProxy.this).getMBeanServerConnection().removeNotificationListener(name, listener, filter, handback);
                }
                ServerProxy.access$3800(ServerProxy.this, (byte)18, correlationId);
                ServerProxy.access$2200().tracef("[%d] RemoveNotificationListener - Success Response Sent", (Object)correlationId);
            }
            catch (InstanceNotFoundException e) {
                ServerProxy.access$2500(ServerProxy.this, e, (byte)18, correlationId);
                ServerProxy.access$2200().tracef("[%d] RemoveNotificationListener - Failure Response Sent", (Object)correlationId);
            }
            catch (ListenerNotFoundException e) {
                ServerProxy.access$2500(ServerProxy.this, e, (byte)18, correlationId);
                ServerProxy.access$2200().tracef("[%d] RemoveNotificationListener - Failure Response Sent", (Object)correlationId);
            }
        }
    }

    private class InvokeHandler
    implements Common.MessageHandler {
        private InvokeHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            String[] signature;
            Object[] params;
            String operationName;
            ObjectName objectName;
            log.trace("Invoke");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            ClassLoaderSwitchingClassResolver resolver = new ClassLoaderSwitchingClassResolver(ServerProxy.class.getClassLoader());
            Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input, resolver);
            try {
                int i;
                objectName = unmarshaller.readObject(ObjectName.class);
                ServerProxy.this.switchClassLoaderForMBean(objectName, resolver);
                paramType = unmarshaller.readByte();
                if (paramType != 8) {
                    throw new IOException("Unexpected paramType");
                }
                operationName = unmarshaller.readUTF();
                paramType = unmarshaller.readByte();
                if (paramType != 5) {
                    throw new IOException("Unexpected paramType");
                }
                int count = unmarshaller.readInt();
                params = new Object[count];
                for (i = 0; i < count; ++i) {
                    params[i] = unmarshaller.readObject();
                }
                paramType = unmarshaller.readByte();
                if (paramType != 9) {
                    throw new IOException("Unexpected paramType");
                }
                count = unmarshaller.readInt();
                signature = new String[count];
                for (i = 0; i < count; ++i) {
                    signature[i] = unmarshaller.readUTF();
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            try {
                Object result = ServerProxy.this.server.getMBeanServerConnection().invoke(objectName, operationName, params, signature);
                ServerProxy.this.writeResponse(result, (byte)4, (byte)12, correlationId);
                log.tracef("[%d] Invoke - Success Response Sent", (Object)correlationId);
            }
            catch (InstanceNotFoundException e) {
                ServerProxy.this.writeResponse(e, (byte)12, correlationId);
                log.tracef("[%d] Invoke - Failure Response Sent", (Object)correlationId);
            }
            catch (ReflectionException e) {
                ServerProxy.this.writeResponse(e, (byte)12, correlationId);
                log.tracef("[%d] Invoke - Failure Response Sent", (Object)correlationId);
            }
            catch (MBeanException e) {
                ServerProxy.this.writeResponse(e, (byte)12, correlationId);
                log.tracef("[%d] Invoke - Failure Response Sent", (Object)correlationId);
            }
        }
    }

    private class IsRegisteredHandler
    implements Common.MessageHandler {
        private IsRegisteredHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            ObjectName objectName;
            log.trace("IsRegistered");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input);
            try {
                objectName = unmarshaller.readObject(ObjectName.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            boolean registered = ServerProxy.this.server.getMBeanServerConnection().isRegistered(objectName);
            ServerProxy.this.writeResponse(registered, (byte)6, correlationId);
            log.tracef("[%d] IsRegistered - Success Response Sent", (Object)correlationId);
        }
    }

    private class InstanceofHandler
    implements Common.MessageHandler {
        private InstanceofHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            ObjectName objectName;
            log.trace("IsInstanceOf");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input);
            try {
                objectName = unmarshaller.readObject(ObjectName.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            paramType = unmarshaller.readByte();
            if (paramType != 8) {
                throw new IOException("Unexpected paramType");
            }
            String className = unmarshaller.readUTF();
            try {
                boolean instanceOf = ServerProxy.this.server.getMBeanServerConnection().isInstanceOf(objectName, className);
                ServerProxy.this.writeResponse(instanceOf, (byte)16, correlationId);
                log.tracef("[%d] IsInstanceOf - Success Response Sent", (Object)correlationId);
            }
            catch (InstanceNotFoundException e) {
                ServerProxy.this.writeResponse(e, (byte)16, correlationId);
                log.tracef("[%d] IsInstanceOf - Failure Response Sent", (Object)correlationId);
            }
        }
    }

    private class GetObjectInstanceHandler
    implements Common.MessageHandler {
        private GetObjectInstanceHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            ObjectName objectName;
            log.trace("GetObjectInstance");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input);
            try {
                objectName = unmarshaller.readObject(ObjectName.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            try {
                ObjectInstance objectInstance = ServerProxy.this.server.getMBeanServerConnection().getObjectInstance(objectName);
                ServerProxy.this.writeResponse(objectInstance, (byte)12, (byte)3, correlationId);
                log.tracef("[%d] GetObjectInstance - Success Response Sent", (Object)correlationId);
            }
            catch (InstanceNotFoundException e) {
                ServerProxy.this.writeResponse(e, (byte)3, correlationId);
                log.tracef("[%d] GetObjectInstance - Failure Response Sent", (Object)correlationId);
            }
        }
    }

    private class GetMBeanInfoHandler
    implements Common.MessageHandler {
        private GetMBeanInfoHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            ObjectName objectName;
            log.trace("GetMBeanInfo");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input);
            try {
                objectName = unmarshaller.readObject(ObjectName.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            try {
                MBeanInfo info = ServerProxy.this.server.getMBeanServerConnection().getMBeanInfo(objectName);
                ServerProxy.this.writeResponse(info, (byte)14, (byte)15, correlationId);
                log.tracef("[%d] GetMBeanInfo - Success Response Sent", (Object)correlationId);
            }
            catch (IntrospectionException e) {
                ServerProxy.this.writeResponse(e, (byte)14, correlationId);
                log.tracef("[%d] GetMBeanInfo - Failure Response Sent", (Object)correlationId);
            }
            catch (InstanceNotFoundException e) {
                ServerProxy.this.writeResponse(e, (byte)14, correlationId);
                log.tracef("[%d] GetMBeanInfo - Failure Response Sent", (Object)correlationId);
            }
            catch (ReflectionException e) {
                ServerProxy.this.writeResponse(e, (byte)14, correlationId);
                log.tracef("[%d] GetMBeanInfo - Failure Response Sent", (Object)correlationId);
            }
        }
    }

    private class GetAttributesHandler
    implements Common.MessageHandler {
        private GetAttributesHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            ObjectName objectName;
            log.trace("GetAttributes");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input);
            try {
                objectName = unmarshaller.readObject(ObjectName.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            paramType = unmarshaller.readByte();
            if (paramType != 9) {
                throw new IOException("Unexpected paramType");
            }
            int count = unmarshaller.readInt();
            String[] attributes = new String[count];
            for (int i = 0; i < count; ++i) {
                attributes[i] = unmarshaller.readUTF();
            }
            try {
                AttributeList attributeValues = ServerProxy.this.server.getMBeanServerConnection().getAttributes(objectName, attributes);
                ServerProxy.this.writeResponse(attributeValues, (byte)2, (byte)9, correlationId);
                log.tracef("[%d] GetAttributes - Success Response Sent", (Object)correlationId);
            }
            catch (InstanceNotFoundException e) {
                ServerProxy.this.writeResponse(e, (byte)9, correlationId);
                log.tracef("[%d] GetAttributes - Failure Response Sent", (Object)correlationId);
            }
            catch (ReflectionException e) {
                ServerProxy.this.writeResponse(e, (byte)9, correlationId);
                log.tracef("[%d] GetAttributes - Failure Response Sent", (Object)correlationId);
            }
        }
    }

    private class GetAttributeHandler
    implements Common.MessageHandler {
        private GetAttributeHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            ObjectName objectName;
            log.trace("GetAttribute");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input);
            try {
                objectName = unmarshaller.readObject(ObjectName.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            paramType = unmarshaller.readByte();
            if (paramType != 8) {
                throw new IOException("Unexpected paramType");
            }
            String attribute = unmarshaller.readUTF();
            try {
                Object attributeValue = ServerProxy.this.server.getMBeanServerConnection().getAttribute(objectName, attribute);
                ServerProxy.this.writeResponse(attributeValue, (byte)4, (byte)8, correlationId);
                log.tracef("[%d] GetAttribute - Success Response Sent", (Object)correlationId);
            }
            catch (AttributeNotFoundException e) {
                ServerProxy.this.writeResponse(e, (byte)8, correlationId);
                log.tracef("[%d] GetAttribute - Failure Response Sent", (Object)correlationId);
            }
            catch (InstanceNotFoundException e) {
                ServerProxy.this.writeResponse(e, (byte)8, correlationId);
                log.tracef("[%d] GetAttribute - Failure Response Sent", (Object)correlationId);
            }
            catch (MBeanException e) {
                ServerProxy.this.writeResponse(e, (byte)8, correlationId);
                log.tracef("[%d] GetAttribute - Failure Response Sent", (Object)correlationId);
            }
            catch (ReflectionException e) {
                ServerProxy.this.writeResponse(e, (byte)8, correlationId);
                log.tracef("[%d] GetAttribute - Failure Response Sent", (Object)correlationId);
            }
        }
    }

    private class GetMBeanCountHandler
    implements Common.MessageHandler {
        private GetMBeanCountHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            log.trace("GetMBeanCount");
            Integer count = ServerProxy.this.server.getMBeanServerConnection().getMBeanCount();
            ServerProxy.this.writeResponse(count, (byte)7, correlationId);
            log.tracef("[%d] GetMBeanCount - Success Response Sent", (Object)correlationId);
        }
    }

    private class GetDomainsHandler
    implements Common.MessageHandler {
        private GetDomainsHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            log.trace("GetDomains");
            String[] domains = ServerProxy.this.server.getMBeanServerConnection().getDomains();
            ServerProxy.this.writeResponse(domains, (byte)14, correlationId);
            log.tracef("[%d] GetDomains - Success Response Sent", (Object)correlationId);
        }
    }

    private class GetDefaultDomainHandler
    implements Common.MessageHandler {
        private GetDefaultDomainHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            log.trace("GetDefaultDomain");
            String defaultDomain = ServerProxy.this.server.getMBeanServerConnection().getDefaultDomain();
            ServerProxy.this.writeResponse(defaultDomain, (byte)13, correlationId);
            log.tracef("[%d] CreateMBean - Success Response Sent", (Object)correlationId);
        }
    }

    private class CreateMBeanHandler
    implements Common.MessageHandler {
        private CreateMBeanHandler() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            ServerProxy.access$2200().trace("CreateMBean");
            paramType = input.readByte();
            if (paramType != 11) {
                throw new IOException("Unexpected paramType");
            }
            paramCount = input.readInt();
            className = null;
            name = null;
            loader = null;
            params = null;
            signature = null;
            resolver = new ClassLoaderSwitchingClassResolver(ServerProxy.class.getClassLoader());
            unmarshaller = ServerProxy.this.prepareForUnMarshalling(input, resolver);
            block22: for (i = 0; i < paramCount; ++i) {
                param = unmarshaller.readByte();
                switch (param) {
                    case 8: {
                        if (className == null) {
                            className = unmarshaller.readUTF();
                            continue block22;
                        }
                        throw new IOException("Unexpected paramter");
                    }
                    case 6: {
                        try {
                            if (name == null) {
                                name = unmarshaller.readObject(ObjectName.class);
                                ** break;
                            }
                            if (loader == null) {
                                loader = unmarshaller.readObject(ObjectName.class);
                                ServerProxy.access$3900(ServerProxy.this, loader, resolver);
                                ** break;
                            }
                            throw new IOException("Unexpected paramter");
lbl31:
                            // 2 sources

                            continue block22;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException(e);
                        }
                    }
                    case 5: {
                        if (params == null) {
                            count = unmarshaller.readInt();
                            params = new Object[count];
                            for (j = 0; j < count; ++j) {
                                try {
                                    params[j] = unmarshaller.readObject();
                                    continue;
                                }
                                catch (ClassNotFoundException e) {
                                    throw new IOException(e);
                                }
                            }
                            continue block22;
                        }
                        throw new IOException("Unexpected paramter");
                    }
                    case 9: {
                        if (signature == null) {
                            count = unmarshaller.readInt();
                            signature = new String[count];
                            for (j = 0; j < count; ++j) {
                                signature[j] = unmarshaller.readUTF();
                            }
                            continue block22;
                        }
                        throw new IOException("Unexpected paramter");
                    }
                    default: {
                        throw new IOException("Unexpected paramter");
                    }
                }
            }
            try {
                switch (paramCount) {
                    case 2: {
                        instance = ServerProxy.access$2800(ServerProxy.this).getMBeanServerConnection().createMBean(className, name);
                        break;
                    }
                    case 3: {
                        instance = ServerProxy.access$2800(ServerProxy.this).getMBeanServerConnection().createMBean(className, name, loader);
                        break;
                    }
                    case 4: {
                        instance = ServerProxy.access$2800(ServerProxy.this).getMBeanServerConnection().createMBean(className, name, params, signature);
                        break;
                    }
                    case 5: {
                        instance = ServerProxy.access$2800(ServerProxy.this).getMBeanServerConnection().createMBean(className, name, loader, params, signature);
                        break;
                    }
                    default: {
                        throw new IOException("Unable to identify correct create method to call.");
                    }
                }
                ServerProxy.access$4000(ServerProxy.this, instance, (byte)12, (byte)1, correlationId);
                ServerProxy.access$2200().tracef("[%d] CreateMBean - Success Response Sent", (Object)correlationId);
            }
            catch (InstanceAlreadyExistsException e) {
                ServerProxy.access$2500(ServerProxy.this, e, (byte)1, correlationId);
                ServerProxy.access$2200().tracef("[%d] CreateMBean - Failure Response Sent", (Object)correlationId);
            }
            catch (NotCompliantMBeanException e) {
                ServerProxy.access$2500(ServerProxy.this, e, (byte)1, correlationId);
                ServerProxy.access$2200().tracef("[%d] CreateMBean - Failure Response Sent", (Object)correlationId);
            }
            catch (MBeanException e) {
                ServerProxy.access$2500(ServerProxy.this, e, (byte)1, correlationId);
                ServerProxy.access$2200().tracef("[%d] CreateMBean - Failure Response Sent", (Object)correlationId);
            }
            catch (ReflectionException e) {
                ServerProxy.access$2500(ServerProxy.this, e, (byte)1, correlationId);
                ServerProxy.access$2200().tracef("[%d] CreateMBean - Failure Response Sent", (Object)correlationId);
            }
            catch (InstanceNotFoundException e) {
                ServerProxy.access$2500(ServerProxy.this, e, (byte)1, correlationId);
                ServerProxy.access$2200().tracef("[%d] CreateMBean - Failure Response Sent", (Object)correlationId);
            }
            ServerProxy.access$2200().tracef("[%d] CreateMBean - Failure Response Sent", (Object)correlationId);
        }
    }

    private class AddNotificationListenerHandler
    implements Common.MessageHandler {
        private AddNotificationListenerHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            Object handback;
            NotificationFilter filter;
            boolean remoteNotification;
            ObjectName name;
            log.trace("AddNotificationListener");
            byte paramType = input.readByte();
            if (paramType != 6) {
                throw new IOException("Unexpected paramType");
            }
            Unmarshaller unmarshaller = ServerProxy.this.prepareForUnMarshalling(input);
            int listenerId = -1;
            ObjectName listener = null;
            try {
                name = unmarshaller.readObject(ObjectName.class);
                paramType = unmarshaller.readByte();
                if (paramType == 11) {
                    remoteNotification = true;
                    listenerId = unmarshaller.readInt();
                } else if (paramType == 6) {
                    remoteNotification = false;
                    listener = unmarshaller.readObject(ObjectName.class);
                } else {
                    throw new IOException("Unexpected paramType");
                }
                paramType = unmarshaller.readByte();
                if (paramType != 16) {
                    throw new IOException("Unexpected paramType");
                }
                filter = unmarshaller.readObject(NotificationFilter.class);
                paramType = unmarshaller.readByte();
                if (paramType != 4) {
                    throw new IOException("Unexpected paramType");
                }
                handback = unmarshaller.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe);
            }
            try {
                if (remoteNotification) {
                    ServerProxy.this.remoteNotificationManager.addNotificationListener(name, listenerId, filter, handback);
                } else {
                    ServerProxy.this.server.getMBeanServerConnection().addNotificationListener(name, listener, filter, handback);
                }
                ServerProxy.this.writeResponse((byte)17, correlationId);
                log.tracef("[%d] AddNotificationListener - Success Response Sent", (Object)correlationId);
            }
            catch (InstanceNotFoundException e) {
                ServerProxy.this.writeResponse(e, (byte)17, correlationId);
                log.tracef("[%d] AddNotificationListener - Failure Response Sent", (Object)correlationId);
            }
        }
    }

    private class RemoteNotificationManager {
        private Map<Integer, Association> listeners = new HashMap<Integer, Association>();

        private RemoteNotificationManager() {
        }

        private synchronized void addNotificationListener(ObjectName name, int listenerId, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            NotificationProxy proxy = new NotificationProxy(listenerId);
            ServerProxy.this.server.getMBeanServerConnection().addNotificationListener(name, proxy, filter, handback);
            Association association = new Association();
            association.name = name;
            association.listener = proxy;
            association.filter = filter;
            association.handback = handback;
            this.listeners.put(listenerId, association);
        }

        private synchronized void removeNotificationListener() {
            Iterator<Integer> keys = this.listeners.keySet().iterator();
            int[] all = new int[this.listeners.size()];
            for (int i = 0; i < all.length; ++i) {
                all[i] = keys.next();
            }
            this.removeNotificationListeners(all);
        }

        private synchronized void removeNotificationListener(int listenerId) throws ListenerNotFoundException, InstanceNotFoundException, IOException {
            Association association = this.listeners.remove(listenerId);
            if (association != null) {
                ServerProxy.this.server.getMBeanServerConnection().removeNotificationListener(association.name, association.listener, association.filter, association.handback);
            } else {
                log.warnf("Request to removeNotificationListener, listener with ID %d not found.", (Object)listenerId);
            }
        }

        private void removeNotificationListeners(int[] listenerIds) {
            for (int current : listenerIds) {
                try {
                    this.removeNotificationListener(current);
                }
                catch (ListenerNotFoundException e) {
                    log.warn((Object)"Failure removing notification listener", e);
                }
                catch (InstanceNotFoundException e) {
                    log.warn((Object)"Failure removing notification listener", e);
                }
                catch (IOException e) {
                    log.warn((Object)"Failure removing notification listener", e);
                }
            }
        }

        static /* synthetic */ void access$4600(RemoteNotificationManager x0, int[] x1) {
            x0.removeNotificationListeners(x1);
        }

        private class Association {
            private ObjectName name;
            private NotificationListener listener;
            private NotificationFilter filter;
            private Object handback;

            private Association() {
            }
        }

        private class NotificationProxy
        implements NotificationListener {
            private final int listenerId;

            private NotificationProxy(int listenerId) {
                this.listenerId = listenerId;
            }

            @Override
            public void handleNotification(final Notification notification, final Object handback) {
                ServerProxy.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServerProxy.this.writeNotification(NotificationProxy.this.listenerId, notification, handback);
                        }
                        catch (IOException e) {
                            log.warnf("Unable to send notification to listener %d", (Object)NotificationProxy.this.listenerId);
                        }
                    }
                });
            }
        }
    }

    private class MessageReciever
    implements Channel.Receiver {
        private MessageReciever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Channel channel, MessageInputStream message) {
            block6: {
                final DataInputStream dis = new DataInputStream(message);
                try {
                    final byte messageId = dis.readByte();
                    final int correlationId = dis.readInt();
                    log.tracef("Message Received id(%h), correlationId(%d)", (Object)messageId, (Object)correlationId);
                    final Common.MessageHandler mh = (Common.MessageHandler)ServerProxy.this.handlerRegistry.get(messageId);
                    if (mh != null) {
                        ServerProxy.this.executor.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Throwable thrown = null;
                                try {
                                    if (ServerProxy.this.serverMessageEventHandler != null) {
                                        ServerProxy.this.serverMessageEventHandler.beforeEvent();
                                    }
                                    mh.handle(dis, correlationId);
                                }
                                catch (Throwable t) {
                                    thrown = t;
                                    if (correlationId != 0) {
                                        Exception response;
                                        if (t instanceof IOException) {
                                            response = (Exception)t;
                                        } else if (t instanceof RuntimeMBeanException) {
                                            response = (Exception)t;
                                        } else {
                                            response = new IOException("Internal server error.");
                                            log.warn((Object)"Unexpected internal error", t);
                                        }
                                        this.sendIOException(response);
                                    } else {
                                        log.error((Object)"null correlationId so error not sent to client", t);
                                    }
                                }
                                finally {
                                    if (ServerProxy.this.serverMessageEventHandler != null) {
                                        ServerProxy.this.serverMessageEventHandler.afterEvent(thrown);
                                    }
                                    IoUtils.safeClose(dis);
                                }
                            }

                            private void sendIOException(Exception e) {
                                try {
                                    ServerProxy.this.writeResponse(e, messageId, correlationId);
                                    log.tracef("[%d] %h - Success Response Sent", (Object)correlationId, (Object)messageId);
                                }
                                catch (IOException ioe) {
                                    log.error(ioe);
                                }
                            }
                        });
                        break block6;
                    }
                    throw new IOException("Unrecognised Message ID");
                }
                catch (IOException e) {
                    log.error(e);
                    IoUtils.safeClose(dis);
                }
                finally {
                    channel.receiveMessage(this);
                }
            }
        }

        @Override
        public void handleError(Channel channel, IOException error) {
            log.warn((Object)"Channel closing due to error", error);
            ServerProxy.this.remoteNotificationManager.removeNotificationListener();
            ServerProxy.this.server.connectionClosed(ServerProxy.this);
        }

        @Override
        public void handleEnd(Channel channel) {
            ServerProxy.this.remoteNotificationManager.removeNotificationListener();
            ServerProxy.this.server.connectionClosed(ServerProxy.this);
        }
    }
}

