/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.remote.JMXServiceURL;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remotingjmx.Capability;
import org.jboss.remotingjmx.Constants;
import org.jboss.remotingjmx.Version;
import org.jboss.remotingjmx.VersionedConnection;
import org.jboss.remotingjmx.protocol.CancellableDataOutputStream;
import org.jboss.remotingjmx.protocol.Versions;
import org.xnio.AbstractIoFuture;
import org.xnio.IoFuture;
import org.xnio.IoUtils;

class VersionedConectionFactory {
    private static final Logger log = Logger.getLogger(VersionedConectionFactory.class);

    VersionedConectionFactory() {
    }

    static VersionedConnection createVersionedConnection(Channel channel, Map<String, ?> environment, JMXServiceURL serviceURL) throws IOException {
        IoFuture<InitialHeader> futureHeader = ClientVersionReceiver.getInitialHeader(channel);
        IoFuture.Status result = futureHeader.await(5L, TimeUnit.SECONDS);
        switch (result) {
            case DONE: {
                break;
            }
            case FAILED: {
                throw futureHeader.getException();
            }
            default: {
                throw new IOException("Timeout out waiting for header, status=" + result.toString());
            }
        }
        InitialHeader header = futureHeader.get();
        Versions versions = new Versions(environment);
        Set<Byte> supportedVersions = versions.getSupportedVersions(VersionedConectionFactory.getRequiredCapabilities(serviceURL));
        byte highest = 0;
        for (byte current : header.versions) {
            if (!supportedVersions.contains(current) || current <= highest) continue;
            highest = current;
        }
        if (highest == 0) {
            throw new IllegalStateException("No matching supported protocol version found.");
        }
        return versions.getVersionedConnection(highest, channel, serviceURL);
    }

    private static Capability[] getRequiredCapabilities(JMXServiceURL serviceURL) {
        HashSet<Capability> requiredCapabilities = new HashSet<Capability>();
        String path = serviceURL.getURLPath();
        if (path.contains("?")) {
            requiredCapabilities.add(Capability.PASS_PARAMETERS);
        }
        return requiredCapabilities.toArray(new Capability[requiredCapabilities.size()]);
    }

    private static class VersionedIoFuture<T>
    extends AbstractIoFuture<T> {
        private VersionedIoFuture() {
        }

        @Override
        protected boolean setResult(T result) {
            return super.setResult(result);
        }

        @Override
        protected boolean setException(IOException exception) {
            return super.setException(exception);
        }
    }

    private static class InitialHeader {
        private byte[] versions;
        private byte stability;
        private String serverVersion;

        private InitialHeader() {
        }

        static /* synthetic */ byte[] access$002(InitialHeader x0, byte[] x1) {
            x0.versions = x1;
            return x1;
        }
    }

    private static class ClientVersionReceiver
    implements Channel.Receiver {
        private final VersionedIoFuture<InitialHeader> future;
        private boolean expectServerVersion = false;

        private ClientVersionReceiver(VersionedIoFuture<InitialHeader> future) {
            this.future = future;
        }

        public static IoFuture<InitialHeader> getInitialHeader(Channel channel) {
            VersionedIoFuture<InitialHeader> future = new VersionedIoFuture<InitialHeader>();
            channel.receiveMessage(new ClientVersionReceiver(future));
            return future;
        }

        private void sendVersionZeroHeader(Channel channel) throws IOException {
            log.debug("Selecting version 0x00 to receive full version list.");
            CancellableDataOutputStream dos = new CancellableDataOutputStream(channel.writeMessage());
            try {
                dos.writeBytes("JMX");
                dos.writeByte(0);
                String remotingJMXVersion = Version.getVersionString();
                byte[] versionBytes = remotingJMXVersion.getBytes("UTF-8");
                dos.writeInt(versionBytes.length);
                dos.write(versionBytes);
            }
            catch (IOException e) {
                dos.cancel();
                throw e;
            }
            finally {
                IoUtils.safeClose(dos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
            DataInputStream dis = new DataInputStream(messageInputStream);
            try {
                log.tracef("Bytes Available %d", (Object)dis.available());
                byte[] firstThree = new byte[3];
                dis.read(firstThree);
                log.tracef("First Three %s", (Object)new String(firstThree));
                if (!Arrays.equals(firstThree, Constants.JMX_BYTES)) {
                    throw new IOException("Invalid leading bytes in header.");
                }
                log.tracef("Bytes Available %d", (Object)dis.available());
                int versionCount = dis.readInt();
                log.tracef("Expecting %d versions", (Object)versionCount);
                byte[] versions = new byte[versionCount];
                dis.read(versions);
                if (log.isDebugEnabled()) {
                    StringBuffer sbVersions = new StringBuffer("Versions ");
                    for (byte current : versions) {
                        sbVersions.append(" 0x0").append(current);
                    }
                    log.debugf("Available version (%s)", (Object)sbVersions);
                }
                byte stability = dis.readByte();
                switch (stability) {
                    case 0: {
                        log.debug("Calling a stable server");
                        break;
                    }
                    case 1: {
                        log.warn("Calling a snapshot server");
                        break;
                    }
                    default: {
                        throw new IOException("Unrecognised stability value.");
                    }
                }
                String serverVersion = null;
                if (this.expectServerVersion) {
                    int length = dis.readInt();
                    byte[] versionBytes = new byte[length];
                    dis.read(versionBytes);
                    serverVersion = new String(versionBytes, "UTF-8");
                    log.debugf("Server version %s", (Object)serverVersion);
                }
                for (byte current : versions) {
                    if (current != 0) continue;
                    this.sendVersionZeroHeader(channel);
                    this.expectServerVersion = true;
                    channel.receiveMessage(this);
                    return;
                }
                InitialHeader ih = new InitialHeader();
                InitialHeader.access$002(ih, versions);
                ih.stability = stability;
                ih.serverVersion = serverVersion;
                this.future.setResult(ih);
            }
            catch (IOException e) {
                log.error((Object)"Unable to negotiate connection.", e);
                this.future.setException(e);
            }
            finally {
                IoUtils.safeClose(dis);
            }
        }

        @Override
        public void handleError(Channel channel, IOException e) {
            log.error((Object)"Error on channel", e);
            this.future.setException(e);
        }

        @Override
        public void handleEnd(Channel channel) {
            log.error("Channel ended.");
            this.future.setException(new IOException("Channel ended"));
        }
    }
}

