/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.util.internal.DeadLockProofWorker;

public final class ExecutorUtil {
    public static boolean isShutdown(Executor executor) {
        return executor instanceof ExecutorService && ((ExecutorService)executor).isShutdown();
    }

    public static void terminate(Executor ... executors) {
        ExecutorUtil.terminate(DeadLockProofWorker.PARENT, executors);
    }

    public static void terminate(ThreadLocal<Executor> deadLockChecker, Executor ... executors) {
        if (executors == null) {
            throw new NullPointerException("executors");
        }
        Executor[] executorsCopy = new Executor[executors.length];
        for (int i = 0; i < executors.length; ++i) {
            if (executors[i] == null) {
                throw new NullPointerException("executors[" + i + ']');
            }
            executorsCopy[i] = executors[i];
        }
        Executor currentParent = deadLockChecker.get();
        if (currentParent != null) {
            for (Executor e : executorsCopy) {
                if (e != currentParent) continue;
                throw new IllegalStateException("An Executor cannot be shut down from the thread acquired from itself.  Please make sure you are not calling releaseExternalResources() from an I/O worker thread.");
            }
        }
        boolean interrupted = false;
        block10: for (Executor e : executorsCopy) {
            if (!(e instanceof ExecutorService)) continue;
            ExecutorService es = (ExecutorService)e;
            while (true) {
                try {
                    es.shutdownNow();
                }
                catch (SecurityException ex) {
                    try {
                        es.shutdown();
                    }
                    catch (SecurityException ex2) {
                        continue block10;
                    }
                    catch (NullPointerException ex2) {
                    }
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
                try {
                    if (!es.awaitTermination(100L, TimeUnit.MILLISECONDS)) continue;
                    continue block10;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private ExecutorUtil() {
    }
}

