/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.replay;

import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.replay.ReplayError;
import org.jboss.netty.handler.codec.replay.ReplayingDecoderBuffer;

public abstract class ReplayingDecoder<T extends Enum<T>>
extends FrameDecoder {
    private final ReplayingDecoderBuffer replayable = new ReplayingDecoderBuffer(this);
    private T state;
    private int checkpoint;
    private boolean needsCleanup;

    protected ReplayingDecoder() {
        this(null);
    }

    protected ReplayingDecoder(boolean unfold) {
        this(null, unfold);
    }

    protected ReplayingDecoder(T initialState) {
        this(initialState, false);
    }

    protected ReplayingDecoder(T initialState, boolean unfold) {
        super(unfold);
        this.state = initialState;
    }

    @Override
    protected ChannelBuffer internalBuffer() {
        return super.internalBuffer();
    }

    protected void checkpoint() {
        ChannelBuffer cumulation = this.cumulation;
        this.checkpoint = cumulation != null ? cumulation.readerIndex() : -1;
    }

    protected void checkpoint(T state) {
        this.checkpoint();
        this.setState(state);
    }

    protected T getState() {
        return this.state;
    }

    protected T setState(T newState) {
        T oldState = this.state;
        this.state = newState;
        return oldState;
    }

    protected abstract Object decode(ChannelHandlerContext var1, Channel var2, ChannelBuffer var3, T var4) throws Exception;

    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, T state) throws Exception {
        return this.decode(ctx, channel, buffer, state);
    }

    @Override
    protected final Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        return this.decode(ctx, channel, buffer, this.state);
    }

    @Override
    protected final Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        return this.decodeLast(ctx, channel, buffer, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        block30: {
            ChannelBuffer input;
            block31: {
                block29: {
                    boolean copy;
                    int readableBytes;
                    Object m = e.getMessage();
                    if (!(m instanceof ChannelBuffer)) {
                        ctx.sendUpstream(e);
                        return;
                    }
                    input = (ChannelBuffer)m;
                    if (!input.readable()) {
                        return;
                    }
                    this.needsCleanup = true;
                    if (this.cumulation != null) break block31;
                    this.cumulation = input;
                    int oldReaderIndex = input.readerIndex();
                    int inputSize = input.readableBytes();
                    try {
                        this.callDecode(ctx, e.getChannel(), input, this.replayable, e.getRemoteAddress());
                        readableBytes = input.readableBytes();
                        if (readableBytes <= 0) break block29;
                    }
                    catch (Throwable throwable) {
                        int readableBytes2 = input.readableBytes();
                        if (readableBytes2 > 0) {
                            boolean copy2;
                            int inputCapacity = input.capacity();
                            boolean bl = copy2 = readableBytes2 != inputCapacity && inputCapacity > this.getMaxCumulationBufferCapacity();
                            if (this.checkpoint > 0) {
                                int bytesToPreserve = inputSize - (this.checkpoint - oldReaderIndex);
                                if (copy2) {
                                    ChannelBuffer cumulation;
                                    this.cumulation = cumulation = this.newCumulationBuffer(ctx, bytesToPreserve);
                                    cumulation.writeBytes(input, this.checkpoint, bytesToPreserve);
                                } else {
                                    this.cumulation = input.slice(this.checkpoint, bytesToPreserve);
                                }
                            } else if (this.checkpoint == 0) {
                                if (copy2) {
                                    ChannelBuffer cumulation;
                                    this.cumulation = cumulation = this.newCumulationBuffer(ctx, inputSize);
                                    cumulation.writeBytes(input, oldReaderIndex, inputSize);
                                    cumulation.readerIndex(input.readerIndex());
                                } else {
                                    ChannelBuffer cumulation;
                                    this.cumulation = cumulation = input.slice(oldReaderIndex, inputSize);
                                    cumulation.readerIndex(input.readerIndex());
                                }
                            } else if (copy2) {
                                ChannelBuffer cumulation;
                                this.cumulation = cumulation = this.newCumulationBuffer(ctx, input.readableBytes());
                                cumulation.writeBytes(input);
                            } else {
                                this.cumulation = input;
                            }
                        } else {
                            this.cumulation = null;
                        }
                        throw throwable;
                    }
                    int inputCapacity = input.capacity();
                    boolean bl = copy = readableBytes != inputCapacity && inputCapacity > this.getMaxCumulationBufferCapacity();
                    if (this.checkpoint > 0) {
                        int bytesToPreserve = inputSize - (this.checkpoint - oldReaderIndex);
                        if (copy) {
                            ChannelBuffer cumulation;
                            this.cumulation = cumulation = this.newCumulationBuffer(ctx, bytesToPreserve);
                            cumulation.writeBytes(input, this.checkpoint, bytesToPreserve);
                        } else {
                            this.cumulation = input.slice(this.checkpoint, bytesToPreserve);
                        }
                    } else if (this.checkpoint == 0) {
                        if (copy) {
                            ChannelBuffer cumulation;
                            this.cumulation = cumulation = this.newCumulationBuffer(ctx, inputSize);
                            cumulation.writeBytes(input, oldReaderIndex, inputSize);
                            cumulation.readerIndex(input.readerIndex());
                        } else {
                            ChannelBuffer cumulation;
                            this.cumulation = cumulation = input.slice(oldReaderIndex, inputSize);
                            cumulation.readerIndex(input.readerIndex());
                        }
                    } else if (copy) {
                        ChannelBuffer cumulation;
                        this.cumulation = cumulation = this.newCumulationBuffer(ctx, input.readableBytes());
                        cumulation.writeBytes(input);
                    } else {
                        this.cumulation = input;
                    }
                    break block30;
                }
                this.cumulation = null;
                break block30;
            }
            input = this.appendToCumulation(input);
            try {
                this.callDecode(ctx, e.getChannel(), input, this.replayable, e.getRemoteAddress());
            }
            finally {
                this.updateCumulation(ctx, input);
            }
        }
    }

    private void callDecode(ChannelHandlerContext context, Channel channel, ChannelBuffer input, ChannelBuffer replayableInput, SocketAddress remoteAddress) throws Exception {
        while (input.readable()) {
            T oldState;
            Object result;
            int oldReaderIndex;
            block5: {
                oldReaderIndex = this.checkpoint = input.readerIndex();
                result = null;
                oldState = this.state;
                try {
                    result = this.decode(context, channel, replayableInput, this.state);
                    if (result == null) {
                        if (oldReaderIndex != input.readerIndex() || oldState != this.state) continue;
                        throw new IllegalStateException("null cannot be returned if no data is consumed and state didn't change.");
                    }
                }
                catch (ReplayError replay) {
                    int checkpoint = this.checkpoint;
                    if (checkpoint < 0) break block5;
                    input.readerIndex(checkpoint);
                }
            }
            if (result == null) break;
            if (oldReaderIndex == input.readerIndex() && oldState == this.state) {
                throw new IllegalStateException("decode() method must consume at least one byte if it returned a decoded message (caused by: " + this.getClass() + ')');
            }
            this.unfoldAndFireMessageReceived(context, remoteAddress, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanup(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            ChannelBuffer cumulation = this.cumulation;
            if (!this.needsCleanup) {
                return;
            }
            this.needsCleanup = false;
            this.replayable.terminate();
            if (cumulation != null && cumulation.readable()) {
                this.callDecode(ctx, e.getChannel(), cumulation, this.replayable, null);
            }
            Object partiallyDecoded = this.decodeLast(ctx, e.getChannel(), this.replayable, this.state);
            this.cumulation = null;
            if (partiallyDecoded != null) {
                this.unfoldAndFireMessageReceived(ctx, null, partiallyDecoded);
            }
        }
        catch (ReplayError replayError) {
        }
        finally {
            ctx.sendUpstream(e);
        }
    }
}

