/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.oio;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.jboss.netty.channel.socket.oio.OioDatagramChannel;
import org.jboss.netty.channel.socket.oio.OioDatagramPipelineSink;
import org.jboss.netty.util.internal.ExecutorUtil;

public class OioDatagramChannelFactory
implements DatagramChannelFactory {
    private final Executor workerExecutor;
    final OioDatagramPipelineSink sink;
    private boolean shutdownExecutor;

    public OioDatagramChannelFactory() {
        this(Executors.newCachedThreadPool());
        this.shutdownExecutor = true;
    }

    public OioDatagramChannelFactory(Executor workerExecutor) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        this.workerExecutor = workerExecutor;
        this.sink = new OioDatagramPipelineSink(workerExecutor);
    }

    @Override
    public DatagramChannel newChannel(ChannelPipeline pipeline) {
        return new OioDatagramChannel(this, pipeline, this.sink);
    }

    @Override
    public void shutdown() {
        if (this.shutdownExecutor) {
            ExecutorUtil.terminate(this.workerExecutor);
        }
    }

    @Override
    public void releaseExternalResources() {
        this.shutdown();
        ExecutorUtil.terminate(this.workerExecutor);
    }
}

