/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.oio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.DatagramChannelConfig;
import org.jboss.netty.channel.socket.DefaultDatagramChannelConfig;
import org.jboss.netty.channel.socket.oio.AbstractOioChannel;

final class OioDatagramChannel
extends AbstractOioChannel
implements DatagramChannel {
    final MulticastSocket socket;
    private final DatagramChannelConfig config;

    OioDatagramChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        super(null, factory, pipeline, sink);
        try {
            this.socket = new MulticastSocket(null);
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a datagram socket.", e);
        }
        try {
            this.socket.setSoTimeout(10);
            this.socket.setBroadcast(false);
        }
        catch (SocketException e) {
            throw new ChannelException("Failed to configure the datagram socket timeout.", e);
        }
        this.config = new DefaultDatagramChannelConfig(this.socket);
        Channels.fireChannelOpen(this);
    }

    @Override
    public DatagramChannelConfig getConfig() {
        return this.config;
    }

    @Override
    public ChannelFuture joinGroup(InetAddress multicastAddress) {
        this.ensureBound();
        try {
            this.socket.joinGroup(multicastAddress);
            return Channels.succeededFuture(this);
        }
        catch (IOException e) {
            return Channels.failedFuture(this, e);
        }
    }

    @Override
    public ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        this.ensureBound();
        try {
            this.socket.joinGroup(multicastAddress, networkInterface);
            return Channels.succeededFuture(this);
        }
        catch (IOException e) {
            return Channels.failedFuture(this, e);
        }
    }

    private void ensureBound() {
        if (!this.isBound()) {
            throw new IllegalStateException(DatagramChannel.class.getName() + " must be bound to join a group.");
        }
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress multicastAddress) {
        try {
            this.socket.leaveGroup(multicastAddress);
            return Channels.succeededFuture(this);
        }
        catch (IOException e) {
            return Channels.failedFuture(this, e);
        }
    }

    @Override
    public ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        try {
            this.socket.leaveGroup(multicastAddress, networkInterface);
            return Channels.succeededFuture(this);
        }
        catch (IOException e) {
            return Channels.failedFuture(this, e);
        }
    }

    @Override
    boolean isSocketBound() {
        return this.socket.isBound();
    }

    @Override
    boolean isSocketConnected() {
        return this.socket.isConnected();
    }

    @Override
    InetSocketAddress getLocalSocketAddress() throws Exception {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    @Override
    InetSocketAddress getRemoteSocketAddress() throws Exception {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    @Override
    void closeSocket() {
        this.socket.close();
    }

    @Override
    boolean isSocketClosed() {
        return this.socket.isClosed();
    }
}

