/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.socket.nio.Boss;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.internal.ExecutorUtil;

public abstract class AbstractNioBossPool<E extends Boss>
implements BossPool<E>,
ExternalResourceReleasable {
    private final Boss[] bosses;
    private final AtomicInteger bossIndex = new AtomicInteger();
    private final Executor bossExecutor;
    private volatile boolean initDone;

    AbstractNioBossPool(Executor bossExecutor, int bossCount) {
        this(bossExecutor, bossCount, true);
    }

    AbstractNioBossPool(Executor bossExecutor, int bossCount, boolean autoInit) {
        if (bossExecutor == null) {
            throw new NullPointerException("bossExecutor");
        }
        if (bossCount <= 0) {
            throw new IllegalArgumentException("bossCount (" + bossCount + ") " + "must be a positive integer.");
        }
        this.bosses = new Boss[bossCount];
        this.bossExecutor = bossExecutor;
        if (autoInit) {
            this.init();
        }
    }

    protected void init() {
        if (this.initDone) {
            throw new IllegalStateException("Init was done before");
        }
        this.initDone = true;
        for (int i = 0; i < this.bosses.length; ++i) {
            this.bosses[i] = this.newBoss(this.bossExecutor);
        }
    }

    protected abstract E newBoss(Executor var1);

    @Override
    public E nextBoss() {
        return (E)this.bosses[Math.abs(this.bossIndex.getAndIncrement() % this.bosses.length)];
    }

    @Override
    public void rebuildSelectors() {
        for (Boss boss : this.bosses) {
            boss.rebuildSelector();
        }
    }

    @Override
    public void releaseExternalResources() {
        this.shutdown();
        ExecutorUtil.terminate(this.bossExecutor);
    }

    @Override
    public void shutdown() {
        for (Boss boss : this.bosses) {
            boss.shutdown();
        }
    }
}

