/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.Closeable;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.ejb.client.remoting.NetworkUtil;
import org.jboss.ejb.client.remoting.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.security.UserInfo;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class ConnectionPool {
    private static final Logger logger = Logger.getLogger(ConnectionPool.class);
    static final ConnectionPool INSTANCE = new ConnectionPool();
    private final ConcurrentMap<CacheKey, PooledConnection> cache = new ConcurrentHashMap<CacheKey, PooledConnection>();

    private ConnectionPool() {
    }

    synchronized Connection getConnection(Endpoint clientEndpoint, String host, int port, EJBClientConfiguration.CommonConnectionCreationConfiguration connectionConfiguration) throws IOException {
        CacheKey key = new CacheKey(clientEndpoint, connectionConfiguration.getCallbackHandler(), connectionConfiguration.getConnectionCreationOptions(), host, port);
        PooledConnection pooledConnection = (PooledConnection)this.cache.get(key);
        if (pooledConnection == null) {
            IoFuture<Connection> futureConnection = NetworkUtil.connect(clientEndpoint, host, port, null, connectionConfiguration.getConnectionCreationOptions(), connectionConfiguration.getCallbackHandler(), null);
            Connection connection = IoFutureHelper.get(futureConnection, connectionConfiguration.getConnectionTimeout(), TimeUnit.MILLISECONDS);
            connection.addCloseHandler(new CacheEntryRemovalHandler(key));
            pooledConnection = new PooledConnection(key, connection);
            this.cache.put(key, pooledConnection);
        }
        pooledConnection.referenceCount.incrementAndGet();
        return pooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void release(CacheKey connectionHash, boolean async) {
        PooledConnection pooledConnection = (PooledConnection)this.cache.get(connectionHash);
        if (pooledConnection == null) {
            return;
        }
        if (pooledConnection.referenceCount.decrementAndGet() == 0) {
            try {
                Connection connection = pooledConnection.underlyingConnection;
                if (async) {
                    connection.closeAsync();
                } else {
                    ConnectionPool.safeClose(connection);
                }
            }
            finally {
                this.cache.remove(connectionHash);
            }
        }
    }

    private synchronized void shutdown() {
        for (Map.Entry entry : this.cache.entrySet()) {
            Connection connection = ((PooledConnection)entry.getValue()).underlyingConnection;
            ConnectionPool.safeClose(connection);
        }
        this.cache.clear();
    }

    private static void safeClose(Closeable closable) {
        try {
            closable.close();
        }
        catch (Throwable t) {
            logger.debug((Object)("Failed to close " + closable), t);
        }
    }

    static {
        SecurityActions.addShutdownHook(new Thread(new ShutdownTask(INSTANCE)));
    }

    private class CacheEntryRemovalHandler
    implements CloseHandler<HandleableCloseable> {
        private final CacheKey key;

        CacheEntryRemovalHandler(CacheKey key) {
            this.key = key;
        }

        @Override
        public void handleClose(HandleableCloseable closable, IOException e) {
            ConnectionPool.this.cache.remove(this.key);
        }
    }

    private static final class ShutdownTask
    implements Runnable {
        private final ConnectionPool pool;

        ShutdownTask(ConnectionPool pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            this.pool.shutdown();
        }
    }

    private final class PooledConnection
    implements Connection {
        private final AtomicInteger referenceCount = new AtomicInteger(0);
        private final CacheKey cacheKey;
        private final Connection underlyingConnection;

        PooledConnection(CacheKey key, Connection connection) {
            this.cacheKey = key;
            this.underlyingConnection = connection;
        }

        @Override
        public void close() throws IOException {
            ConnectionPool.this.release(this.cacheKey, false);
        }

        @Override
        public void closeAsync() {
            ConnectionPool.this.release(this.cacheKey, true);
        }

        @Override
        public void awaitClosed() throws InterruptedException {
            this.underlyingConnection.awaitClosed();
        }

        @Override
        public void awaitClosedUninterruptibly() {
            this.underlyingConnection.awaitClosedUninterruptibly();
        }

        @Override
        public HandleableCloseable.Key addCloseHandler(CloseHandler<? super Connection> closeHandler) {
            return this.underlyingConnection.addCloseHandler(closeHandler);
        }

        @Override
        public Collection<Principal> getPrincipals() {
            return this.underlyingConnection.getPrincipals();
        }

        @Override
        public UserInfo getUserInfo() {
            return this.underlyingConnection.getUserInfo();
        }

        @Override
        public IoFuture<Channel> openChannel(String s, OptionMap options) {
            return this.underlyingConnection.openChannel(s, options);
        }

        @Override
        public String getRemoteEndpointName() {
            return this.underlyingConnection.getRemoteEndpointName();
        }

        @Override
        public Endpoint getEndpoint() {
            return this.underlyingConnection.getEndpoint();
        }

        @Override
        public Attachments getAttachments() {
            return this.underlyingConnection.getAttachments();
        }
    }

    private static final class CacheKey {
        final Endpoint endpoint;
        final String host;
        final int port;
        final OptionMap connectOptions;
        final CallbackHandler callbackHandler;

        private CacheKey(Endpoint endpoint, CallbackHandler callbackHandler, OptionMap connectOptions, String host, int port) {
            this.endpoint = endpoint;
            this.callbackHandler = callbackHandler;
            this.connectOptions = connectOptions;
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.port != cacheKey.port) {
                return false;
            }
            if (this.callbackHandler != null ? !this.callbackHandler.equals(cacheKey.callbackHandler) : cacheKey.callbackHandler != null) {
                return false;
            }
            if (this.connectOptions != null ? !this.connectOptions.equals(cacheKey.connectOptions) : cacheKey.connectOptions != null) {
                return false;
            }
            if (this.endpoint != null ? !this.endpoint.equals(cacheKey.endpoint) : cacheKey.endpoint != null) {
                return false;
            }
            return !(this.host != null ? !this.host.equals(cacheKey.host) : cacheKey.host != null);
        }

        public int hashCode() {
            int result = this.endpoint != null ? this.endpoint.hashCode() : 0;
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + this.port;
            result = 31 * result + (this.connectOptions != null ? this.connectOptions.hashCode() : 0);
            result = 31 * result + (this.callbackHandler != null ? this.callbackHandler.hashCode() : 0);
            return result;
        }
    }
}

