/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.util.ejb;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.jboss.logging.Logger;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.JBossTestServices;
import org.jboss.test.util.ejb.EJBTestRunner;
import org.jboss.test.util.ejb.EJBTestRunnerHome;
import org.jboss.test.util.ejb.RemoteAssertionFailedError;
import org.jboss.test.util.ejb.RemoteTestException;

public class EJBTestCase
extends TestCase {
    private static final Logger log = Logger.getLogger(EJBTestCase.class);
    private boolean serverSide = false;
    protected Properties props;

    public static AbstractTestDelegate getDelegate(Class clazz) throws Exception {
        JBossTestServices delegate = new JBossTestServices(clazz);
        return delegate;
    }

    public EJBTestCase(String methodName) {
        super(methodName);
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public String getEJBRunnerJndiName() {
        return "ejb/EJBTestRunner";
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestResult result) {
        ClassLoader oldClassLoader = null;
        try {
            if (!this.isServerSide()) {
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            super.run(result);
            Object var4_3 = null;
            if (oldClassLoader != null) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oldClassLoader != null) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runBare() throws Throwable {
        if (this.isServerSide()) {
            super.runBare();
            return;
        }
        EJBTestRunner testRunner = null;
        try {
            try {
                testRunner = this.getEJBTestRunner();
                if (this.props != null) {
                    testRunner.run(this.getClass().getName(), this.getName(), this.props);
                }
                testRunner.run(this.getClass().getName(), this.getName());
            }
            catch (RemoteTestException e) {
                Throwable remote = e.getRemoteThrowable();
                if (!(remote instanceof AssertionFailedError)) throw e;
                throw new RemoteAssertionFailedError((AssertionFailedError)remote, e.getRemoteStackTrace());
            }
            Object var5_2 = null;
            if (testRunner == null) return;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (testRunner == null) throw throwable;
            testRunner.remove();
            throw throwable;
        }
        testRunner.remove();
    }

    public void setUpEJB(Properties props) throws Exception {
        this.props = props;
        this.setUpEJB();
    }

    public void setUpEJB() throws Exception {
    }

    protected int getThreadCount() {
        int result = Integer.getInteger("jbosstest.threadcount", 10);
        log.debug((Object)("jbosstest.threadcount=" + result));
        return result;
    }

    protected int getIterationCount() {
        int result = Integer.getInteger("jbosstest.iterationcount", 1000);
        log.debug((Object)("jbosstest.iterationcount=" + result));
        return result;
    }

    protected int getBeanCount() {
        int result = Integer.getInteger("jbosstest.beancount", 100);
        log.debug((Object)("jbosstest.beancount=" + result));
        return result;
    }

    public void tearDownEJB(Properties props) throws Exception {
        this.tearDownEJB();
    }

    public void tearDownEJB() throws Exception {
    }

    private EJBTestRunner getEJBTestRunner() throws Exception {
        InitialContext jndiContext = new InitialContext();
        String name = this.getEJBRunnerJndiName();
        Object ref = jndiContext.lookup(name);
        EJBTestRunnerHome runnerHome = (EJBTestRunnerHome)PortableRemoteObject.narrow((Object)ref, EJBTestRunnerHome.class);
        return runnerHome.create();
    }
}

