/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.composite.ResourceTypeTemplateCountComposite;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceFacetsCache;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerRemote;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.QueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class ResourceTypeManagerBean
implements ResourceTypeManagerLocal,
ResourceTypeManagerRemote {
    private final Log log = LogFactory.getLog(ResourceTypeManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    @IgnoreDependency
    private ResourceManagerLocal resourceManager;

    @Override
    public ResourceType getResourceTypeById(Subject subject, int id) throws ResourceTypeNotFoundException {
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)id);
        if (resourceType == null) {
            throw new ResourceTypeNotFoundException("Resource type with id [" + id + "] does not exist.");
        }
        return resourceType;
    }

    @Override
    public ResourceType getResourceTypeByNameAndPlugin(Subject subject, String name, String plugin) {
        return this.getResourceTypeByNameAndPlugin(name, plugin);
    }

    @Override
    public ResourceType getResourceTypeByNameAndPlugin(String name, String plugin) {
        try {
            Query query = this.entityManager.createNamedQuery("ResourceType.findByNameAndPlugin");
            query.setParameter("name", (Object)name);
            query.setParameter("plugin", (Object)plugin);
            return (ResourceType)query.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Override
    public List<ResourceType> getChildResourceTypes(Subject subject, ResourceType parent) {
        Query query = null;
        if (this.authorizationManager.isInventoryManager(subject)) {
            query = this.entityManager.createNamedQuery("ResourceType.findChildren_admin");
        } else {
            query = this.entityManager.createNamedQuery("ResourceType.findChildren");
            query.setParameter("subject", (Object)subject);
        }
        query.setParameter("parent", (Object)parent);
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<ResourceType> getChildResourceTypesByCategory(Subject subject, Resource parentResource, ResourceCategory category) {
        Query query = this.authorizationManager.isInventoryManager(subject) ? this.entityManager.createNamedQuery("ResourceType.findChildrenByCategory_admin") : this.entityManager.createNamedQuery("ResourceType.findChildrenByCategory");
        query.setParameter(1, (Object)parentResource.getId());
        query.setParameter(2, (Object)category.name());
        query.setParameter(3, (Object)parentResource.getId());
        query.setParameter(4, (Object)category.name());
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<ResourceType> getUtilizedChildResourceTypesByCategory(Subject subject, Resource parentResource, ResourceCategory category) {
        Query query;
        if (this.authorizationManager.isInventoryManager(subject)) {
            query = this.entityManager.createNamedQuery("ResourceType.findUtilizedChildrenByCategory_admin");
        } else {
            query = this.entityManager.createNamedQuery("ResourceType.findUtilizedChildrenByCategory");
            query.setParameter("subject", (Object)subject);
        }
        query.setParameter("parentResource", (Object)parentResource);
        query.setParameter("category", (Object)category);
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<ResourceType> getAllResourceTypesByCategory(Subject subject, ResourceCategory category) {
        Query query;
        if (category != null) {
            query = this.entityManager.createNamedQuery("ResourceType.findByCategory");
            query.setParameter("category", (Object)category);
        } else {
            query = this.entityManager.createNamedQuery("ResourceType.findAll");
        }
        List res = query.getResultList();
        return res;
    }

    @Override
    public List<String> getUtilizedResourceTypeNamesByCategory(Subject subject, ResourceCategory category, String nameFilter, String pluginName) {
        List<ResourceType> types = this.getUtilizeTypes_helper(subject, category, nameFilter, pluginName);
        ArrayList<String> typeNames = new ArrayList<String>();
        for (ResourceType type : types) {
            if (typeNames.contains(type.getName())) continue;
            typeNames.add(type.getName());
        }
        return typeNames;
    }

    @Override
    public List<ResourceType> getUtilizedResourceTypesByCategory(Subject subject, ResourceCategory category, String nameFilter) {
        List<ResourceType> types = this.getUtilizeTypes_helper(subject, category, nameFilter, null);
        return types;
    }

    private List<ResourceType> getUtilizeTypes_helper(Subject subject, ResourceCategory category, String nameFilter, String pluginName) {
        Query query = null;
        if (this.authorizationManager.isInventoryManager(subject)) {
            query = this.entityManager.createNamedQuery("ResourceType.findUtilizedByCategory_admin");
        } else {
            query = this.entityManager.createNamedQuery("ResourceType.findUtilizedByCategory");
            query.setParameter("subject", (Object)subject);
        }
        query.setParameter("category", (Object)category);
        query.setParameter("nameFilter", (Object)QueryUtility.formatSearchParameter(nameFilter));
        query.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        query.setParameter("pluginName", (Object)pluginName);
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        List results = query.getResultList();
        return results;
    }

    @Override
    public Map<Integer, SortedSet<ResourceType>> getChildResourceTypesForResourceTypes(List<ResourceType> types) {
        if (types == null || types.size() == 0) {
            return new HashMap<Integer, SortedSet<ResourceType>>();
        }
        ArrayList<Integer> ids = new ArrayList<Integer>(types.size());
        for (ResourceType type : types) {
            ids.add(type.getId());
        }
        Query q = this.entityManager.createNamedQuery("ResourceType.findChildrenByParent");
        q.setParameter("resourceType", types);
        List childResourceTypes = q.getResultList();
        ArrayList<ResourceType> newChildResourceTypes = new ArrayList<ResourceType>();
        newChildResourceTypes.addAll(childResourceTypes);
        int numberOfChildrenToFetch = childResourceTypes.size();
        while (numberOfChildrenToFetch > 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("*** getting children for " + newChildResourceTypes));
            }
            q.setParameter("resourceType", newChildResourceTypes);
            List newChildren = q.getResultList();
            newChildResourceTypes = new ArrayList();
            for (ResourceType rt : newChildren) {
                if (childResourceTypes.contains(rt)) continue;
                childResourceTypes.add(rt);
                newChildResourceTypes.add(rt);
            }
            numberOfChildrenToFetch = newChildResourceTypes.size();
        }
        HashMap<Integer, SortedSet<ResourceType>> result = new HashMap<Integer, SortedSet<ResourceType>>();
        for (ResourceType childType : childResourceTypes) {
            for (ResourceType parent : childType.getParentResourceTypes()) {
                Integer id = parent.getId();
                if (!result.containsKey(id)) {
                    result.put(id, new TreeSet());
                }
                SortedSet rtl = (SortedSet)result.get(id);
                rtl.add(childType);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"============ input: ");
            this.log.trace(ids);
            Set keys = result.keySet();
            for (Integer key : keys) {
                this.log.trace((Object)("Key: " + key));
                SortedSet rts = (SortedSet)result.get(key);
                for (ResourceType rt : rts) {
                    this.log.trace((Object)("  \\-> " + rt));
                }
            }
        }
        return result;
    }

    @Override
    public List<ResourceType> getResourceTypesForCompatibleGroups(Subject subject, String pluginName) {
        Query query = null;
        if (this.authorizationManager.isInventoryManager(subject)) {
            query = this.entityManager.createNamedQuery("ResourceType.findByResourceGroup_admin");
        } else {
            query = this.entityManager.createNamedQuery("ResourceType.findByResourceGroup");
            query.setParameter("subject", (Object)subject);
        }
        query.setParameter("pluginName", (Object)pluginName);
        List results = query.getResultList();
        return results;
    }

    @Override
    public Map<String, Integer> getResourceTypeCountsByGroup(Subject subject, ResourceGroup group, boolean recursive) {
        String queryName = recursive ? "ResourceType.getImplicitResourceTypeCountsByGroup" : "ResourceType.getExplicitResourceTypeCountsByGroup";
        Query query = this.entityManager.createNamedQuery(queryName);
        query.setParameter("groupId", (Object)group.getId());
        List results = query.getResultList();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int sz = results.size();
        for (int i = 0; i < sz; ++i) {
            Object[] elements = (Object[])results.get(i);
            long count = (Long)elements[2];
            map.put((String)elements[1], (int)count);
        }
        return map;
    }

    @Override
    public boolean ensureResourceType(Subject subject, Integer resourceTypeId, Integer[] resourceIds) throws ResourceTypeNotFoundException {
        HashSet<Integer> uniqueIds = new HashSet<Integer>();
        uniqueIds.addAll(Arrays.asList(resourceIds));
        int[] ids = ArrayUtils.unwrapCollection(uniqueIds);
        ResourceType type = this.getResourceTypeById(subject, resourceTypeId);
        int count = this.resourceManager.getResourceCountByTypeAndIds(subject, type, ids);
        return count == ids.length;
    }

    @Override
    public ResourceFacets getResourceFacets(int resourceTypeId) {
        ResourceFacets cachedFacet = ResourceFacetsCache.getSingleton().getResourceFacets(resourceTypeId);
        if (cachedFacet != null) {
            return cachedFacet;
        }
        Query query = this.entityManager.createNamedQuery("ResourceType.findResourceFacets");
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        List facets = query.getResultList();
        if (facets.size() != 1) {
            return new ResourceFacets(resourceTypeId, false, false, false, false, false, false, false, false);
        }
        return (ResourceFacets)facets.get(0);
    }

    @Override
    public void reloadResourceFacetsCache() {
        Query query = this.entityManager.createNamedQuery("ResourceType.findResourceFacets");
        query.setParameter("resourceTypeId", null);
        List facets = query.getResultList();
        ResourceFacetsCache.getSingleton().reload(facets);
    }

    @Override
    public Map<Integer, ResourceTypeTemplateCountComposite> getTemplateCountCompositeMap() {
        Query templateCountQuery = this.entityManager.createNamedQuery("ResourceType.findAllTemplateCountComposites");
        List composites = templateCountQuery.getResultList();
        HashMap<Integer, ResourceTypeTemplateCountComposite> compositeMap = new HashMap<Integer, ResourceTypeTemplateCountComposite>();
        for (ResourceTypeTemplateCountComposite next : composites) {
            compositeMap.put(next.getType().getId(), next);
        }
        return compositeMap;
    }

    @Override
    public List<ResourceType> getResourceTypesByPlugin(String pluginName) {
        String queryName = "ResourceType.findByPlugin";
        Query query = this.entityManager.createNamedQuery("ResourceType.findByPlugin");
        query.setParameter("plugin", (Object)pluginName);
        List results = query.getResultList();
        return results;
    }

    @Override
    public PageList<ResourceType> findResourceTypesByCriteria(Subject subject, ResourceTypeCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public List<String> getDuplicateTypeNames() {
        Query query = this.entityManager.createNamedQuery("ResourceType.findDuplicateTypeNames");
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<ResourceType> getResourceTypeAncestorsWithOperations(Subject subject, int resourceTypeId) {
        List<ResourceType> types = this.getAllResourceTypeAncestors(subject, resourceTypeId);
        List<ResourceType> results = this.excludeThoseWithoutOperations(types);
        return results;
    }

    @Override
    public List<ResourceType> getResourceTypeDescendantsWithOperations(Subject subject, int resourceTypeId) {
        List<ResourceType> types = this.getAllResourceTypeDescendants(subject, resourceTypeId);
        List<ResourceType> results = this.excludeThoseWithoutOperations(types);
        return results;
    }

    private List<ResourceType> excludeThoseWithoutOperations(List<ResourceType> types) {
        ArrayList<ResourceType> results = new ArrayList<ResourceType>();
        for (ResourceType next : types) {
            if (next.getOperationDefinitions() == null || next.getOperationDefinitions().size() == 0) continue;
            results.add(next);
        }
        return results;
    }

    @Override
    public List<ResourceType> getAllResourceTypeAncestors(Subject subject, int resourceTypeId) {
        HashSet<ResourceType> uniqueTypes = new HashSet<ResourceType>();
        Stack<Object> toProcess = new Stack<Object>();
        toProcess.add(this.entityManager.find(ResourceType.class, (Object)resourceTypeId));
        boolean sawTopLevelServer = false;
        while (toProcess.size() > 0) {
            ResourceType next = (ResourceType)toProcess.pop();
            Set parentTypes = next.getParentResourceTypes();
            if (parentTypes != null && parentTypes.size() != 0) {
                toProcess.addAll(parentTypes);
            } else if (next.getCategory() == ResourceCategory.SERVER) {
                sawTopLevelServer = true;
            }
            uniqueTypes.add(next);
        }
        ArrayList<ResourceType> results = new ArrayList<ResourceType>(uniqueTypes);
        if (sawTopLevelServer) {
            ResourceTypeCriteria criteria = new ResourceTypeCriteria();
            criteria.addFilterCategory(ResourceCategory.PLATFORM);
            PageList<ResourceType> platforms = this.findResourceTypesByCriteria(subject, criteria);
            results.addAll((Collection<ResourceType>)platforms);
        }
        Collections.sort(results);
        return results;
    }

    @Override
    public List<ResourceType> getAllResourceTypeDescendants(Subject subject, int resourceTypeId) {
        ResourceType first = (ResourceType)this.entityManager.find(ResourceType.class, (Object)resourceTypeId);
        if (first.getCategory() == ResourceCategory.PLATFORM) {
            ResourceTypeCriteria criteria = new ResourceTypeCriteria();
            PageList<ResourceType> allResourceTypes = this.findResourceTypesByCriteria(subject, criteria);
            ArrayList<ResourceType> results = new ArrayList<ResourceType>();
            for (ResourceType nextType : allResourceTypes) {
                if (nextType.getCategory() == ResourceCategory.PLATFORM) continue;
                results.add(nextType);
            }
            Collections.sort(results);
            return results;
        }
        HashSet<ResourceType> uniqueTypes = new HashSet<ResourceType>();
        Stack<ResourceType> toProcess = new Stack<ResourceType>();
        toProcess.add(first);
        Query findChildrenQuery = this.entityManager.createNamedQuery("ResourceType.findChildrenByParent");
        while (toProcess.size() > 0) {
            ResourceType next = (ResourceType)toProcess.pop();
            findChildrenQuery.setParameter("resourceType", Arrays.asList(next));
            List childTypes = findChildrenQuery.getResultList();
            if (childTypes != null) {
                toProcess.addAll(childTypes);
            }
            uniqueTypes.add(next);
        }
        ArrayList<ResourceType> results = new ArrayList<ResourceType>(uniqueTypes);
        Collections.sort(results);
        return results;
    }
}

