/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperPrintStream;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;

public class WrapperStartStopApp
implements WrapperListener,
Runnable {
    private static WrapperPrintStream m_outInfo;
    private static WrapperPrintStream m_outError;
    private static WrapperPrintStream m_outDebug;
    private Method m_startMainMethod;
    private String[] m_startMainArgs;
    private Method m_stopMainMethod;
    private boolean m_stopWait;
    private String[] m_stopMainArgs;
    private boolean m_mainStarted;
    private boolean m_mainComplete;
    private Integer m_mainExitCode;
    private boolean m_startComplete;

    protected WrapperStartStopApp(String[] args) {
        Class<WrapperManager> wmClass = WrapperManager.class;
        m_outInfo = new WrapperPrintStream(System.out, "WrapperStartStopApp: ");
        m_outError = new WrapperPrintStream(System.out, "WrapperStartStopApp: ");
        m_outDebug = new WrapperPrintStream(System.out, "WrapperStartStopApp Debug: ");
        if (args.length < 5) {
            m_outError.println("Not enough argments.  Minimum 5 required.");
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        this.m_startMainMethod = this.getMainMethod(args[0]);
        String[] startArgs = this.getArgs(args, 1);
        int stopArgBase = 2 + startArgs.length;
        if (args.length < stopArgBase + 3) {
            m_outError.println("Not enough argments. Minimum 3 after start arguments.");
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        this.m_stopMainMethod = this.getMainMethod(args[stopArgBase]);
        if (args[stopArgBase + 1].equalsIgnoreCase("true")) {
            this.m_stopWait = true;
        } else if (args[stopArgBase + 1].equalsIgnoreCase("false")) {
            this.m_stopWait = false;
        } else {
            m_outError.println("The stop_wait argument must be either true or false.");
            this.showUsage();
            WrapperManager.stop(1);
            return;
        }
        this.m_stopMainArgs = this.getArgs(args, stopArgBase + 2);
        WrapperManager.start(this, startArgs);
    }

    protected WrapperStartStopApp(Method startMainMethod, Method stopMainMethod, boolean stopWait, String[] stopMainArgs) {
        this.m_startMainMethod = startMainMethod;
        this.m_stopMainMethod = stopMainMethod;
        this.m_stopWait = stopWait;
        this.m_stopMainArgs = stopMainArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Throwable t;
        block16: {
            WrapperStartStopApp wrapperStartStopApp = this;
            synchronized (wrapperStartStopApp) {
                this.m_mainStarted = true;
                this.notifyAll();
            }
            t = null;
            try {
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println("invoking start main method");
                }
                this.m_startMainMethod.invoke(null, new Object[]{this.m_startMainArgs});
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println("start main method completed");
                }
                WrapperStartStopApp wrapperStartStopApp2 = this;
                synchronized (wrapperStartStopApp2) {
                    this.m_mainComplete = true;
                    this.notifyAll();
                }
                return;
            }
            catch (IllegalAccessException e) {
                t = e;
            }
            catch (IllegalArgumentException e) {
                t = e;
            }
            catch (InvocationTargetException e) {
                t = e.getTargetException();
                if (t != null) break block16;
                t = e;
            }
        }
        m_outInfo.println();
        m_outError.println("Encountered an error running start main: " + t);
        t.printStackTrace(m_outError);
        WrapperStartStopApp wrapperStartStopApp = this;
        synchronized (wrapperStartStopApp) {
            if (this.m_startComplete) {
                WrapperManager.stop(1);
                return;
            }
            this.m_mainComplete = true;
            this.m_mainExitCode = new Integer(1);
            this.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer start(String[] args) {
        int maxLoops;
        boolean waitForStartMain = WrapperSystemPropertyUtil.getBooleanProperty(WrapperStartStopApp.class.getName() + ".waitForStartMain", false);
        int maxStartMainWait = WrapperSystemPropertyUtil.getIntProperty(WrapperStartStopApp.class.getName() + ".maxStartMainWait", 2);
        maxStartMainWait = Math.max(1, maxStartMainWait);
        if (waitForStartMain) {
            maxLoops = Integer.MAX_VALUE;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("start(args) Will wait indefinitely for the main method to complete.");
            }
        } else {
            maxLoops = maxStartMainWait;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("start(args) Will wait up to " + maxLoops + " seconds for the main method to complete.");
            }
        }
        Thread mainThread = new Thread((Runnable)this, "WrapperStartStopAppMain");
        WrapperStartStopApp wrapperStartStopApp = this;
        synchronized (wrapperStartStopApp) {
            this.m_startMainArgs = args;
            mainThread.start();
            while (!this.m_mainStarted) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {}
            }
            for (int loops = 0; loops < maxLoops && !this.m_mainComplete; ++loops) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.m_mainComplete) continue;
                WrapperManager.signalStarting(5000);
            }
            this.m_startComplete = true;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("start(args) end.  Main Completed=" + this.m_mainComplete + ", exitCode=" + this.m_mainExitCode);
            }
            return this.m_mainExitCode;
        }
    }

    public int stop(int exitCode) {
        if (WrapperManager.isDebugEnabled()) {
            m_outDebug.println("stop(" + exitCode + ")");
        }
        Exception t = null;
        try {
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("invoking stop main method");
            }
            this.m_stopMainMethod.invoke(null, new Object[]{this.m_stopMainArgs});
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("stop main method completed");
            }
            if (this.m_stopWait) {
                int threadCnt;
                int systemThreadCount = WrapperSystemPropertyUtil.getIntProperty(WrapperStartStopApp.class.getName() + ".systemThreadCount", 1);
                systemThreadCount = Math.max(0, systemThreadCount);
                while ((threadCnt = this.getNonDaemonThreadCount()) > systemThreadCount) {
                    if (WrapperManager.isDebugEnabled()) {
                        m_outDebug.println("stopping.  Waiting for " + (threadCnt - systemThreadCount) + " threads to complete.");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            return exitCode;
        }
        catch (IllegalAccessException e) {
            t = e;
        }
        catch (IllegalArgumentException e) {
            t = e;
        }
        catch (InvocationTargetException e) {
            t = e;
        }
        m_outError.println("Encountered an error running stop main: " + t);
        t.printStackTrace(m_outError);
        return 1;
    }

    public void controlEvent(int event) {
        if (event == 202 && (WrapperManager.isLaunchedAsService() || WrapperManager.isIgnoreUserLogoffs())) {
            m_outInfo.println("User logged out.  Ignored.");
        } else {
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println("controlEvent(" + event + ") Stopping");
            }
            WrapperManager.stop(0);
        }
    }

    private int getNonDaemonThreadCount() {
        ThreadGroup topGroup = Thread.currentThread().getThreadGroup();
        while (topGroup.getParent() != null) {
            topGroup = topGroup.getParent();
        }
        Thread[] threads = new Thread[topGroup.activeCount() * 2];
        topGroup.enumerate(threads, true);
        int liveCount = 0;
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null || !threads[i].isAlive() || Thread.currentThread() == threads[i] || threads[i].isDaemon()) continue;
            ++liveCount;
        }
        return liveCount;
    }

    private Method getMainMethod(String className) {
        Method mainMethod;
        Class<?> mainClass;
        try {
            mainClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            m_outError.println("Unable to locate the class " + className + ": " + e);
            this.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        catch (ExceptionInInitializerError e) {
            m_outError.println("Class " + className + " found but could not be initialized due to:");
            e.printStackTrace(m_outError);
            WrapperManager.stop(1);
            return null;
        }
        catch (LinkageError e) {
            m_outError.println("Class " + className + " found but could not be initialized: " + e);
            WrapperManager.stop(1);
            return null;
        }
        try {
            mainMethod = mainClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            m_outError.println("Unable to locate a public static main method in class " + className + ": " + e);
            this.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        catch (SecurityException e) {
            m_outError.println("Unable to locate a public static main method in class " + className + ": " + e);
            this.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        int modifiers = mainMethod.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
            m_outError.println("The main method in class " + className + " must be declared public and static.");
            this.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        return mainMethod;
    }

    private String[] getArgs(String[] args, int argBase) {
        int argCount;
        try {
            argCount = Integer.parseInt(args[argBase]);
        }
        catch (NumberFormatException e) {
            m_outError.println("Illegal argument count: " + args[argBase]);
            this.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        if (argCount < 0) {
            m_outError.println("Illegal argument count: " + args[argBase]);
            this.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        if (args.length < argBase + 1 + argCount) {
            m_outError.println("Not enough argments.  Argument count of " + argCount + " was specified.");
            this.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        String[] mainArgs = new String[argCount];
        System.arraycopy(args, argBase + 1, mainArgs, 0, argCount);
        return mainArgs;
    }

    protected void showUsage() {
        System.out.println();
        System.out.println("WrapperStartStopApp Usage:");
        System.out.println("  java org.tanukisoftware.wrapper.WrapperStartStopApp {start_class} {start_arg_count} [start_arguments] {stop_class} {stop_wait} {stop_arg_count} [stop_arguments]");
        System.out.println();
        System.out.println("Where:");
        System.out.println("  start_class:     The fully qualified class name to run to start the ");
        System.out.println("                   application.");
        System.out.println("  start_arg_count: The number of arguments to be passed to the start class's ");
        System.out.println("                   main method.");
        System.out.println("  start_arguments: The arguments that would normally be passed to the start ");
        System.out.println("                   class application.");
        System.out.println("  stop_class:      The fully qualified class name to run to stop the ");
        System.out.println("                   application.");
        System.out.println("  stop_wait:       When stopping, should the Wrapper wait for all threads to ");
        System.out.println("                   complete before exiting (true/false).");
        System.out.println("  stop_arg_count:  The number of arguments to be passed to the stop class's ");
        System.out.println("                   main method.");
        System.out.println("  stop_arguments:  The arguments that would normally be passed to the stop ");
        System.out.println("                   class application.");
    }

    public static void main(String[] args) {
        new WrapperStartStopApp(args);
    }
}

