/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.bundle;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.core.clientapi.agent.bundle.BundleAgentService;
import org.rhq.core.clientapi.agent.bundle.BundleScheduleRequest;
import org.rhq.core.clientapi.agent.bundle.BundleScheduleResponse;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleDeploymentStatus;
import org.rhq.core.domain.bundle.BundleDestination;
import org.rhq.core.domain.bundle.BundleFile;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.bundle.composite.BundleWithLatestVersionComposite;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageCategory;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.criteria.BundleCriteria;
import org.rhq.core.domain.criteria.BundleDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleDestinationCriteria;
import org.rhq.core.domain.criteria.BundleFileCriteria;
import org.rhq.core.domain.criteria.BundleResourceDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleVersionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceGroupCriteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.StringUtils;
import org.rhq.core.util.NumberUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.bundle.BundleDistributionInfo;
import org.rhq.enterprise.server.bundle.BundleManagerHelper;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.bundle.BundleManagerRemote;
import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginManager;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.HibernateDetachUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class BundleManagerBean
implements BundleManagerLocal,
BundleManagerRemote {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String AUDIT_ACTION_DEPLOYMENT = "Deployment";
    private final String AUDIT_ACTION_DEPLOYMENT_REQUESTED = "Deployment Requested";
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private BundleManagerLocal bundleManager;
    @EJB
    private ContentManagerLocal contentManager;
    @EJB
    private RepoManagerLocal repoManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleResourceDeploymentHistory addBundleResourceDeploymentHistory(Subject subject, int bundleDeploymentId, BundleResourceDeploymentHistory history) throws Exception {
        BundleResourceDeployment resourceDeployment = (BundleResourceDeployment)this.entityManager.find(BundleResourceDeployment.class, (Object)bundleDeploymentId);
        if (null == resourceDeployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + bundleDeploymentId);
        }
        resourceDeployment.addBundleResourceDeploymentHistory(history);
        this.entityManager.persist((Object)resourceDeployment);
        return history;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public Bundle createBundle(Subject subject, String name, String description, int bundleTypeId) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleName: " + name);
        }
        BundleType bundleType = (BundleType)this.entityManager.find(BundleType.class, (Object)bundleTypeId);
        if (null == bundleType) {
            throw new IllegalArgumentException("Invalid bundleTypeId: " + bundleTypeId);
        }
        Repo repo = new Repo(name);
        repo.setCandidate(false);
        repo.setSyncSchedule(null);
        repo = this.repoManager.createRepo(subject, repo);
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)bundleType.getResourceType().getId());
        PackageType packageType = new PackageType(name, resourceType);
        packageType.setDescription("Package type for content of bundle " + name);
        packageType.setCategory(PackageCategory.BUNDLE);
        packageType.setSupportsArchitecture(false);
        packageType.setDisplayName(StringUtils.deCamelCase((String)name));
        packageType.setDiscoveryInterval(-1L);
        packageType.setCreationData(false);
        packageType.setDeploymentConfigurationDefinition(null);
        Bundle bundle = new Bundle(name, bundleType, repo, packageType);
        bundle.setDescription(description);
        bundle.setPackageType(packageType);
        this.log.info((Object)("Creating bundle: " + bundle));
        this.entityManager.persist((Object)bundle);
        return bundle;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleDeployment createBundleDeploymentInNewTrans(Subject subject, int bundleVersionId, int bundleDestinationId, String name, String description, Configuration configuration) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        BundleDestination bundleDestination = (BundleDestination)this.entityManager.find(BundleDestination.class, (Object)bundleDestinationId);
        if (null == bundleDestination) {
            throw new IllegalArgumentException("Invalid bundleDestinationId: " + bundleVersionId);
        }
        return this.createBundleDeploymentImpl(subject, bundleVersion, bundleDestination, name, description, configuration);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleDeployment createBundleDeployment(Subject subject, int bundleVersionId, int bundleDestinationId, String description, Configuration configuration) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        BundleDestination bundleDestination = (BundleDestination)this.entityManager.find(BundleDestination.class, (Object)bundleDestinationId);
        if (null == bundleDestination) {
            throw new IllegalArgumentException("Invalid bundleDestinationId: " + bundleVersionId);
        }
        String name = this.getBundleDeploymentNameImpl(subject, bundleDestination, bundleVersion, null);
        return this.createBundleDeploymentImpl(subject, bundleVersion, bundleDestination, name, description, configuration);
    }

    private BundleDeployment createBundleDeploymentImpl(Subject subject, BundleVersion bundleVersion, BundleDestination bundleDestination, String name, String description, Configuration configuration) throws Exception {
        ConfigurationDefinition configDef = bundleVersion.getConfigurationDefinition();
        if (null != configDef) {
            if (null == configuration) {
                throw new IllegalArgumentException("Missing Configuration. Configuration is required when the specified BundleVersion defines Configuration Properties.");
            }
            List errors = ConfigurationUtility.validateConfiguration((Configuration)configuration, (ConfigurationDefinition)configDef);
            if (null != errors && !errors.isEmpty()) {
                throw new IllegalArgumentException("Invalid Configuration: " + errors.toString());
            }
        }
        BundleDeployment deployment = new BundleDeployment(bundleVersion, bundleDestination, name);
        deployment.setDescription(description);
        deployment.setConfiguration(configuration);
        this.entityManager.persist((Object)deployment);
        return deployment;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleDestination createBundleDestination(Subject subject, int bundleId, String name, String description, String deployDir, Integer groupId) throws Exception {
        Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
        if (null == bundle) {
            throw new IllegalArgumentException("Invalid bundleId [" + bundleId + "]");
        }
        ResourceGroupCriteria c = new ResourceGroupCriteria();
        c.addFilterId(groupId);
        c.addFilterExplicitResourceCategory(ResourceCategory.PLATFORM);
        PageList<ResourceGroup> groups = this.resourceGroupManager.findResourceGroupsByCriteria(subject, c);
        if (null == groups || groups.isEmpty()) {
            throw new IllegalArgumentException("Invalid groupId [" + groupId + "]. Must exist and contain only platform members.");
        }
        ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)((ResourceGroup)groups.get(0)).getId());
        BundleDestination dest = new BundleDestination(bundle, name, group, deployDir);
        dest.setDescription(description);
        this.entityManager.persist((Object)dest);
        return dest;
    }

    @Override
    public String getBundleDeploymentName(Subject subject, int bundleDestinationId, int bundleVersionId, int prevDeploymentId) {
        BundleDestination bundleDestination = (BundleDestination)this.entityManager.find(BundleDestination.class, (Object)bundleDestinationId);
        if (null == bundleDestination) {
            throw new IllegalArgumentException("Invalid bundleDestinationId: " + bundleVersionId);
        }
        BundleVersion bundleVersion = null;
        BundleDeployment prevDeployment = null;
        if (bundleVersionId > 0) {
            bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
            if (null == bundleVersion) {
                throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
            }
        } else if (prevDeploymentId > 0) {
            prevDeployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)prevDeploymentId);
            if (null == prevDeployment) {
                throw new IllegalArgumentException("Invalid prevDeploymentId: " + prevDeploymentId);
            }
        } else {
            throw new IllegalArgumentException("Must specify either a valid bundleVersionId [" + bundleVersionId + "] or prevDeploymentId [" + prevDeploymentId + "]");
        }
        return this.getBundleDeploymentNameImpl(subject, bundleDestination, bundleVersion, prevDeployment);
    }

    private String getBundleDeploymentNameImpl(Subject subject, BundleDestination bundleDestination, BundleVersion bundleVersion, BundleDeployment prevDeployment) {
        BundleDeploymentCriteria criteria = new BundleDeploymentCriteria();
        criteria.addFilterDestinationId(Integer.valueOf(bundleDestination.getId()));
        criteria.addFilterIsLive(Boolean.valueOf(true));
        criteria.fetchBundleVersion(true);
        PageList<BundleDeployment> liveDeployments = this.bundleManager.findBundleDeploymentsByCriteria(subject, criteria);
        BundleDeployment liveDeployment = liveDeployments.isEmpty() ? null : (BundleDeployment)liveDeployments.get(0);
        String deploymentName = null;
        if (null != bundleVersion) {
            boolean isInitialDeployment = null == liveDeployment;
            int deploy = 1;
            String version = bundleVersion.getVersion();
            String dest = bundleDestination.getName();
            if (isInitialDeployment) {
                deploymentName = "Deployment [" + deploy + "] of Version [" + version + "] to [" + dest + "]";
            } else {
                String liveName = liveDeployment.getName();
                String liveVersion = liveDeployment.getBundleVersion().getVersion();
                if (liveVersion.equals(version)) {
                    int iStart = liveName.indexOf("[") + 1;
                    int iEnd = liveName.indexOf("]");
                    deploy = Integer.valueOf(liveName.substring(iStart, iEnd)) + 1;
                    deploymentName = "Deployment [" + deploy + "] of Version [" + version + "] to [" + dest + "]";
                } else {
                    deploymentName = "Deployment [" + deploy + "] of Version [" + version + "] to [" + dest + "]. Upgrade from Version [" + liveVersion + "]";
                }
            }
        } else {
            if (null == liveDeployment) {
                throw new IllegalArgumentException("Invalid Revert, no live deployment for destination" + bundleDestination);
            }
            String liveName = liveDeployment.getName();
            int iStart = liveName.indexOf("[") + 1;
            int iEnd = liveName.indexOf("]");
            int deploy = Integer.valueOf(liveName.substring(iStart, iEnd)) + 1;
            deploymentName = "Deployment [" + deploy + "] Revert To: " + prevDeployment.getName();
        }
        return deploymentName;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleType createBundleType(Subject subject, String name, int resourceTypeId) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleTypeName: " + name);
        }
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)resourceTypeId);
        if (null == resourceType) {
            throw new IllegalArgumentException("Invalid resourceeTypeId: " + resourceTypeId);
        }
        BundleType bundleType = new BundleType(name, resourceType);
        this.entityManager.persist((Object)bundleType);
        return bundleType;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleVersion createBundleAndBundleVersion(Subject subject, String bundleName, String bundleDescription, int bundleTypeId, String bundleVersionName, String bundleVersionDescription, String version, String recipe) throws Exception {
        BundleCriteria criteria = new BundleCriteria();
        criteria.addFilterBundleTypeId(Integer.valueOf(bundleTypeId));
        criteria.addFilterName(bundleName);
        PageList<Bundle> bundles = this.findBundlesByCriteria(subject, criteria);
        Bundle bundle = bundles.getTotalSize() == 0 ? this.createBundle(subject, bundleName, bundleDescription, bundleTypeId) : (Bundle)bundles.get(0);
        BundleVersion bv = this.createBundleVersion(subject, bundle.getId(), bundleVersionName, bundleVersionDescription, version, recipe);
        return bv;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleVersion createBundleVersion(Subject subject, int bundleId, String name, String description, String version, String recipe) throws Exception {
        RecipeParseResults results;
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleVersionName: " + name);
        }
        Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
        if (null == bundle) {
            throw new IllegalArgumentException("Invalid bundleId: " + bundleId);
        }
        BundleType bundleType = bundle.getBundleType();
        try {
            results = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager().parseRecipe(bundleType.getName(), recipe);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse recipe", e);
        }
        version = this.getVersion(version, bundle);
        ComparableVersion comparableVersion = new ComparableVersion(version);
        Query q = this.entityManager.createNamedQuery("BundleVersion.findVersionsByBundleId");
        q.setParameter("bundleId", (Object)bundle.getId());
        List list = q.getResultList();
        int versionOrder = list.size();
        boolean needToUpdateOrder = false;
        for (Object[] bv : list) {
            ComparableVersion bvv = new ComparableVersion(bv[0].toString());
            int comparision = comparableVersion.compareTo((Object)bvv);
            if (comparision == 0) {
                throw new RuntimeException("Cannot create bundle with version [" + version + "], it already exists");
            }
            if (comparision >= 0) break;
            versionOrder = ((Number)bv[1]).intValue();
            needToUpdateOrder = true;
        }
        if (needToUpdateOrder) {
            this.entityManager.flush();
            q = this.entityManager.createNamedQuery("BundleVersion.updateVersionOrderByBundleId");
            q.setParameter("bundleId", (Object)bundle.getId());
            q.setParameter("versionOrder", (Object)versionOrder);
            q.executeUpdate();
            this.entityManager.flush();
            this.entityManager.clear();
        }
        BundleVersion bundleVersion = new BundleVersion(name, version, bundle, recipe);
        bundleVersion.setVersionOrder(versionOrder);
        bundleVersion.setDescription(description);
        bundleVersion.setConfigurationDefinition(results.getConfigurationDefinition());
        this.entityManager.persist((Object)bundleVersion);
        return bundleVersion;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleVersion createBundleVersionViaRecipe(Subject subject, String recipe) throws Exception {
        BundleServerPluginManager manager = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager();
        BundleDistributionInfo info = manager.parseRecipe(recipe);
        BundleVersion bundleVersion = this.createBundleVersionViaDistributionInfo(subject, info);
        return bundleVersion;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createBundleVersionViaFile(Subject subject, File distributionFile) throws Exception {
        BundleServerPluginManager manager = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager();
        BundleDistributionInfo info = manager.processBundleDistributionFile(distributionFile);
        BundleVersion bundleVersion = this.createBundleVersionViaDistributionInfo(subject, info);
        return bundleVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public BundleVersion createBundleVersionViaURL(Subject subject, String distributionFileUrl) throws Exception {
        BundleVersion bundleVersion;
        FileOutputStream os;
        InputStream is;
        block3: {
            URL url = new URL(distributionFileUrl);
            File tempDistributionFile = null;
            is = null;
            os = null;
            bundleVersion = null;
            try {
                tempDistributionFile = File.createTempFile("bundle-distribution", ".zip");
                is = url.openStream();
                os = new FileOutputStream(tempDistributionFile);
                long len = StreamUtil.copy((InputStream)is, (OutputStream)os);
                is = null;
                os = null;
                this.log.debug((Object)("Copied [" + len + "] bytes from [" + distributionFileUrl + "] into [" + tempDistributionFile.getPath() + "]"));
                bundleVersion = this.createBundleVersionViaFile(subject, tempDistributionFile);
                Object var11_9 = null;
                if (null == tempDistributionFile) break block3;
                tempDistributionFile.delete();
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (null != tempDistributionFile) {
                    tempDistributionFile.delete();
                }
                this.safeClose(is);
                this.safeClose(os);
                throw throwable;
            }
            {
            }
        }
        this.safeClose(is);
        this.safeClose(os);
        return bundleVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BundleVersion createBundleVersionViaDistributionInfo(Subject subject, BundleDistributionInfo info) throws Exception {
        boolean createdBundle;
        Bundle bundle;
        BundleType bundleType = this.bundleManager.getBundleType(subject, info.getBundleTypeName());
        String bundleName = info.getRecipeParseResults().getBundleMetadata().getBundleName();
        String bundleDescription = info.getRecipeParseResults().getBundleMetadata().getDescription();
        String name = bundleName;
        String description = bundleDescription;
        String version = info.getRecipeParseResults().getBundleMetadata().getBundleVersion();
        String recipe = info.getRecipe();
        BundleCriteria criteria = new BundleCriteria();
        criteria.setStrict(true);
        criteria.addFilterBundleTypeId(Integer.valueOf(bundleType.getId()));
        criteria.addFilterName(bundleName);
        PageList<Bundle> bundles = this.bundleManager.findBundlesByCriteria(subject, criteria);
        if (bundles.getTotalSize() == 0) {
            bundle = this.bundleManager.createBundle(subject, bundleName, bundleDescription, bundleType.getId());
            createdBundle = true;
        } else {
            bundle = (Bundle)bundles.get(0);
            createdBundle = false;
        }
        BundleVersion bundleVersion = this.bundleManager.createBundleVersion(subject, bundle.getId(), name, description, version, recipe);
        try {
            Map<String, File> bundleFiles = info.getBundleFiles();
            if (bundleFiles != null) {
                for (String fileName : bundleFiles.keySet()) {
                    Object var22_23;
                    File file = bundleFiles.get(fileName);
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(file);
                        BundleFile bundleFile = this.bundleManager.addBundleFile(subject, bundleVersion.getId(), fileName, bundleVersion.getVersion(), null, is);
                        this.log.debug((Object)("Added bundle file [" + bundleFile + "] to BundleVersion [" + bundleVersion + "]"));
                        var22_23 = null;
                        this.safeClose(is);
                        if (null == file) continue;
                        file.delete();
                    }
                    catch (Throwable throwable) {
                        var22_23 = null;
                        this.safeClose(is);
                        if (null == file) throw throwable;
                        file.delete();
                        throw throwable;
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to add bundle file to new bundle version [" + bundleVersion + "], will not create the new bundle"), (Throwable)e);
            try {
                this.bundleManager.deleteBundleVersion(this.subjectManager.getOverlord(), bundleVersion.getId(), createdBundle);
                throw e;
            }
            catch (Exception e1) {
                this.log.error((Object)("Failed to delete the partially created bundle version: " + bundleVersion), (Throwable)e1);
            }
            throw e;
        }
        BundleVersionCriteria bvCriteria = new BundleVersionCriteria();
        bvCriteria.addFilterId(Integer.valueOf(bundleVersion.getId()));
        bvCriteria.fetchBundle(true);
        bvCriteria.fetchBundleFiles(true);
        bvCriteria.fetchConfigurationDefinition(true);
        bvCriteria.fetchTags(true);
        PageList<BundleVersion> bundleVersions = this.bundleManager.findBundleVersionsByCriteria(subject, bvCriteria);
        if (bundleVersions != null && bundleVersions.size() == 1) {
            bundleVersion = (BundleVersion)bundleVersions.get(0);
            List bundleFiles = bundleVersion.getBundleFiles();
            if (bundleFiles != null && bundleFiles.size() > 0) {
                BundleFileCriteria bfCriteria = new BundleFileCriteria();
                bfCriteria.addFilterBundleVersionId(Integer.valueOf(bundleVersion.getId()));
                bfCriteria.fetchPackageVersion(true);
                PageList<BundleFile> bfs = this.bundleManager.findBundleFilesByCriteria(this.subjectManager.getOverlord(), bfCriteria);
                bundleFiles.clear();
                bundleFiles.addAll(bfs);
            }
            bundleVersion.setBundleDeployments(new ArrayList());
            return bundleVersion;
        }
        this.log.error((Object)("Failed to obtain the full bundle version, returning only what we currently know about it: " + bundleVersion));
        return bundleVersion;
    }

    private String getVersion(String version, Bundle bundle) {
        if (null != version && version.trim().length() > 0) {
            return version;
        }
        BundleVersion latestBundleVersion = null;
        Query q = this.entityManager.createNamedQuery("BundleVersion.findLatestByBundleId");
        q.setParameter("bundleId", (Object)bundle.getId());
        List list = q.getResultList();
        if (list.size() > 0) {
            if (list.size() == 1) {
                latestBundleVersion = (BundleVersion)list.get(0);
            } else {
                throw new RuntimeException("Bundle [" + bundle.getName() + "] (id=" + bundle.getId() + ") has more than 1 'latest' version. This should not happen - aborting");
            }
        }
        String latestVersion = latestBundleVersion != null ? latestBundleVersion.getVersion() : null;
        String newVersion = NumberUtil.autoIncrementVersion((String)latestVersion);
        return newVersion;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleFile addBundleFile(Subject subject, int bundleVersionId, String name, String version, Architecture architecture, InputStream fileStream) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleFileName: " + name);
        }
        if (null == version || "".equals(version.trim())) {
            throw new IllegalArgumentException("Invalid bundleFileVersion: " + version);
        }
        if (null == fileStream) {
            throw new IllegalArgumentException("Invalid fileStream: " + null);
        }
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        Bundle bundle = bundleVersion.getBundle();
        PackageType packageType = bundle.getPackageType();
        Architecture architecture2 = architecture = null == architecture ? this.contentManager.getNoArchitecture() : architecture;
        if (architecture.getId() == 0) {
            Query q = this.entityManager.createNamedQuery("Architecture.findByName");
            q.setParameter("name", (Object)architecture.getName());
            architecture = (Architecture)q.getSingleResult();
        }
        PackageVersion packageVersion = this.contentManager.createPackageVersion(name, packageType.getId(), version, architecture.getId(), fileStream);
        packageVersion.setFileName(name);
        packageVersion = (PackageVersion)this.entityManager.merge((Object)packageVersion);
        Repo repo = bundle.getRepo();
        this.repoManager.addPackageVersionsToRepo(subject, repo.getId(), new int[]{packageVersion.getId()});
        Package generalPackage = packageVersion.getGeneralPackage();
        generalPackage.setClassification(bundle.getName());
        BundleFile bundleFile = new BundleFile();
        bundleFile.setBundleVersion(bundleVersion);
        bundleFile.setPackageVersion(packageVersion);
        this.entityManager.persist((Object)bundleFile);
        return bundleFile;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleFile addBundleFileViaByteArray(Subject subject, int bundleVersionId, String name, String version, Architecture architecture, byte[] fileBytes) throws Exception {
        return this.addBundleFile(subject, bundleVersionId, name, version, architecture, new ByteArrayInputStream(fileBytes));
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleFile addBundleFileViaURL(Subject subject, int bundleVersionId, String name, String version, Architecture architecture, String bundleFileUrl) throws Exception {
        URL url = new URL(bundleFileUrl);
        return this.addBundleFile(subject, bundleVersionId, name, version, architecture, url.openStream());
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleFile addBundleFileViaPackageVersion(Subject subject, int bundleVersionId, String name, int packageVersionId) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleFileName: " + name);
        }
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        PackageVersion packageVersion = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
        if (null == packageVersion) {
            throw new IllegalArgumentException("Invalid packageVersionId: " + packageVersionId);
        }
        BundleFile bundleFile = new BundleFile();
        bundleFile.setBundleVersion(bundleVersion);
        bundleFile.setPackageVersion(packageVersion);
        this.entityManager.persist((Object)bundleFile);
        return bundleFile;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleDeployment scheduleBundleDeployment(Subject subject, int bundleDeploymentId, boolean isCleanDeployment) throws Exception {
        return this.scheduleBundleDeploymentImpl(subject, bundleDeploymentId, isCleanDeployment, false);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleDeployment scheduleRevertBundleDeployment(Subject subject, int bundleDestinationId, String deploymentDescription, boolean isCleanDeployment) throws Exception {
        BundleDeploymentCriteria c = new BundleDeploymentCriteria();
        c.addFilterDestinationId(Integer.valueOf(bundleDestinationId));
        c.addFilterIsLive(Boolean.valueOf(true));
        c.fetchReplacedBundleDeployment(true);
        c.fetchDestination(true);
        PageList<BundleDeployment> liveDeployments = this.bundleManager.findBundleDeploymentsByCriteria(subject, c);
        if (1 != liveDeployments.size()) {
            throw new IllegalArgumentException("No live deployment found for destinationId [" + bundleDestinationId + "]");
        }
        BundleDeployment liveDeployment = (BundleDeployment)liveDeployments.get(0);
        BundleDeployment prevDeployment = liveDeployment.getReplacedBundleDeployment();
        if (null == prevDeployment) {
            throw new IllegalArgumentException("Live deployment [" + liveDeployment + "] can not be reverted. The Live deployment is either an initial deployment or a reverted deployment for destinationId [" + bundleDestinationId + "]");
        }
        if (null == (prevDeployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)prevDeployment.getId()))) {
            throw new IllegalArgumentException("Live deployment [" + liveDeployment + "] can not be reverted. There is no prior deployment for destinationId [" + bundleDestinationId + "]");
        }
        String name = this.getBundleDeploymentNameImpl(subject, liveDeployment.getDestination(), null, prevDeployment);
        String desc = null != deploymentDescription ? deploymentDescription : prevDeployment.getDescription();
        Configuration config = null == prevDeployment.getConfiguration() ? null : prevDeployment.getConfiguration().deepCopy(false);
        BundleDeployment revertDeployment = this.bundleManager.createBundleDeploymentInNewTrans(subject, prevDeployment.getBundleVersion().getId(), bundleDestinationId, name, desc, config);
        return this.scheduleBundleDeploymentImpl(subject, revertDeployment.getId(), isCleanDeployment, true);
    }

    private BundleDeployment scheduleBundleDeploymentImpl(Subject subject, int bundleDeploymentId, boolean isCleanDeployment, boolean isRevert) throws Exception {
        BundleDeployment newDeployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)bundleDeploymentId);
        if (null == newDeployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + bundleDeploymentId);
        }
        BundleDestination destination = newDeployment.getDestination();
        ResourceGroup group = destination.getGroup();
        Set platforms = group.getExplicitResources();
        if (platforms.isEmpty()) {
            throw new IllegalArgumentException("Destination [" + destination + "] group has no platforms. Invalid deployment destination");
        }
        for (Resource platform : platforms) {
            try {
                this.scheduleBundleResourceDeployment(subject, newDeployment, platform, isCleanDeployment, isRevert);
            }
            catch (Throwable t) {
                this.log.error((Object)("Failed to complete scheduling of platform deployment to [" + platform + "]. Other platforms may have been scheduled. "), t);
            }
        }
        List currentDeployments = (destination = (BundleDestination)this.entityManager.find(BundleDestination.class, (Object)destination.getId())).getDeployments();
        if (null != currentDeployments) {
            for (BundleDeployment d : currentDeployments) {
                if (!d.isLive()) continue;
                d.setLive(false);
                if (isRevert) break;
                newDeployment.setReplacedBundleDeployment(d);
                break;
            }
        }
        newDeployment.setLive(true);
        return newDeployment;
    }

    private BundleResourceDeployment scheduleBundleResourceDeployment(Subject subject, BundleDeployment deployment, Resource platform, boolean isCleanDeployment, boolean isRevert) throws Exception {
        int platformId = platform.getId();
        AgentClient agentClient = this.agentManager.getAgentClient(platformId);
        BundleAgentService bundleAgentService = agentClient.getBundleAgentService();
        BundleResourceDeployment resourceDeployment = this.bundleManager.createBundleResourceDeployment(subject, deployment.getId(), platformId);
        if (ResourceCategory.PLATFORM.equals((Object)platform.getResourceType().getCategory())) {
            try {
                BundleScheduleRequest request = this.bundleManager.getScheduleRequest(subject, resourceDeployment.getId(), isCleanDeployment, isRevert);
                BundleResourceDeploymentHistory history = new BundleResourceDeploymentHistory(subject.getName(), "Deployment Requested", deployment.getName(), null, BundleResourceDeploymentHistory.Status.SUCCESS, "Requested deployment time: " + request.getRequestedDeployTimeAsString(), null);
                this.bundleManager.addBundleResourceDeploymentHistory(subject, resourceDeployment.getId(), history);
                BundleScheduleResponse response = bundleAgentService.schedule(request);
                if (!response.isSuccess()) {
                    this.bundleManager.setBundleResourceDeploymentStatus(subject, resourceDeployment.getId(), BundleDeploymentStatus.FAILURE);
                    history = new BundleResourceDeploymentHistory(subject.getName(), "Deployment", deployment.getName(), null, BundleResourceDeploymentHistory.Status.FAILURE, response.getErrorMessage(), null);
                    this.bundleManager.addBundleResourceDeploymentHistory(subject, resourceDeployment.getId(), history);
                }
            }
            catch (Throwable t) {
                BundleResourceDeploymentHistory failureHistory = new BundleResourceDeploymentHistory(subject.getName(), this.AUDIT_ACTION_DEPLOYMENT, deployment.getName(), null, BundleResourceDeploymentHistory.Status.FAILURE, "Failed to schedule, agent on [" + platform + "] may be down: " + t, null);
                this.bundleManager.addBundleResourceDeploymentHistory(subject, resourceDeployment.getId(), failureHistory);
                this.bundleManager.setBundleResourceDeploymentStatus(subject, resourceDeployment.getId(), BundleDeploymentStatus.FAILURE);
            }
        } else {
            this.bundleManager.setBundleResourceDeploymentStatus(subject, resourceDeployment.getId(), BundleDeploymentStatus.FAILURE);
            BundleResourceDeploymentHistory history = new BundleResourceDeploymentHistory(subject.getName(), "Deployment", deployment.getName(), null, BundleResourceDeploymentHistory.Status.FAILURE, "Target resource is not a platform [id=" + platform.getId() + "]. Fix target group for destination [" + deployment.getDestination().getName() + "]", null);
            this.bundleManager.addBundleResourceDeploymentHistory(subject, resourceDeployment.getId(), history);
        }
        return resourceDeployment;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleScheduleRequest getScheduleRequest(Subject subject, int resourceDeploymentId, boolean isCleanDeployment, boolean isRevert) throws Exception {
        BundleResourceDeploymentCriteria brdc = new BundleResourceDeploymentCriteria();
        brdc.addFilterId(Integer.valueOf(resourceDeploymentId));
        brdc.fetchResource(true);
        brdc.fetchBundleDeployment(true);
        PageList<BundleResourceDeployment> resourceDeployments = this.bundleManager.findBundleResourceDeploymentsByCriteria(subject, brdc);
        if (null == resourceDeployments || resourceDeployments.isEmpty()) {
            throw new IllegalArgumentException("Can not deploy using invalid resourceDeploymentId [" + resourceDeploymentId + "].");
        }
        BundleResourceDeployment resourceDeployment = (BundleResourceDeployment)resourceDeployments.get(0);
        BundleDeploymentCriteria bdc = new BundleDeploymentCriteria();
        bdc.addFilterId(Integer.valueOf(resourceDeployment.getBundleDeployment().getId()));
        bdc.fetchBundleVersion(true);
        bdc.fetchConfiguration(true);
        bdc.fetchDestination(true);
        BundleDeployment deployment = (BundleDeployment)this.bundleManager.findBundleDeploymentsByCriteria(subject, bdc).get(0);
        BundleCriteria bc = new BundleCriteria();
        bc.addFilterDestinationId(Integer.valueOf(deployment.getDestination().getId()));
        Bundle bundle = (Bundle)this.bundleManager.findBundlesByCriteria(subject, bc).get(0);
        ResourceTypeCriteria rtc = new ResourceTypeCriteria();
        rtc.addFilterBundleTypeId(Integer.valueOf(bundle.getBundleType().getId()));
        ResourceType resourceType = (ResourceType)this.resourceTypeManager.findResourceTypesByCriteria(subject, rtc).get(0);
        bundle.getBundleType().setResourceType(resourceType);
        deployment.getBundleVersion().setBundle(bundle);
        deployment.getDestination().setBundle(bundle);
        resourceDeployment.setBundleDeployment(deployment);
        HibernateDetachUtility.nullOutUninitializedFields((Object)resourceDeployment, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
        BundleScheduleRequest request = new BundleScheduleRequest(resourceDeployment);
        request.setCleanDeployment(isCleanDeployment);
        request.setRevert(isRevert);
        this.entityManager.clear();
        return request;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleResourceDeployment createBundleResourceDeployment(Subject subject, int bundleDeploymentId, int resourceId) throws Exception {
        BundleDeployment deployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)bundleDeploymentId);
        if (null == deployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + bundleDeploymentId);
        }
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (null == resource) {
            throw new IllegalArgumentException("Invalid resourceId (Resource does not exist): " + resourceId);
        }
        BundleResourceDeployment resourceDeployment = new BundleResourceDeployment(deployment, resource);
        this.entityManager.persist((Object)resourceDeployment);
        return resourceDeployment;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public BundleResourceDeployment setBundleResourceDeploymentStatus(Subject subject, int resourceDeploymentId, BundleDeploymentStatus status) throws Exception {
        BundleResourceDeployment resourceDeployment = (BundleResourceDeployment)this.entityManager.find(BundleResourceDeployment.class, (Object)resourceDeploymentId);
        if (null == resourceDeployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + resourceDeploymentId);
        }
        resourceDeployment.setStatus(status);
        BundleDeployment deployment = resourceDeployment.getBundleDeployment();
        List deployments = deployment.getResourceDeployments();
        boolean someInProgress = false;
        boolean someSuccess = false;
        boolean someFailure = false;
        for (BundleResourceDeployment rd : deployments) {
            switch (rd.getStatus()) {
                case SUCCESS: {
                    someSuccess = true;
                    break;
                }
                case FAILURE: {
                    someFailure = true;
                    break;
                }
                case IN_PROGRESS: {
                    someInProgress = true;
                }
            }
        }
        if (someInProgress) {
            deployment.setStatus(BundleDeploymentStatus.IN_PROGRESS);
        } else if (someSuccess) {
            deployment.setStatus(someFailure ? BundleDeploymentStatus.MIXED : BundleDeploymentStatus.SUCCESS);
        } else {
            deployment.setStatus(BundleDeploymentStatus.FAILURE);
        }
        return resourceDeployment;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public Set<String> getBundleVersionFilenames(Subject subject, int bundleVersionId, boolean withoutBundleFileOnly) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        BundleType bundleType = bundleVersion.getBundle().getBundleType();
        RecipeParseResults parseResults = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager().parseRecipe(bundleType.getName(), bundleVersion.getRecipe());
        Set<String> result = parseResults.getBundleFileNames();
        if (withoutBundleFileOnly) {
            List bundleFiles = bundleVersion.getBundleFiles();
            Set<String> allFilenames = result;
            result = new HashSet<String>(allFilenames.size() - bundleFiles.size());
            for (String filename : allFilenames) {
                boolean found = false;
                for (BundleFile bundleFile : bundleFiles) {
                    String name = bundleFile.getPackageVersion().getGeneralPackage().getName();
                    if (!name.equals(filename)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                result.add(filename);
            }
        }
        return result;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public HashMap<String, Boolean> getAllBundleVersionFilenames(Subject subject, int bundleVersionId) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        BundleType bundleType = bundleVersion.getBundle().getBundleType();
        RecipeParseResults parseResults = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager().parseRecipe(bundleType.getName(), bundleVersion.getRecipe());
        Set<String> filenames = parseResults.getBundleFileNames();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(filenames.size());
        List bundleFiles = bundleVersion.getBundleFiles();
        for (String filename : filenames) {
            boolean found = false;
            for (BundleFile bundleFile : bundleFiles) {
                String name = bundleFile.getPackageVersion().getGeneralPackage().getName();
                if (!name.equals(filename)) continue;
                found = true;
                break;
            }
            result.put(filename, found);
        }
        return result;
    }

    @Override
    public List<BundleType> getAllBundleTypes(Subject subject) {
        Query q = this.entityManager.createNamedQuery("BundleType.findAll");
        List types = q.getResultList();
        return types;
    }

    @Override
    public BundleType getBundleType(Subject subject, String bundleTypeName) {
        Query q = this.entityManager.createNamedQuery("BundleType.findByName");
        q.setParameter("name", (Object)bundleTypeName);
        BundleType type = (BundleType)q.getSingleResult();
        return type;
    }

    @Override
    public PageList<BundleDeployment> findBundleDeploymentsByCriteria(Subject subject, BundleDeploymentCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<BundleDestination> findBundleDestinationsByCriteria(Subject subject, BundleDestinationCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<BundleResourceDeployment> findBundleResourceDeploymentsByCriteria(Subject subject, BundleResourceDeploymentCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            if (criteria.isInventoryManagerRequired()) {
                throw new PermissionException("Subject [" + subject.getName() + "] requires InventoryManager permission for requested query criteria.");
            }
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, null, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<BundleVersion> findBundleVersionsByCriteria(Subject subject, BundleVersionCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<BundleFile> findBundleFilesByCriteria(Subject subject, BundleFileCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<Bundle> findBundlesByCriteria(Subject subject, BundleCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<BundleWithLatestVersionComposite> findBundlesWithLatestVersionCompositesByCriteria(Subject subject, BundleCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        String replacementSelectList = " new org.rhq.core.domain.bundle.composite.BundleWithLatestVersionComposite(    bundle.id,   bundle.name,   bundle.description,   ( SELECT bv1.version FROM bundle.bundleVersions bv1 WHERE bv1.versionOrder = (SELECT MAX(bv2.versionOrder) FROM BundleVersion bv2 WHERE bv2.bundle.id = bundle.id) ) AS latestVersion,   ( SELECT COUNT(bv3) FROM bundle.bundleVersions bv3 WHERE bv3.bundle.id = bundle.id) AS deploymentCount ) ";
        generator.alterProjection(replacementSelectList);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList results = queryRunner.execute();
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public void deleteBundle(Subject subject, int bundleId) throws Exception {
        Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
        if (null == bundle) {
            return;
        }
        Query q = this.entityManager.createNamedQuery("BundleVersion.findByBundleId");
        q.setParameter("bundleId", (Object)bundleId);
        List bvs = q.getResultList();
        for (BundleVersion bv : bvs) {
            this.bundleManager.deleteBundleVersion(subject, bv.getId(), false);
            this.entityManager.flush();
        }
        Repo bundleRepo = bundle.getRepo();
        this.entityManager.remove((Object)bundle);
        this.entityManager.flush();
        this.repoManager.deleteRepo(subject, bundleRepo.getId());
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public void deleteBundleDeployment(Subject subject, int bundleDeploymentId) throws Exception {
        BundleDeployment doomed = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)bundleDeploymentId);
        if (null == doomed) {
            return;
        }
        if (!BundleDeploymentStatus.PENDING.equals((Object)doomed.getStatus())) {
            throw new IllegalArgumentException("Can not delete deployment with status [" + doomed.getStatus() + "]");
        }
        this.entityManager.remove((Object)doomed);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public void deleteBundleDestination(Subject subject, int destinationId) throws Exception {
        BundleDestination doomed = (BundleDestination)this.entityManager.find(BundleDestination.class, (Object)destinationId);
        if (null == doomed) {
            return;
        }
        Query q = this.entityManager.createNamedQuery("BundleDeployment.updateForDestinationRemove");
        q.setParameter("destinationId", (Object)destinationId);
        q.executeUpdate();
        this.entityManager.flush();
        this.entityManager.remove((Object)doomed);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_BUNDLE)
    public void deleteBundleVersion(Subject subject, int bundleVersionId, boolean deleteBundleIfEmpty) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            return;
        }
        int bundleId = 0;
        if (deleteBundleIfEmpty) {
            bundleId = bundleVersion.getBundle().getId();
        }
        Query q = this.entityManager.createNamedQuery("BundleDeployment.updateForVersionRemove");
        q.setParameter("bundleVersionId", (Object)bundleVersionId);
        int rowsUpdated = q.executeUpdate();
        this.entityManager.flush();
        this.entityManager.remove((Object)bundleVersion);
        if (deleteBundleIfEmpty) {
            this.entityManager.flush();
            q = this.entityManager.createNamedQuery("BundleVersion.findVersionsByBundleId");
            q.setParameter("bundleId", (Object)bundleId);
            if (q.getResultList().size() == 0) {
                this.deleteBundle(subject, bundleId);
            }
        }
    }

    private void safeClose(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to close InputStream", (Throwable)e);
            }
        }
    }

    private void safeClose(OutputStream os) {
        if (null != os) {
            try {
                os.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to close OutputStream", (Throwable)e);
            }
        }
    }
}

