/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemInformation {
    private final Log log;
    private Map<Property, String> properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SystemInformation() {
        Connection conn;
        block10: {
            HashMap<Property, String> values3222;
            this.log = LogFactory.getLog(SystemInformation.class);
            DataSource ds = null;
            conn = null;
            try {
                try {
                    ds = LookupUtil.getDataSource();
                    conn = ds.getConnection();
                    DatabaseMetaData metadata = conn.getMetaData();
                    String url = metadata.getURL();
                    String productName = metadata.getDatabaseProductName();
                    String productVersion = metadata.getDatabaseProductVersion();
                    String driverName = metadata.getDriverName();
                    String driverVersion = metadata.getDriverVersion();
                    HashMap<Property, String> values2 = new HashMap<Property, String>();
                    values2.put(Property.DATABASE_CONNECTION_URL, url);
                    values2.put(Property.DATABASE_PRODUCT_NAME, productName);
                    values2.put(Property.DATABASE_PRODUCT_VERSION, productVersion);
                    values2.put(Property.DATABASE_DRIVER_NAME, driverName);
                    values2.put(Property.DATABASE_DRIVER_VERSION, driverVersion);
                    this.properties = Collections.unmodifiableMap(values2);
                }
                catch (Exception e) {
                    this.log.error((Object)("Could not load properties for " + SystemInformation.class.getSimpleName()));
                    Object var11_12 = null;
                    if (this.properties == null) {
                        HashMap<Property, String> values3222 = new HashMap<Property, String>();
                        for (Property prop : Property.values()) {
                            values3222.put(prop, "Could not determine");
                        }
                        this.properties = Collections.unmodifiableMap(values3222);
                    }
                    JDBCUtil.safeClose((Connection)conn);
                    return;
                }
                Object var11_11 = null;
                if (this.properties != null) break block10;
                values3222 = new HashMap<Property, String>();
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (this.properties == null) {
                    HashMap<Property, String> values3222 = new HashMap<Property, String>();
                    for (Property prop : Property.values()) {
                        values3222.put(prop, "Could not determine");
                    }
                    this.properties = Collections.unmodifiableMap(values3222);
                }
                JDBCUtil.safeClose((Connection)conn);
                throw throwable;
            }
            for (Property prop : Property.values()) {
                values3222.put(prop, "Could not determine");
            }
            this.properties = Collections.unmodifiableMap(values3222);
        }
        JDBCUtil.safeClose((Connection)conn);
    }

    public static SystemInformation getInstance() {
        return new SystemInformation();
    }

    public Map<Property, String> getProperties(Property property) {
        return this.properties;
    }

    public String getDatabaseConnectionURL() {
        return this.properties.get((Object)Property.DATABASE_CONNECTION_URL);
    }

    public String getDatabaseProductName() {
        return this.properties.get((Object)Property.DATABASE_PRODUCT_NAME);
    }

    public String getDatabaseProductVersion() {
        return this.properties.get((Object)Property.DATABASE_PRODUCT_VERSION);
    }

    public String getDatabaseDriverName() {
        return this.properties.get((Object)Property.DATABASE_DRIVER_NAME);
    }

    public String getDatabaseDriverVersion() {
        return this.properties.get((Object)Property.DATABASE_DRIVER_VERSION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        DATABASE_CONNECTION_URL,
        DATABASE_PRODUCT_NAME,
        DATABASE_PRODUCT_VERSION,
        DATABASE_DRIVER_NAME,
        DATABASE_DRIVER_VERSION;

    }
}

