/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.jaas;

import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.group.LdapGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.security.UntrustedSSLSocketFactory;

public class LdapLoginModule
extends UsernamePasswordLoginModule {
    private Log log = LogFactory.getLog(LdapLoginModule.class);
    LdapGroupManagerLocal ldapManager = LookupUtil.getLdapGroupManager();
    private static final String BASEDN_DELIMITER = ";";

    protected String getUsersPassword() throws LoginException {
        return "";
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        return roleSets;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        Properties env = this.getProperties();
        String baseDN = (String)this.options.get("BaseDN");
        if (baseDN == null) {
            this.log.info((Object)"BaseDN is not set, refusing login");
            return false;
        }
        if (inputPassword == null || inputPassword.equals("")) {
            this.log.debug((Object)"Empty password, refusing login");
            return false;
        }
        String loginProperty = (String)this.options.get("LoginProperty");
        if (loginProperty == null) {
            loginProperty = "cn";
        }
        String searchFilter = (String)this.options.get("Filter");
        String userName = this.getUsername();
        String bindDN = (String)this.options.get("BindDN");
        String bindPW = (String)this.options.get("BindPW");
        if (bindDN != null) {
            env.setProperty("java.naming.security.principal", bindDN);
            env.setProperty("java.naming.security.credentials", bindPW);
            env.setProperty("java.naming.security.authentication", "simple");
        }
        try {
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            SearchControls searchControls = this.getSearchControls();
            String filter = searchFilter != null && searchFilter.length() != 0 ? "(&(" + loginProperty + "=" + userName + ")" + "(" + searchFilter + "))" : "(" + loginProperty + "=" + userName + ")";
            this.log.debug((Object)("Using LDAP filter=" + filter));
            String[] baseDNs = baseDN.split(BASEDN_DELIMITER);
            for (int x = 0; x < baseDNs.length; ++x) {
                NamingEnumeration<SearchResult> answer = ctx.search(baseDNs[x], filter, searchControls);
                boolean ldapApiNpeFound = false;
                if (answer.hasMoreElements()) {
                    SearchResult si = answer.next();
                    String userDN = si.getName() + "," + baseDNs[x];
                    ctx.addToEnvironment("java.naming.security.principal", userDN);
                    ctx.addToEnvironment("java.naming.security.credentials", inputPassword);
                    ctx.addToEnvironment("java.naming.security.authentication", "simple");
                    ctx.reconnect(null);
                    String groupFilter = (String)this.options.get("GroupFilter");
                    String groupMember = (String)this.options.get("GroupMemberFilter");
                    SubjectManagerLocal sManager = LookupUtil.getSubjectManager();
                    Subject ldapSubject = sManager.getSubjectByName(this.getUsername());
                    if (ldapSubject != null && groupFilter != null && !groupFilter.trim().equals("") && groupMember != null && !groupMember.trim().equals("")) {
                        Set<String> authorizedLdapGroups = this.ldapManager.findAvailableGroupsFor(userName);
                        RoleManagerLocal roleManager = LookupUtil.getRoleManager();
                        PageList<LdapGroup> allCurrentLdapGroupsRegistered = this.ldapManager.findLdapGroups(PageControl.getUnlimitedInstance());
                        for (LdapGroup gp : allCurrentLdapGroupsRegistered) {
                            if (gp.getRole() == null) continue;
                            gp.getRole().removeSubject(ldapSubject);
                        }
                        if (authorizedLdapGroups.isEmpty()) {
                            return true;
                        }
                        ArrayList<String> authorizedList = new ArrayList<String>(authorizedLdapGroups);
                        this.ldapManager.assignRolesToLdapSubject(ldapSubject.getId(), authorizedList);
                    }
                    return true;
                }
                this.log.debug((Object)("User " + userName + " not found for BaseDN " + baseDNs[x]));
            }
            return false;
        }
        catch (Exception e) {
            this.log.info((Object)("Failed to validate password: " + e.getMessage()));
            return false;
        }
    }

    private Properties getProperties() {
        String providerUrl;
        String protocol;
        Properties env = new Properties();
        for (Map.Entry entry : this.options.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            env.put(entry.getKey(), entry.getValue());
        }
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            env.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        if ((protocol = env.getProperty("java.naming.security.protocol")) != null && protocol.equals("ssl")) {
            String ldapSocketFactory = env.getProperty("java.naming.ldap.factory.socket");
            if (ldapSocketFactory == null) {
                env.put("java.naming.ldap.factory.socket", UntrustedSSLSocketFactory.class.getName());
            }
            env.put("java.naming.security.protocol", "ssl");
        }
        if ((providerUrl = env.getProperty("java.naming.provider.url")) == null) {
            providerUrl = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
        }
        env.setProperty("java.naming.provider.url", providerUrl);
        env.setProperty("java.naming.referral", "ignore");
        return env;
    }

    private SearchControls getSearchControls() {
        int scope = 2;
        int timeLimit = 0;
        long countLimit = 0L;
        String[] returnedAttributes = null;
        boolean returnObject = false;
        boolean deference = false;
        SearchControls constraints = new SearchControls(scope, countLimit, timeLimit, returnedAttributes, returnObject, deference);
        return constraints;
    }
}

