/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.cts.jms;

import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;

public class ContainerMBox
implements MessageListener {
    public static final String JMS_FACTORY = "ConnectionFactory";
    public static final String QUEUE = "queue/testQueue";
    private QueueConnectionFactory qconFactory;
    private QueueConnection qcon;
    private QueueSession qsession;
    private QueueReceiver qreceiver;
    private Queue queue;
    private Logger log;
    public static final String EJB_CREATE_MSG = "EJB_CREATE_MSG";
    public static final String EJB_POST_CREATE_MSG = "EJB_POST_CREATE_MSG";
    public static final String EJB_ACTIVATE_MSG = "EJB_ACTIVATE_MSG";
    public static final String EJB_PASSIVATE_MSG = "EJB_PASSIVATE_MSG";
    public static final String EJB_REMOVE_MSG = "EJB_REMOVE_MSG";
    public static final String EJB_LOAD_MSG = "EJB_LOAD_MSG";
    public static final String EJB_STORE_MSG = "EJB_STORE_MSG";
    public static final String SET_ENTITY_CONTEXT_MSG = "SET_ENTITY_CONTEXT_MSG";
    public static final String UNSET_ENTITY_CONTEXT_MSG = "UNSET_ENTITY_CONTEXT_MSG";
    private HashMap messageList = new HashMap();

    public ContainerMBox() {
        this.log = Logger.getLogger((String)this.getClass().getName());
        try {
            this.init(new InitialContext(), QUEUE);
        }
        catch (Exception ex) {
            this.log.error((Object)"MBox could not get initial context", (Throwable)ex);
        }
    }

    public void onMessage(Message msg) {
        try {
            String msgText = msg instanceof TextMessage ? ((TextMessage)msg).getText() : msg.toString();
            this.log.debug((Object)("[BEAN MESSAGE]: " + msgText));
            this.messageList.put(msgText, "msg");
        }
        catch (JMSException jmse) {
            this.log.error((Object)"problem receiving MBox message", (Throwable)jmse);
        }
    }

    public void init(Context ctx, String queueName) throws NamingException, JMSException {
        this.qconFactory = (QueueConnectionFactory)ctx.lookup(JMS_FACTORY);
        this.qcon = this.qconFactory.createQueueConnection();
        this.qsession = this.qcon.createQueueSession(false, 1);
        try {
            this.queue = (Queue)ctx.lookup(queueName);
        }
        catch (NamingException ne) {
            this.queue = this.qsession.createQueue(queueName);
            ctx.bind(queueName, (Object)this.queue);
        }
        this.qreceiver = this.qsession.createReceiver(this.queue);
        this.qreceiver.setMessageListener((MessageListener)this);
        this.qcon.start();
    }

    public void close() throws JMSException {
        this.qreceiver.close();
        this.qsession.close();
        this.qcon.close();
    }

    public boolean messageReceived(String message) {
        return this.messageList.containsKey(message);
    }

    public void clearMessages() {
        this.messageList = null;
        this.messageList = new HashMap();
    }
}

