/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import org.rhq.core.db.DatabaseTypeFactory;

public class QueryUtility {
    private static String ESCAPE_CHARACTER = null;
    private static String ESCAPE_CLAUSE_CHARACTER = null;
    private static String ESCAPED_ESCAPE = null;
    private static String ESCAPED_PERCENT = null;
    private static String ESCAPED_UNDERSCORE = null;

    public static String escapeSearchParameter(String value) {
        if (value == null || value.trim().equals("")) {
            return null;
        }
        return QueryUtility.doEscapeSearchParameter(value);
    }

    private static String doEscapeSearchParameter(String value) {
        QueryUtility.init();
        value = value.replace(ESCAPE_CHARACTER, ESCAPED_ESCAPE);
        value = value.replace("_", ESCAPED_UNDERSCORE);
        value = value.replace("%", ESCAPED_PERCENT);
        return value;
    }

    public static String formatSearchParameter(String value) {
        if (value == null || value.trim().equals("")) {
            return null;
        }
        return "%" + QueryUtility.doEscapeSearchParameter(value).toUpperCase() + "%";
    }

    public static String getEscapeClause() {
        QueryUtility.init();
        return " ESCAPE '" + ESCAPE_CLAUSE_CHARACTER + "' ";
    }

    public static String getEscapeClauseCharacter() {
        QueryUtility.init();
        return ESCAPE_CLAUSE_CHARACTER;
    }

    public static String getEscapeCharacter() {
        QueryUtility.init();
        return ESCAPE_CHARACTER;
    }

    private static void init() {
        if (null == ESCAPE_CLAUSE_CHARACTER) {
            ESCAPE_CLAUSE_CHARACTER = DatabaseTypeFactory.getDefaultDatabaseType().getEscapeCharacter();
            int len = ESCAPE_CLAUSE_CHARACTER.length();
            ESCAPE_CHARACTER = len > 1 ? ESCAPE_CLAUSE_CHARACTER.substring(len - 1) : ESCAPE_CLAUSE_CHARACTER;
            ESCAPED_ESCAPE = ESCAPE_CHARACTER + ESCAPE_CHARACTER;
            ESCAPED_UNDERSCORE = ESCAPE_CHARACTER + "_";
            ESCAPED_PERCENT = ESCAPE_CHARACTER + "%";
        }
    }
}

