CREATE TABLE CUSTOMER (
		CUSTID VARCHAR(250) NOT NULL DEFAULT,
		CUSTPWD VARCHAR(250),
		CUSTNAME VARCHAR(250),
		NUMINVOICESCREATED INTEGER NOT NULL DEFAULT,
		NUMINVOICESCOMPLETED INTEGER NOT NULL DEFAULT
	);

CREATE TABLE CUSTOMERINFO (
		CUSTID VARCHAR(250) NOT NULL DEFAULT,
		ADDRESS1 VARCHAR(250),
		ADDRESS2 VARCHAR(250),
		PHONE VARCHAR(250),
		EMAIL VARCHAR(250),
		CCNUM VARCHAR(250)
	);

CREATE TABLE CATEGORY (
		CATEGORYNAME VARCHAR(250) NOT NULL DEFAULT,
		NUMITEMSINCATEGORY INTEGER NOT NULL DEFAULT,
		CATEGORYDESCRIPTION VARCHAR(250)
	);

CREATE TABLE INVENTORY (
		CATEGORYNAME VARCHAR(250),
		ITEMID VARCHAR(250) NOT NULL DEFAULT,
		MFGNAME VARCHAR(250),
		UNITPRICE REAL NOT NULL DEFAULT,
		INVENTORYSOLD INTEGER NOT NULL DEFAULT,
		DESCRIPTION VARCHAR(250),
		PIC VARCHAR (1000) FOR BIT DATA
	);

CREATE TABLE MFGCATEGORY (
		MFGNAME VARCHAR(250) NOT NULL DEFAULT,
		CATEGORY_CATEGORYNAME VARCHAR(250) NOT NULL DEFAULT
	);

CREATE TABLE STORECREDIT (
		AMOUNT REAL NOT NULL DEFAULT,
		CUSTID VARCHAR(250) NOT NULL DEFAULT,
		TIME1 TIMESTAMP NOT NULL DEFAULT
	);

CREATE TABLE SETTINGS (
		ID INTEGER NOT NULL DEFAULT,
		NUMSUBACCOUNTS INTEGER NOT NULL DEFAULT,
		NUMCATEGORIES INTEGER NOT NULL DEFAULT,
		NUMMFGCATEGORIES INTEGER NOT NULL DEFAULT,
		NUMITEMSPERMFG INTEGER NOT NULL DEFAULT,
		NUMCUSTOMERS INTEGER NOT NULL DEFAULT,
		WSATENABLED SMALLINT NOT NULL DEFAULT,
		WSNENABLED SMALLINT NOT NULL DEFAULT,
		SDOENABLED SMALLINT NOT NULL DEFAULT,
		WSNVARIABLES VARCHAR(250)
	);

ALTER TABLE CUSTOMER ADD CONSTRAINT PK_CUSTOMER PRIMARY KEY (CUSTID);

ALTER TABLE CUSTOMERINFO ADD CONSTRAINT PK_CUSTOMERINFO PRIMARY KEY (CUSTID);

ALTER TABLE CATEGORY ADD CONSTRAINT PK_CATEGORY PRIMARY KEY (CATEGORYNAME);

ALTER TABLE INVENTORY ADD CONSTRAINT PK_INVENTORY PRIMARY KEY (ITEMID);

ALTER TABLE MFGCATEGORY ADD CONSTRAINT PK_MFGCATEGORY PRIMARY KEY (MFGNAME, CATEGORY_CATEGORYNAME);

ALTER TABLE STORECREDIT ADD CONSTRAINT PK_STORECREDIT PRIMARY KEY (CUSTID, TIME1);

ALTER TABLE SETTINGS ADD CONSTRAINT PK_SETTINGS PRIMARY KEY (ID);

