package com.ibm.ws.servletContainerInitializer;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ListenerImpl implements ServletContextListener {

    @Override
    public void contextDestroyed(ServletContextEvent arg0) {
        System.out.println("ListenerImpl.contextDestroyed " + arg0.getServletContext().getServletContextName());
    }

    @Override
    public void contextInitialized(ServletContextEvent arg0) {
        System.out.println("ListenerImpl.contextInitialized " + arg0.getServletContext().getServletContextName());
        arg0.getServletContext().setAttribute("ListenerImplContextInitialized", "executed");
        try {
            arg0.getServletContext().addListener("com.ibm.ws.servletContainerInitializer.ServletRequestListenerImpl");
        } catch (UnsupportedOperationException e) {
            arg0.getServletContext().setAttribute("UnsupportedOperationExceptionThrown", "true");
        }
    }
    
    

}
