/*******************************************************************************
 * Copyright (c) 2016 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.security.jwt.utils;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.jose4j.jwt.JwtClaims;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

import test.common.SharedOutputManager;

public class JwtDataTest {

	private static SharedOutputManager outputMgr = SharedOutputManager.getInstance()
			.trace("com.ibm.ws.security.jwt.*=all");

	@Rule
	public final TestName testName = new TestName();

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		outputMgr.captureStreams();
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		outputMgr.dumpStreams();
		outputMgr.resetStreams();
		outputMgr.restoreStreams();
	}

	@Before
	public void beforeTest() {
		System.out.println("Entering test: " + testName.getMethodName());
	}

	@After
	public void tearDown() throws Exception {
		System.out.println("Exiting test: " + testName.getMethodName());
	}

	/**
	 * Test configuration values.
	 */
	@Test
	public void testConstructor() {
		try {
			JwtData data = new JwtData(null, null);
			assertNotNull("JwtData was null when it should not have been.", data);
		} catch (Throwable t) {
			outputMgr.failWithThrowable(testName.getMethodName(), t);
		}
	}

	/**
	 * check when creating a jwt token, it includes typ JWT in the header.
	 */
	@Test
	public void testSignerIncludesCorrectKeyTypeForJWT() {
		try {

			JwtData data = new JwtData(null, null);
			data.bJwtToken = true;
			data.signatureAlgorithm = "none";
			JwtClaims claims = new JwtClaims();
			String result = JwsSigner.getSignedJwt(claims, data);
			String header = JwtUtils.splitTokenString(result)[0];
			String decodedHeader = JwtUtils.decodeFromBase64String(header);
			System.out.println("decoded header: " + decodedHeader);
			assertTrue(decodedHeader.contains("\"typ\":\"JWT\""));
		} catch (Throwable t) {
			outputMgr.failWithThrowable(testName.getMethodName(), t);
		}
	}

}
