/*******************************************************************************
 * Copyright (c) 2018 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package mpRestClient11.async;

import java.util.concurrent.CompletionStage;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path("/bank")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public interface BankAccountClient {

    @GET
    CompletionStage<Double> currentBalance();

    @DELETE
    @Path("/{amt}")
    CompletionStage<Double> withdraw(@PathParam("amt") Double amount) throws InsufficientFundsException;

    @GET
    CompletionStage<Response> currentBalanceResponse();

    @DELETE
    @Path("/{amt}")
    CompletionStage<Response> withdrawResponse(@PathParam("amt") Double amount) throws InsufficientFundsException;
}
