/*******************************************************************************
 * Copyright (c) 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package com.ibm.ws.sib.utils;

/**
 * This class contains 'product' trace group constants. All trace groups
 * should be defined here so that we have a single point of reference.
 */

public final class TraceGroups {

  public final static String TRGRP_ADMIN             = "SIBAdmin";
  public final static String TRGRP_CLIENT            = "SIBClient";
  public final static String TRGRP_COMMON            = "SIBCommon";
  public final static String TRGRP_COMMS             = "SIBCommunications";
  public final static String TRGRP_COMMS_FAP_FLOW    = "SIBCommunicationsFapFlows";
  public final static String TRGRP_CORE              = "SIBCore";
  public final static String TRGRP_DISPATCHER        = "SIBDispatcher";
  public final static String TRGRP_EXAMPLE           = "SIBExample";
  public final static String TRGRP_EXITPOINT         = "SIBExitpoint";
  public final static String TRGRP_IBL               = "SIBIbl";
  public final static String TRGRP_JFAP              = "SIBJFapChannel";
  public final static String TRGRP_JFAPSUMMARY       = "SIBJFapSummary";
  public final static String TRGRP_JMF               = "SIBJmf";
  public final static String TRGRP_JMSRA             = "SIBJmsRa";
  public final static String TRGRP_JMS_EXT           = "SIBJms_External";
  public final static String TRGRP_JMS_INT           = "SIBJms_Internal";
  public final static String TRGRP_MATCHSPACE        = "SIBMatchSpace";
  public final static String TRGRP_MEDIATIONS        = "SIBMediations";
  public final static String TRGRP_MESSAGETRACE      = "SIBMessageTrace";
  public final static String TRGRP_MESSAGETRACEJFAP  = "SIBMessageTraceJFap";
  public final static String TRGRP_MESSAGETRACECOMMS = "SIBMessageTraceComms";
  public final static String TRGRP_MESSAGETRACEMECOMMS = "SIBMessageTraceMEComms";
  public final static String TRGRP_MESSAGETRACECONTENTSMEDIATION = "SIBMessageTraceContentsMediation";
  public final static String TRGRP_MFP               = "SIBMfp";
  public final static String TRGRP_MFPAPI            = "SIBMfpApi";
  public final static String TRGRP_MFPMQ             = "SIBMfpMq";
  public final static String TRGRP_MFPSDO            = "SIBMfpSdo";
  public final static String TRGRP_MQFAP             = "SIBMqFapChannel";
  public final static String TRGRP_MSGSTORE          = "SIBMessageStore";
  public final static String TRGRP_MSGMIGRATION      = "SIBMigrationUtil";
  public final static String TRGRP_OBJMANAGER        = "SIBObjectManager";
  public final static String TRGRP_PROCESSOR         = "SIBProcessor";
  public final static String TRGRP_PSB               = "SIBPsb";
  public final static String TRGRP_RA                = "SIBJmsRaCommon";
  public final static String TRGRP_RMQ               = "SIBRmq";
  public final static String TRGRP_SDOREP            = "SIBSdoRepository";
  public final static String TRGRP_SECURITY          = "SIBSecurity";
  public final static String TRGRP_TRM               = "SIBTrm";
  public final static String TRGRP_UTILS             = "SIBUtils";
  public final static String TRGRP_WLMCLASSIFIER     = "SIBWlmClassifier";
  public final static String TRGRP_WSN               = "SIBWsn";
  public final static String TRGRP_COMPONENTIZATION  = "SIBOSGi";

}
