/*******************************************************************************
 * Copyright (c) 2018 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.jsf23.fat.cdi.common.beans.injected;

import javax.enterprise.inject.Produces;

/**
 *
 */
public class FieldBean {

    protected String value;

    /**
     * @param string
     */
    public void addData(String string) {
        value = value + ":" + string;
    }

    public String getData() {
        return this.getClass() + (value == null ? ":" : ":" + value);
    }

    private final String producerText = ":ProducerInjected:";

    @Produces
    @ProducerType
    String getProducerType() {
        return producerText;
    }
}
