/*******************************************************************************
 * Copyright (c) 2018 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package jaxrs21.fat.atinject;

import java.util.HashSet;
import java.util.Set;

import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;

@ApplicationPath("/")
public class AtInjectApp extends Application {

    @Override
    public Set<Class<?>> getClasses() {
        Set<Class<?>> set = new HashSet<>();
        set.add(AtInjectDirectService.class);
        set.add(AtInjectDirectService2.class);
        set.add(AtInjectOnManagedObjectService.class);
        return set;
    }

    static String toResponse(AbstractInjectedObject obj) {
        if (obj == null) {
            return "null:-1";
        }
        return obj.getInjectionTargetType() + ":" + obj.getId();
    }
}
