/*******************************************************************************
 * Copyright (c) 2007, 2019 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.ejbcontainer.bindings.fat.tests;

import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.runner.RunWith;

import com.ibm.websphere.simplicity.ShrinkHelper;
import com.ibm.ws.ejbcontainer.bindings.bnd.web.BindingsServlet;

import componenttest.annotation.Server;
import componenttest.annotation.TestServlet;
import componenttest.annotation.TestServlets;
import componenttest.custom.junit.runner.FATRunner;
import componenttest.rules.repeater.FeatureReplacementAction;
import componenttest.rules.repeater.RepeatTests;
import componenttest.topology.impl.LibertyServer;
import componenttest.topology.utils.FATServletClient;

@RunWith(FATRunner.class)
public class CustomBindingsTest extends FATServletClient {

    @Server("com.ibm.ws.ejbcontainer.bindings.fat.server")
    @TestServlets({ @TestServlet(servlet = BindingsServlet.class, contextRoot = "EJB3BndWeb") })
    public static LibertyServer server;

    @ClassRule
    public static RepeatTests r = RepeatTests.with(FeatureReplacementAction.EE7_FEATURES().forServers("com.ibm.ws.ejbcontainer.bindings.fat.server")).andWith(FeatureReplacementAction.EE8_FEATURES().forServers("com.ibm.ws.ejbcontainer.bindings.fat.server"));

    @BeforeClass
    public static void setUp() throws Exception {
        // Use ShrinkHelper to build the ears
        JavaArchive EJB3BndBean = ShrinkHelper.buildJavaArchive("EJB3BndBean.jar", "com.ibm.ws.ejbcontainer.bindings.bnd.ejb.");
        ShrinkHelper.addDirectory(EJB3BndBean, "test-applications/EJB3BndBean.jar/resources");
        WebArchive EJB3BndWeb = ShrinkHelper.buildDefaultApp("EJB3BndWeb.war", "com.ibm.ws.ejbcontainer.bindings.bnd.web.");
        EnterpriseArchive EJB3BndTestApp = ShrinkWrap.create(EnterpriseArchive.class, "EJB3BndTestApp.ear");
        EJB3BndTestApp.addAsModules(EJB3BndBean, EJB3BndWeb);
        ShrinkHelper.addDirectory(EJB3BndTestApp, "test-applications/EJB3BndTestApp.ear/resources");

        ShrinkHelper.exportDropinAppToServer(server, EJB3BndTestApp);

        server.startServer();
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        if (server != null && server.isStarted()) {
            server.stopServer();
        }
    }

}
