/*******************************************************************************
 * Copyright (c) 2019 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package cdi.hibernate.test.model;

import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Version;

import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;

@Entity
@Indexed
public class EntityA {
    
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Id
    private int id;
    
    @Field
    private String strData;
    
    @Field
    @FieldBridge(impl = BasicFieldBridge.class)
    private String lazyStringData;

    @OneToOne
    private EntityB entityB;
    
    @Version
    private long version;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getStrData() {
        return strData;
    }

    public void setStrData(String strData) {
        this.strData = strData;
    }

    public String getLazyStringData() {
        return lazyStringData;
    }

    public void setLazyStringData(String lazyStringData) {
        this.lazyStringData = lazyStringData;
    }

    public EntityB getEntityB() {
        return entityB;
    }

    public void setEntityB(EntityB entityB) {
        this.entityB = entityB;
    }

    public long getVersion() {
        return version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "EntityA [id=" + id + ", strData=" + strData + ", lazyStringData=" + lazyStringData + ", entityB="
                + entityB + ", version=" + version + "]";
    }

}
