/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.secfvt.utils;

import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.auth.callback.WSCallbackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSGUICallbackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSStdinCallbackHandlerImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.secfvt.build.tools.Logger;
import com.ibm.ws.secfvt.ejb.JAASMapping;
import com.ibm.ws.secfvt.ejb.JAASMappingHome;
import com.ibm.ws.secfvt.ejb.SecFVTS1;
import com.ibm.ws.secfvt.ejb.SecFVTS1Home;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class Helper {
    private static final String AUTHORIZATION_FAILED = "NO_PERMISSION";
    static final ResourceBundle BUNDLE = ResourceBundle.getBundle("secfvt");
    private static Random generator = null;

    public static WSCredential login(String user, String realm, String password) throws Exception {
        Subject subject = null;
        LoginContext lc = null;
        WSCallbackHandlerImpl wscbh = new WSCallbackHandlerImpl(user, realm, password);
        String _loginType = BUNDLE.getString("loginType");
        System.err.println("user is " + user);
        System.err.println("password is " + password);
        System.err.println("realm is " + realm);
        System.err.println("loginType is " + _loginType);
        try {
            lc = new LoginContext(_loginType, (CallbackHandler)wscbh);
        }
        catch (LoginException le) {
            System.err.println("Failed to create LoginContext" + le.getMessage());
            le.printStackTrace();
            throw le;
        }
        catch (SecurityException se) {
            System.err.println("Failed to create LoginContext" + se.getMessage());
            se.printStackTrace();
            throw se;
        }
        try {
            lc.login();
        }
        catch (SecurityException se) {
            System.err.println("Failed to login");
            se.printStackTrace();
            throw se;
        }
        subject = lc.getSubject();
        if (subject == null) {
            System.err.println("Failed to get the subject from LoginContext");
            return null;
        }
        WSCredential cred = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
        if (cred == null) {
            System.err.println("Failed to get the cred from Subject");
            return null;
        }
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            WSSubject.setRunAsSubject((Subject)subject);
        }
        catch (Exception e) {
            System.err.println("Failed to set invocation credential");
            throw e;
        }
        return cred;
    }

    public static WSCredential login(String loginType, String user, String realm, String password, String hostname, String port, String msgData) throws Exception {
        WSGUICallbackHandlerImpl wscbh;
        Subject subject = null;
        LoginContext lc = null;
        String loginData = "\n\tuser id\t\t = " + user + "\n\trealm name\t\t = " + realm + "\n\tuser password\t = " + password + "\n\thostname\t = " + hostname + "\n\tport\t = " + port;
        System.out.println("Suggested " + msgData + " is: " + loginData);
        String _loginType = BUNDLE.getString("loginType");
        System.err.println("loginType is " + _loginType);
        if (loginType.equalsIgnoreCase("properties") || loginType.equalsIgnoreCase("apiPrompt")) {
            System.out.println("Returning null credential since we should be either using properties \nor allowing the lookup and ejbCreate to get the authentication themselves");
            return null;
        }
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
        String iiopString = "iiop://" + hostname + ":" + port;
        p.put("java.naming.provider.url", iiopString);
        generator = new Random();
        if (generator.nextInt() % 2 == 0) {
            p.put("com.ibm.websphere.naming.jndicache.cacheobject", "none");
            System.out.println("DO NOT use Naming Cache");
        } else {
            System.out.println("DO use Naming Cache");
        }
        InitialContext initial = new InitialContext(p);
        Object objref = initial.lookup("");
        if (loginType.equalsIgnoreCase("prompt")) {
            wscbh = new WSGUICallbackHandlerImpl();
        } else if (loginType.equalsIgnoreCase("stdin")) {
            wscbh = new WSStdinCallbackHandlerImpl(realm);
        } else if (loginType.equalsIgnoreCase("program")) {
            System.out.println("WSCallbackHandlerImpl(" + user + ", " + realm + ", " + password + ", <hashMap>)");
            wscbh = new WSCallbackHandlerImpl(user, realm, password, p);
        } else {
            throw new Exception("Login type " + loginType + " is not supported");
        }
        try {
            lc = new LoginContext(_loginType, (CallbackHandler)wscbh);
        }
        catch (LoginException le) {
            System.err.println("Failed to create LoginContext" + le.getMessage());
            le.printStackTrace();
            throw le;
        }
        catch (SecurityException se) {
            System.err.println("Failed to create LoginContext" + se.getMessage());
            se.printStackTrace();
            throw se;
        }
        catch (Exception ex) {
            System.err.println("Failed to create LoginContext" + ex.getMessage());
            ex.printStackTrace();
            throw ex;
        }
        try {
            lc.login();
        }
        catch (SecurityException se) {
            System.err.println("Failed to login");
            se.printStackTrace();
            throw se;
        }
        catch (Exception ex) {
            System.err.println("Failed logging in" + ex.getMessage());
            ex.printStackTrace();
            throw ex;
        }
        subject = lc.getSubject();
        System.out.println("Have subject " + subject);
        if (subject == null) {
            System.err.println("Failed to get the subject from LoginContext");
            return null;
        }
        WSCredential cred = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
        System.out.println("Have cred" + cred);
        if (cred == null) {
            System.err.println("Failed to get the cred from Subject");
            return null;
        }
        try {
            WSSubject.setRunAsSubject((Subject)subject);
            System.out.println("setRunAsSubject() done");
        }
        catch (Exception e) {
            System.err.println("Failed to set invocation credential");
            throw e;
        }
        return cred;
    }

    public static SecFVTS1 setup(String hostname, String bootstrap_port, String secFVTEJBName, boolean debug) {
        SecFVTS1Home home;
        Object objref;
        InitialContext initial;
        SecFVTS1 firstSecFVTS1;
        block19: {
            firstSecFVTS1 = null;
            initial = null;
            objref = null;
            home = null;
            try {
                Properties p = new Properties();
                p.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                String iiopString = "iiop://" + hostname + ":" + bootstrap_port;
                p.put("java.naming.provider.url", iiopString);
                initial = new InitialContext(p);
            }
            catch (Exception ex) {
                if (!debug) break block19;
                System.err.println("Caught an unexpected exception when initializing naming context!");
                ex.printStackTrace();
            }
        }
        if (initial != null) {
            try {
                objref = initial.lookup(secFVTEJBName);
            }
            catch (Exception ex) {
                if (debug) {
                    System.err.println("Caught an unexpected exception when lookup " + secFVTEJBName);
                    ex.printStackTrace();
                }
            }
        } else {
            System.err.println("Failed to create initial naming context!");
        }
        if (objref != null) {
            try {
                home = (SecFVTS1Home)PortableRemoteObject.narrow((Object)objref, SecFVTS1Home.class);
            }
            catch (Exception ex) {
                if (debug) {
                    System.err.println("Caught an unexpected exception when narrow SecFVTS1Home!");
                    ex.printStackTrace();
                }
            }
        } else if (debug) {
            System.err.println("Failed to lookup SecFVTS1EJB entry!");
        }
        if (home != null) {
            try {
                firstSecFVTS1 = home.create("SecFVTS1");
            }
            catch (Exception ex) {
                if (debug) {
                    System.err.println("Caught an unexpected exception when create SecFVTS1!");
                    ex.printStackTrace();
                }
            }
        } else if (debug) {
            System.err.println("Failed to obtain an SecFVTS1Home reference!");
        }
        return firstSecFVTS1;
    }

    public static SecFVTS1 setup2(String hostname, String bootstrap_port, String secFVTEJBName, boolean debug, Logger logger) {
        SecFVTS1Home home;
        Object objref;
        InitialContext initial;
        SecFVTS1 firstSecFVTS1;
        block19: {
            firstSecFVTS1 = null;
            initial = null;
            objref = null;
            home = null;
            try {
                Properties p = new Properties();
                p.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                String iiopString = "iiop://" + hostname + ":" + bootstrap_port;
                p.put("java.naming.provider.url", iiopString);
                initial = new InitialContext(p);
            }
            catch (Exception ex) {
                if (!debug) break block19;
                System.err.println("Caught an unexpected exception when initializing naming context!");
                ex.printStackTrace();
            }
        }
        if (initial != null) {
            try {
                objref = initial.lookup(secFVTEJBName);
            }
            catch (Exception ex) {
                if (debug) {
                    System.err.println("Caught an unexpected exception when lookup " + secFVTEJBName);
                    ex.printStackTrace();
                }
                ex.printStackTrace();
                String reason = ex.getMessage();
                String reason1 = reason.indexOf(AUTHORIZATION_FAILED) != -1 ? reason.substring(reason.indexOf(AUTHORIZATION_FAILED), reason.indexOf(AUTHORIZATION_FAILED) + AUTHORIZATION_FAILED.length()) : reason;
                String resultText = "For this negative testing scenario, check the actual exception\nwith the expected exception\nThe expected exception is \nNO_PERMISSION\nThe actual exception is\n" + reason1 + "\n" + "The full exception is\n" + ex;
                logger.createVariation(reason1.equals(AUTHORIZATION_FAILED), resultText);
                return firstSecFVTS1;
            }
        } else {
            System.err.println("Failed to create initial naming context!");
        }
        if (objref != null) {
            try {
                home = (SecFVTS1Home)PortableRemoteObject.narrow((Object)objref, SecFVTS1Home.class);
            }
            catch (Exception ex) {
                if (debug) {
                    System.err.println("Caught an unexpected exception when narrow SecFVTS1Home!");
                    ex.printStackTrace();
                }
            }
        } else if (debug) {
            System.err.println("Failed to lookup SecFVTS1EJB entry!");
        }
        if (home != null) {
            try {
                firstSecFVTS1 = home.create("SecFVTS1");
            }
            catch (Exception ex) {
                if (debug) {
                    System.err.println("Caught an unexpected exception when create SecFVTS1!");
                    ex.printStackTrace();
                }
            }
        } else if (debug) {
            System.err.println("Failed to obtain an SecFVTS1Home reference!");
        }
        return firstSecFVTS1;
    }

    public static JAASMapping setupJAC(String hostname, String bootstrap_port, String secFVTEJBName, boolean debug) {
        JAASMappingHome home;
        Object objref;
        InitialContext initial;
        JAASMapping firstSecFVTS1;
        block19: {
            firstSecFVTS1 = null;
            initial = null;
            objref = null;
            home = null;
            try {
                Properties p = new Properties();
                p.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                String iiopString = "iiop://" + hostname + ":" + bootstrap_port;
                p.put("java.naming.provider.url", iiopString);
                initial = new InitialContext(p);
            }
            catch (Exception ex) {
                if (!debug) break block19;
                System.err.println("Caught an unexpected exception when initializing naming context!");
                ex.printStackTrace();
            }
        }
        if (initial != null) {
            try {
                objref = initial.lookup(secFVTEJBName);
            }
            catch (Exception ex) {
                if (debug) {
                    System.err.println("Caught an unexpected exception when lookup " + secFVTEJBName);
                    ex.printStackTrace();
                }
            }
        } else {
            System.err.println("Failed to create initial naming context!");
        }
        if (objref != null) {
            try {
                home = (JAASMappingHome)PortableRemoteObject.narrow((Object)objref, JAASMappingHome.class);
            }
            catch (Exception ex) {
                if (debug) {
                    System.err.println("Caught an unexpected exception when narrow JAASMappingHome!");
                    ex.printStackTrace();
                }
            }
        } else if (debug) {
            System.err.println("Failed to lookup JAASMappingBean entry!");
        }
        if (home != null) {
            try {
                firstSecFVTS1 = home.create("JAASMapping");
            }
            catch (Exception ex) {
                if (debug) {
                    System.err.println("Caught an unexpected exception when create JAASMapping!");
                    ex.printStackTrace();
                }
            }
        } else if (debug) {
            System.err.println("Failed to obtain an JAASMappingHome reference!");
        }
        return firstSecFVTS1;
    }
}

