/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.attachment.external;

import java.io.InputStream;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.resource.ExtendedURIResolver;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.attachment.external.DomainExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Wsdl11XPointerDomainExpression
implements DomainExpression {
    private static final String NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    private static final String SERVICE_ELEM_NAME = "service";
    private static final String PORT_ELEM_NAME = "port";
    private static final String PORTTYPE_ELEM_NAME = "portType";
    private static final String BINDING_ELEM_NAME = "binding";
    private static final String OPERATION_ELEM_NAME = "operation";
    private static final String NAME_ATTR_NAME = "name";
    private String baseURI;
    private NodeList nodes;

    Wsdl11XPointerDomainExpression(String u) {
        this.baseURI = u;
    }

    public boolean appliesTo(BindingFaultInfo bfi) {
        throw new UnsupportedOperationException();
    }

    public boolean appliesTo(BindingMessageInfo bmi) {
        throw new UnsupportedOperationException();
    }

    public boolean appliesTo(BindingOperationInfo boi) {
        if (this.baseURI.equals(boi.getBinding().getDescription().getBaseURI())) {
            for (int i = 0; i < this.nodes.getLength(); ++i) {
                Node n = this.nodes.item(i);
                if (1 != n.getNodeType()) continue;
                Element e = (Element)n;
                if (this.matchesBindingOperation(e, boi)) {
                    Element p = (Element)e.getParentNode();
                    return this.matchesBinding(p, boi.getBinding());
                }
                if (!this.matchesOperation(e, boi.getOperationInfo())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean appliesTo(EndpointInfo ei) {
        if (this.baseURI.equals(ei.getDescription().getBaseURI())) {
            for (int i = 0; i < this.nodes.getLength(); ++i) {
                Node n = this.nodes.item(i);
                if (1 != n.getNodeType()) continue;
                Element e = (Element)n;
                if (this.matchesPort(e, ei)) {
                    Element p = (Element)e.getParentNode();
                    return this.matchesService(p, ei.getService());
                }
                if (this.matchesPortType(e, ei.getInterface())) {
                    return true;
                }
                if (!this.matchesBinding(e, ei.getBinding())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean appliesTo(ServiceInfo si) {
        if (this.baseURI.equals(si.getDescription().getBaseURI())) {
            for (int i = 0; i < this.nodes.getLength(); ++i) {
                Element e;
                Node n = this.nodes.item(i);
                if (1 != n.getNodeType() || !this.matchesService(e = (Element)n, si)) continue;
                return true;
            }
        }
        return false;
    }

    void evaluate(String uri) {
        int pos = uri.indexOf(35);
        String documentURI = uri.substring(0, pos);
        String path = uri.substring(pos + 1);
        InputSource is = new ExtendedURIResolver().resolve(documentURI, this.baseURI);
        if (null == is) {
            System.out.println("Failed to resolve: " + documentURI + " w.r.t baseURI: " + this.baseURI);
            return;
        }
        Document doc = null;
        try {
            doc = DOMUtils.readXml((InputStream)is.getByteStream());
        }
        catch (Exception ex) {
            throw new PolicyException(ex);
        }
        XPathUtils xu = new XPathUtils();
        this.nodes = (NodeList)xu.getValue(path, (Node)doc, XPathConstants.NODESET);
    }

    boolean matchesService(Element e, ServiceInfo si) {
        return NAMESPACE.equals(e.getNamespaceURI()) && SERVICE_ELEM_NAME.equals(e.getLocalName()) && si.getName().getLocalPart().equals(e.getAttribute(NAME_ATTR_NAME));
    }

    boolean matchesPortType(Element e, InterfaceInfo ii) {
        return NAMESPACE.equals(e.getNamespaceURI()) && PORTTYPE_ELEM_NAME.equals(e.getLocalName()) && ii.getName().getLocalPart().equals(e.getAttribute(NAME_ATTR_NAME));
    }

    boolean matchesPort(Element e, EndpointInfo ei) {
        return NAMESPACE.equals(e.getNamespaceURI()) && PORT_ELEM_NAME.equals(e.getLocalName()) && ei.getName().getLocalPart().equals(e.getAttribute(NAME_ATTR_NAME));
    }

    boolean matchesBinding(Element e, BindingInfo ei) {
        return NAMESPACE.equals(e.getNamespaceURI()) && BINDING_ELEM_NAME.equals(e.getLocalName()) && ei.getName().getLocalPart().equals(e.getAttribute(NAME_ATTR_NAME));
    }

    boolean matchesBindingOperation(Element e, BindingOperationInfo boi) {
        return NAMESPACE.equals(e.getNamespaceURI()) && OPERATION_ELEM_NAME.equals(e.getLocalName()) && boi.getName().getLocalPart().equals(e.getAttribute(NAME_ATTR_NAME));
    }

    boolean matchesOperation(Element e, OperationInfo boi) {
        return NAMESPACE.equals(e.getNamespaceURI()) && OPERATION_ELEM_NAME.equals(e.getLocalName()) && boi.getName().getLocalPart().equals(e.getAttribute(NAME_ATTR_NAME));
    }
}

