/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.InterfaceWithPriority;
import org.eclipse.microprofile.rest.client.tck.interfaces.InterfaceWithoutPriority;
import org.eclipse.microprofile.rest.client.tck.providers.InjectedSimpleFeature;
import org.eclipse.microprofile.rest.client.tck.providers.Prioritized2000MessageBodyReader;
import org.eclipse.microprofile.rest.client.tck.providers.UnprioritizedMessageBodyReader;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MultiRegisteredTest
extends WiremockArquillianTest {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(MultiRegisteredTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{InterfaceWithoutPriority.class, InterfaceWithPriority.class})).addClass(WiremockArquillianTest.class)).addPackage(InjectedSimpleFeature.class.getPackage());
    }

    @Test
    public void testOverrideProviderAnnotationOnBuilder() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(200).withBody("")));
        InterfaceWithoutPriority client = (InterfaceWithoutPriority)((RestClientBuilder)((RestClientBuilder)RestClientBuilder.newBuilder().register(UnprioritizedMessageBodyReader.class, 1000)).register(Prioritized2000MessageBodyReader.class, 500)).baseUrl(MultiRegisteredTest.getServerURL()).build(InterfaceWithoutPriority.class);
        String body = (String)client.get().readEntity(String.class);
        Assert.assertEquals((String)body, (String)"Prioritized 2000", (String)("The body returned should be the body from " + Prioritized2000MessageBodyReader.class));
    }

    @Test
    public void testOverrideInterfaceAndProviderAnnotationOnBuilder() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(200).withBody("")));
        InterfaceWithPriority client = (InterfaceWithPriority)((RestClientBuilder)((RestClientBuilder)RestClientBuilder.newBuilder().register(UnprioritizedMessageBodyReader.class, 1000)).register(Prioritized2000MessageBodyReader.class, 500)).baseUrl(MultiRegisteredTest.getServerURL()).build(InterfaceWithPriority.class);
        String body = (String)client.get().readEntity(String.class);
        Assert.assertEquals((String)body, (String)"Prioritized 2000", (String)("The body returned should be the body from " + Prioritized2000MessageBodyReader.class));
    }
}

