/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.subsystem;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureManifestException;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureResourceImpl;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.HeaderElementDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.apache.aries.util.manifest.ManifestProcessor;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions(traceGroups={"featureManager"}, traceGroup="", messageBundle="com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages", traceExceptionThrow=false, traceExceptionHandling=false)
public class FeatureDefinitionUtils {
    private static final TraceComponent tc = Tr.register(FeatureDefinitionUtils.class);
    static final String EMPTY = "";
    static final String SYMBOLIC_NAME = "Subsystem-SymbolicName";
    static final String TYPE = "Subsystem-Type";
    static final String VERSION = "Subsystem-Version";
    static final String CONTENT = "Subsystem-Content";
    static final String SHORT_NAME = "IBM-ShortName";
    static final String IBM_FEATURE_VERSION = "IBM-Feature-Version";
    static final String IBM_APP_FORCE_RESTART = "IBM-App-ForceRestart";
    public static final String IBM_API_SERVICE = "IBM-API-Service";
    public static final String IBM_API_PACKAGE = "IBM-API-Package";
    public static final String IBM_SPI_PACKAGE = "IBM-SPI-Package";
    public static final String IBM_PROVISION_CAPABILITY = "IBM-Provision-Capability";
    static final String FILTER_ATTR_NAME = "filter";
    static final String FILTER_FEATURE_KEY = "osgi.identity";
    static final String FILTER_TYPE_KEY = "type";
    static final List<String> LOCALIZABLE_HEADERS = Collections.unmodifiableList(Arrays.asList("Subsystem-Name", "Subsystem-Description"));
    public static final String NL = "\r\n";
    static final String SPLIT_CHAR = ";";
    static final Pattern splitPattern = Pattern.compile(";");
    static final long serialVersionUID = 6280355398392153809L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public FeatureDefinitionUtils() {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    static ImmutableAttributes loadAttributes(String repoType, File featureFile, ProvisioningDetails details) throws IOException {
        details.ensureValid();
        String symbolicName = details.getNameAttribute(null);
        int featureVersion = details.getIBMFeatureVersion();
        Visibility visibility = Visibility.fromString(details.getNameAttribute("visibility:"));
        String shortName = visibility != Visibility.PUBLIC ? null : details.getMainAttributeValue(SHORT_NAME);
        Version version = VersionUtility.stringToVersion(details.getMainAttributeValue(VERSION));
        AppForceRestart appRestart = AppForceRestart.fromString(details.getMainAttributeValue(IBM_APP_FORCE_RESTART));
        String subsystemType = details.getMainAttributeValue(TYPE);
        String value = details.getCachedRawHeader(IBM_PROVISION_CAPABILITY);
        boolean isAutoFeature = value != null && SubsystemContentType.FEATURE_TYPE.getValue().equals(subsystemType);
        value = details.getCachedRawHeader(IBM_API_SERVICE);
        boolean hasApiServices = value != null;
        value = details.getCachedRawHeader(IBM_API_PACKAGE);
        boolean hasApiPackages = value != null;
        value = details.getCachedRawHeader(IBM_SPI_PACKAGE);
        boolean hasSpiPackages = value != null;
        ImmutableAttributes iAttr = new ImmutableAttributes(FeatureDefinitionUtils.emptyIfNull(repoType), symbolicName, FeatureDefinitionUtils.nullIfEmpty(shortName), featureVersion, visibility, appRestart, version, featureFile, featureFile == null ? -1L : featureFile.lastModified(), featureFile == null ? -1L : featureFile.length(), isAutoFeature, hasApiServices, hasApiPackages, hasSpiPackages);
        details.setImmutableAttributes(iAttr);
        return iAttr;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    static ImmutableAttributes loadAttributes(String line, ImmutableAttributes cachedAttributes) {
        String[] parts;
        int index = line.indexOf(61);
        String key = line.substring(0, index);
        String repoType = EMPTY;
        String symbolicName = key;
        int pfxIndex = key.indexOf(58);
        if (pfxIndex > -1) {
            repoType = key.substring(0, pfxIndex);
            symbolicName = key.substring(pfxIndex + 1);
        }
        if ((parts = splitPattern.split(line.substring(index + 1))).length < 9) {
            return null;
        }
        String path = parts[0];
        File featureFile = new File(path);
        if (featureFile.exists()) {
            if (cachedAttributes != null) {
                return cachedAttributes;
            }
            long lastModified = FeatureDefinitionUtils.getLongValue(parts[1], -1L);
            long fileSize = FeatureDefinitionUtils.getLongValue(parts[2], -1L);
            String shortName = parts[3];
            int featureVersion = FeatureDefinitionUtils.getIntegerValue(parts[4], 2);
            Visibility visibility = Visibility.fromString(parts[5]);
            AppForceRestart appRestart = AppForceRestart.fromString(parts[6]);
            Version version = VersionUtility.stringToVersion(parts[7]);
            String flags = parts[8];
            boolean isAutoFeature = FeatureDefinitionUtils.toBoolean(flags.charAt(0));
            boolean hasApiServices = FeatureDefinitionUtils.toBoolean(flags.charAt(1));
            boolean hasApiPackages = FeatureDefinitionUtils.toBoolean(flags.charAt(2));
            boolean hasSpiPackages = FeatureDefinitionUtils.toBoolean(flags.charAt(3));
            return new ImmutableAttributes(FeatureDefinitionUtils.emptyIfNull(repoType), symbolicName, FeatureDefinitionUtils.nullIfEmpty(shortName), featureVersion, visibility, appRestart, version, featureFile, lastModified, fileSize, isAutoFeature, hasApiServices, hasApiPackages, hasSpiPackages);
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    static void writeAttributes(ImmutableAttributes iAttr, ProvisioningDetails details, PrintWriter writer) throws IOException {
        if (iAttr == null || details == null) {
            throw new NullPointerException("Both attributes and details are required for caching: attr=" + iAttr + ", details=" + details);
        }
        if (iAttr.bundleRepositoryType != null && !iAttr.bundleRepositoryType.isEmpty()) {
            writer.write(iAttr.bundleRepositoryType);
            writer.write(58);
        }
        writer.write(iAttr.symbolicName);
        writer.write(61);
        writer.write(iAttr.featureFile == null ? EMPTY : iAttr.featureFile.getAbsolutePath());
        writer.write(SPLIT_CHAR);
        writer.write(String.valueOf(iAttr.lastModified));
        writer.write(SPLIT_CHAR);
        writer.write(String.valueOf(iAttr.length));
        writer.write(SPLIT_CHAR);
        writer.write(iAttr.shortName == null ? EMPTY : iAttr.shortName);
        writer.write(SPLIT_CHAR);
        writer.write(String.valueOf(iAttr.featureVersion));
        writer.write(SPLIT_CHAR);
        writer.write(iAttr.visibility.toString());
        writer.write(SPLIT_CHAR);
        writer.write(iAttr.appRestart.toString());
        writer.write(SPLIT_CHAR);
        writer.write(iAttr.version.toString());
        writer.write(SPLIT_CHAR);
        FeatureDefinitionUtils.writeFlags(writer, iAttr.isAutoFeature, iAttr.hasApiServices, iAttr.hasApiPackages, iAttr.hasSpiPackages);
        writer.write(NL);
        if (iAttr.isAutoFeature) {
            writer.write("-C:");
            writer.write(details.getCachedRawHeader(IBM_PROVISION_CAPABILITY));
            writer.write(NL);
        }
        if (iAttr.hasApiServices) {
            writer.write("-V:");
            writer.write(details.getCachedRawHeader(IBM_API_SERVICE));
            writer.write(NL);
        }
        if (iAttr.hasApiPackages) {
            writer.write("-A:");
            writer.write(details.getCachedRawHeader(IBM_API_PACKAGE));
            writer.write(NL);
        }
        if (iAttr.hasSpiPackages) {
            writer.write("-S:");
            writer.write(details.getCachedRawHeader(IBM_SPI_PACKAGE));
            writer.write(NL);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    private static void writeFlags(PrintWriter writer, boolean ... flags) {
        boolean[] blArray = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            boolean flag = blArray[n2];
            writer.write(flag ? 49 : 48);
            ++n2;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    private static boolean toBoolean(char flag) {
        return flag == '1';
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    @FFDCIgnore(value={NumberFormatException.class})
    static long getLongValue(String value, long defaultValue) {
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    @FFDCIgnore(value={NumberFormatException.class})
    static int getIntegerValue(String value, int defaultValue) {
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public static String emptyIfNull(String str) {
        if (str == null) {
            return EMPTY;
        }
        return str;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public static String nullIfEmpty(String str) {
        if (str != null && str.isEmpty()) {
            return null;
        }
        return str;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    private static Manifest loadManifest(File mfFile, InputStream in) throws IOException {
        try {
            if (in == null) {
                in = new FileInputStream(mfFile);
            }
            Manifest manifest = ManifestProcessor.parseManifest(in);
            return manifest;
        }
        finally {
            FeatureDefinitionUtils.tryToClose(in);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    private static String getExtraLine(String name, String descr, char verify, BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null || line.charAt(0) != '-' || line.charAt(1) != verify || line.charAt(2) != ':') {
            throw new IOException("Missing or invalid cache entry for " + descr + " for " + name + ", line=" + line);
        }
        return line.substring(3);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    @FFDCIgnore(value={IOException.class})
    public static boolean tryToClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions(traceGroups={"featureManager"}, traceGroup="", messageBundle="com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages", traceExceptionThrow=false, traceExceptionHandling=false)
    static class ImmutableAttributes {
        final String bundleRepositoryType;
        final String featureName;
        final String symbolicName;
        final String shortName;
        final int featureVersion;
        final Visibility visibility;
        final AppForceRestart appRestart;
        final Version version;
        final boolean isAutoFeature;
        final boolean hasApiPackages;
        final boolean hasSpiPackages;
        final boolean hasApiServices;
        final File featureFile;
        final long lastModified;
        final long length;
        public File checksumFile;
        static final long serialVersionUID = -9151489660783753452L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        ImmutableAttributes(String repoType, String symbolicName, String shortName, int featureVersion, Visibility visibility, AppForceRestart appRestart, Version version, File featureFile, long lastModified, long fileSize, boolean isAutoFeature, boolean hasApiServices, boolean hasApiPackages, boolean hasSpiPackages) {
            this.bundleRepositoryType = repoType;
            this.symbolicName = symbolicName;
            this.shortName = shortName;
            this.featureName = this.buildFeatureName(repoType, symbolicName, shortName);
            this.featureVersion = featureVersion;
            this.visibility = visibility;
            this.appRestart = appRestart;
            this.version = version;
            this.isAutoFeature = isAutoFeature;
            this.hasApiServices = hasApiServices;
            this.hasApiPackages = hasApiPackages;
            this.hasSpiPackages = hasSpiPackages;
            this.featureFile = featureFile;
            if (featureFile != null) {
                this.checksumFile = new File(featureFile.getParentFile(), "checksums/" + symbolicName + ".cs");
            }
            this.lastModified = lastModified;
            this.length = fileSize;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        private String buildFeatureName(String repoType, String symbolicName, String shortName) {
            if (repoType == null || repoType.isEmpty()) {
                if (shortName != null) {
                    return shortName;
                }
                return symbolicName;
            }
            StringBuilder s = new StringBuilder();
            s.append(repoType).append(":");
            if (shortName != null) {
                s.append(shortName);
            } else {
                s.append(symbolicName);
            }
            return s.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        File getLocalizationDirectory() {
            if (this.featureFile == null) {
                return null;
            }
            return new File(this.featureFile.getParentFile(), "l10n");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            result = 31 * result + (this.shortName == null ? 0 : this.shortName.hashCode());
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImmutableAttributes other = (ImmutableAttributes)obj;
            if (this.symbolicName == null ? other.symbolicName != null : !this.symbolicName.equals(other.symbolicName)) {
                return false;
            }
            if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
                return false;
            }
            if (this.shortName == null ? other.shortName != null : !this.shortName.equals(other.shortName)) {
                return false;
            }
            return !(this.bundleRepositoryType == null ? other.bundleRepositoryType != null : !this.bundleRepositoryType.equals(other.bundleRepositoryType));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        public boolean isSupportedFeatureVersion() {
            return this.featureVersion == 0 || this.featureVersion == 2;
        }

        public String toString() {
            return String.valueOf(this.featureName == this.symbolicName ? FeatureDefinitionUtils.EMPTY : String.valueOf(this.featureName) + '/') + this.symbolicName + '/' + this.version;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ImmutableAttributes.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions(traceGroups={"featureManager"}, traceGroup="", messageBundle="com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages", traceExceptionThrow=false, traceExceptionHandling=false)
    static final class ProvisioningDetails {
        private Manifest manifest = null;
        private ImmutableAttributes iAttr = null;
        private final int featureVersion = Integer.MIN_VALUE;
        private String autoFeatureCapability = null;
        private String apiPackages = null;
        private String spiPackages = null;
        private String apiServices = null;
        private boolean supersededChecked = false;
        private String supersededBy = null;
        private Collection<FeatureResource> subsystemContent = null;
        private Collection<Filter> featureCapabilityFilters = null;
        private Map<String, Collection<HeaderElementDefinition>> headerElements = null;
        private String symbolicName = null;
        private Map<String, String> symNameAttributes = null;
        static final long serialVersionUID = 317329044861561828L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        ProvisioningDetails(File mfFile, InputStream inStream) throws IOException {
            this.manifest = FeatureDefinitionUtils.loadManifest(mfFile, inStream);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        ProvisioningDetails(BufferedReader reader, ImmutableAttributes iAttr) throws IOException {
            if (iAttr == null || reader == null) {
                throw new NullPointerException("Reader and Attributes must not be null: reader=" + reader + ", attr=" + iAttr);
            }
            this.iAttr = iAttr;
            if (iAttr.isAutoFeature) {
                this.autoFeatureCapability = FeatureDefinitionUtils.getExtraLine(iAttr.featureName, FeatureDefinitionUtils.IBM_PROVISION_CAPABILITY, 'C', reader);
            }
            if (iAttr.hasApiServices) {
                this.apiServices = FeatureDefinitionUtils.getExtraLine(iAttr.featureName, FeatureDefinitionUtils.IBM_API_SERVICE, 'V', reader);
            }
            if (iAttr.hasApiPackages) {
                this.apiPackages = FeatureDefinitionUtils.getExtraLine(iAttr.featureName, FeatureDefinitionUtils.IBM_API_PACKAGE, 'A', reader);
            }
            if (iAttr.hasSpiPackages) {
                this.spiPackages = FeatureDefinitionUtils.getExtraLine(iAttr.featureName, FeatureDefinitionUtils.IBM_SPI_PACKAGE, 'S', reader);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        private Manifest getManifest() throws IOException {
            Manifest mf = this.manifest;
            if (mf == null) {
                mf = this.manifest = FeatureDefinitionUtils.loadManifest(this.iAttr.featureFile, null);
            }
            return mf;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        private Map<String, Collection<HeaderElementDefinition>> getHeaderElementMap() {
            if (this.headerElements == null) {
                this.headerElements = new HashMap<String, Collection<HeaderElementDefinition>>();
            }
            return this.headerElements;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        String getMainAttributeValue(String key) throws IOException {
            return this.getManifest().getMainAttributes().getValue(key);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        String getNameAttribute(String key) throws IOException {
            Map<String, String> attr = this.symNameAttributes;
            if (attr == null) {
                String nameHeader = this.getMainAttributeValue(FeatureDefinitionUtils.SYMBOLIC_NAME);
                if (nameHeader == null) {
                    String fakeNLS = "The required {0} header was missing or empty";
                    String message = Tr.formatMessage(tc, "The required {0} header was missing or empty", FeatureDefinitionUtils.SYMBOLIC_NAME);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, message, new Object[0]);
                    }
                    throw new FeatureManifestException("Unable to read Subsystem-SymbolicName header from manifest", message);
                }
                ManifestHeaderProcessor.NameValuePair nvp = ManifestHeaderProcessor.parseBundleSymbolicName(nameHeader);
                this.symbolicName = nvp.getName();
                attr = this.symNameAttributes = nvp.getAttributes();
            }
            if (key == null) {
                return this.symbolicName;
            }
            if (attr != null) {
                return attr.get(key);
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        void setImmutableAttributes(ImmutableAttributes iAttr) {
            this.iAttr = iAttr;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        void ensureValid() throws IOException {
            String fakeNLS = "The {0} header in feature {1} was missing or specified an invalid value. value={2}";
            String symbolicName = this.getNameAttribute(null);
            int fVersion = this.getIBMFeatureVersion();
            if (fVersion > 2) {
                Tr.error(tc, "UNSUPPORTED_FEATURE_VERSION", symbolicName, fVersion);
                String message = Tr.formatMessage(tc, "UNSUPPORTED_FEATURE_VERSION", symbolicName, fVersion);
                throw new FeatureManifestException("Unsupported feature version", message);
            }
            String type = this.getMainAttributeValue(FeatureDefinitionUtils.TYPE);
            if (type == null || !SubsystemContentType.FEATURE_TYPE.getValue().equals(type)) {
                String message = Tr.formatMessage(tc, "The {0} header in feature {1} was missing or specified an invalid value. value={2}", FeatureDefinitionUtils.TYPE, symbolicName, type);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, message, new Object[0]);
                }
                throw new FeatureManifestException("Invalid value for Subsystem-Type manifest header: " + type, message);
            }
            String version = this.getMainAttributeValue(FeatureDefinitionUtils.VERSION);
            if (version == null) {
                String message = Tr.formatMessage(tc, "The {0} header in feature {1} was missing or specified an invalid value. value={2}", FeatureDefinitionUtils.VERSION, symbolicName, null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, message, new Object[0]);
                }
                throw new FeatureManifestException("Null value for Subsystem-Version manifest header", message);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        int getIBMFeatureVersion() throws IOException {
            int version = Integer.MIN_VALUE;
            if (version < 0) {
                version = FeatureDefinitionUtils.getIntegerValue(this.getMainAttributeValue(FeatureDefinitionUtils.IBM_FEATURE_VERSION), 0);
            }
            return version;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        String getCachedRawHeader(String header) {
            String result = null;
            try {
                if (FeatureDefinitionUtils.IBM_PROVISION_CAPABILITY.equals(header)) {
                    result = this.autoFeatureCapability;
                    if (result == null) {
                        result = this.autoFeatureCapability = this.getMainAttributeValue(FeatureDefinitionUtils.IBM_PROVISION_CAPABILITY);
                    }
                } else if (FeatureDefinitionUtils.IBM_API_SERVICE.equals(header)) {
                    result = this.apiServices;
                    if (result == null) {
                        result = this.apiServices = this.getMainAttributeValue(FeatureDefinitionUtils.IBM_API_SERVICE);
                    }
                } else if (FeatureDefinitionUtils.IBM_API_PACKAGE.equals(header)) {
                    result = this.apiPackages;
                    if (result == null) {
                        result = this.apiPackages = this.getMainAttributeValue(FeatureDefinitionUtils.IBM_API_PACKAGE);
                    }
                } else if (FeatureDefinitionUtils.IBM_SPI_PACKAGE.equals(header)) {
                    result = this.spiPackages;
                    if (result == null) {
                        result = this.spiPackages = this.getMainAttributeValue(FeatureDefinitionUtils.IBM_SPI_PACKAGE);
                    }
                } else {
                    result = this.getMainAttributeValue(header);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ProvisioningDetails", "725", this, new Object[]{header});
                IOException iOException2 = iOException;
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        Collection<Filter> getCapabilityFilters() {
            Collection<Filter> filters = this.featureCapabilityFilters;
            if (filters == null) {
                String capabilityHeader = this.getCachedRawHeader(FeatureDefinitionUtils.IBM_PROVISION_CAPABILITY);
                if (capabilityHeader != null) {
                    filters = new ArrayList<Filter>();
                    for (ManifestHeaderProcessor.GenericMetadata metadata : ManifestHeaderProcessor.parseCapabilityString(capabilityHeader)) {
                        String filterString = metadata.getDirectives().get(FeatureDefinitionUtils.FILTER_ATTR_NAME);
                        if (filterString == null) continue;
                        try {
                            Filter filter = FrameworkUtil.createFilter(filterString);
                            filters.add(filter);
                        }
                        catch (InvalidSyntaxException invalidSyntaxException) {
                            FFDCFilter.processException(invalidSyntaxException, "com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ProvisioningDetails", "752", this, new Object[0]);
                            InvalidSyntaxException ise = invalidSyntaxException;
                            Tr.warning(tc, "INVALID_PROVISION_CAPABILITY_FILTER", filterString, this.iAttr.symbolicName, ise.getMessage());
                        }
                    }
                    this.featureCapabilityFilters = filters;
                } else {
                    filters = this.featureCapabilityFilters = Collections.emptyList();
                }
            }
            return filters;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        Collection<FeatureResource> getConstituents(SubsystemContentType type) {
            Collection<FeatureResource> result = this.subsystemContent;
            if (result == null) {
                String contents = null;
                try {
                    contents = this.getMainAttributeValue(FeatureDefinitionUtils.CONTENT);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException(iOException, "com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ProvisioningDetails", "777", this, new Object[]{type});
                    IOException e = iOException;
                    return Collections.emptyList();
                }
                Map<String, Map<String, String>> data = ManifestHeaderProcessor.parseImportString(contents);
                result = new ArrayList<FeatureResource>(data.size());
                for (Map.Entry<String, Map<String, String>> entry : data.entrySet()) {
                    result.add(new FeatureResourceImpl(entry.getKey(), entry.getValue(), this.iAttr.bundleRepositoryType, this.iAttr.featureName));
                }
                this.subsystemContent = result;
            }
            if (type != null) {
                Collection<FeatureResource> unfiltered = result;
                result = new ArrayList<FeatureResource>();
                for (FeatureResource resource : unfiltered) {
                    if (!resource.isType(type)) continue;
                    result.add(resource);
                }
            }
            return Collections.unmodifiableCollection(result);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        Collection<HeaderElementDefinition> getRawHeaderElements(String header) {
            Collection<HeaderElementDefinition> elements = this.getHeaderElementMap().get(header);
            if (elements == null) {
                String contents = this.getCachedRawHeader(header);
                if (contents == null || contents.isEmpty()) {
                    return Collections.emptyList();
                }
                List<ManifestHeaderProcessor.NameValuePair> data = ManifestHeaderProcessor.parseExportString(contents);
                ListIterator<ManifestHeaderProcessor.NameValuePair> listIterator = data.listIterator();
                elements = new ArrayList<HeaderElementDefinition>(data.size());
                while (listIterator.hasNext()) {
                    ManifestHeaderProcessor.NameValuePair element = (ManifestHeaderProcessor.NameValuePair)listIterator.next();
                    elements.add(new FeatureResourceImpl(element.getName(), element.getAttributes(), this.iAttr.bundleRepositoryType, this.iAttr.featureName));
                }
                elements = Collections.unmodifiableCollection(elements);
                this.getHeaderElementMap().put(header, elements);
            }
            return elements;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        private void checkSuperseded() {
            if (this.supersededChecked) {
                return;
            }
            this.supersededChecked = true;
            try {
                String value = this.getNameAttribute("superseded-by");
                if (!Boolean.parseBoolean(this.getNameAttribute("superseded")) && value != null) {
                    Tr.error(tc, "SUPERSEDED_CONFIGURATION_ERROR", this.iAttr.featureName, value);
                } else {
                    this.supersededBy = value;
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ProvisioningDetails", "844", this, new Object[0]);
                IOException iOException2 = iOException;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        boolean isSuperseded() {
            this.checkSuperseded();
            return this.supersededBy != null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        String getSupersededBy() {
            this.checkSuperseded();
            return this.supersededBy;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        public void setHeaderValue(String header, String value) {
            try {
                this.getManifest().getMainAttributes().putValue(header, value);
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils$ProvisioningDetails", "862", this, new Object[]{header, value});
                IOException iOException2 = iOException;
            }
        }

        public String toString() {
            return String.valueOf(this.iAttr == null ? "noAttr" : this.iAttr.toString()) + "(loaded" + (this.manifest == null ? FeatureDefinitionUtils.EMPTY : "+") + (this.headerElements == null ? FeatureDefinitionUtils.EMPTY : "%") + ")";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ProvisioningDetails.class);
        }
    }
}

