/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import com.ibm.ejs.ras.TrLevelConstants;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceStateChangeListener;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.kernel.provisioning.packages.PackageIndex;
import com.ibm.ws.logging.internal.TraceSpecification;
import com.ibm.ws.logging.internal.WsLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TraceComponent
implements FFDCSelfIntrospectable {
    private final String name;
    private final Class<?> aClass;
    private final List<String> groups = new ArrayList<String>();
    protected int specTraceLevel = 16;
    private int fineLevel = 11;
    private String bundle;
    private volatile Logger logger = null;
    private boolean isDumpEnabled = false;
    private boolean isDebugEnabled = false;
    private boolean isEntryEnabled = false;
    private boolean isEventEnabled = false;
    private boolean isDetailEnabled = false;
    private boolean isConfigEnabled = false;
    private boolean isInfoEnabled = false;
    private boolean isAuditEnabled = false;
    private boolean isWarningEnabled = false;
    private boolean isErrorEnabled = false;
    private boolean isFatalEnabled = false;
    private boolean isServiceEnabled = false;
    private static boolean fineTraceEnabled = false;
    private TraceStateChangeListener trStateChangeListener = null;

    static void setAnyTracingEnabled(boolean useFineTrace) {
        fineTraceEnabled = useFineTrace;
    }

    public static boolean isAnyTracingEnabled() {
        return fineTraceEnabled;
    }

    protected TraceComponent(Class<?> aClass) {
        this((String)null, aClass, (String)null, (String)null);
    }

    protected TraceComponent(String name) {
        this(name, (Class<?>)null, (String)null, (String)null);
    }

    protected TraceComponent(String name, Class<?> aClass) {
        this(name, aClass, (String)null, (String)null);
    }

    protected TraceComponent(String name, Class<?> aClass, String group, String bundle) {
        if (name == null) {
            if (aClass == null) {
                throw new NullPointerException("Must declare a trace component with either a name, a class, or both");
            }
            name = aClass.getCanonicalName();
        }
        this.name = name;
        this.aClass = aClass;
        if (group != null) {
            this.groups.add(group);
        }
        this.bundle = bundle;
    }

    protected TraceComponent(String name, Class<?> aClass, String[] groups, String bundle) {
        if (name == null) {
            if (aClass == null) {
                throw new NullPointerException("Must declare a trace component with either a name, a class, or both");
            }
            name = aClass.getCanonicalName();
        }
        this.name = name;
        this.aClass = aClass;
        if (groups != null) {
            String[] stringArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                if (group != null && !this.groups.contains(group)) {
                    this.groups.add(group);
                }
                ++n2;
            }
        }
        this.bundle = bundle;
    }

    public Class<?> getTraceClass() {
        return this.aClass;
    }

    public synchronized Logger getLogger() {
        if (this.logger == null) {
            WsLogger.loggerRegistrationComponent.set(this);
            try {
                this.logger = Logger.getLogger(this.name, this.bundle);
                this.logger.setLevel(this.getLoggerLevel());
            }
            finally {
                WsLogger.loggerRegistrationComponent.set(null);
            }
        }
        return this.logger;
    }

    @Deprecated
    protected void setTraceSpec(String s) {
        if (s != null) {
            TraceSpecification ts = new TraceSpecification(s, null, false);
            this.setTraceSpec(ts);
        }
    }

    final synchronized void setTraceSpec(TraceSpecification ts) {
        if (ts != null) {
            this.isDumpEnabled = false;
            this.isDebugEnabled = false;
            this.isEntryEnabled = false;
            this.isEventEnabled = false;
            this.isDetailEnabled = false;
            this.isConfigEnabled = false;
            this.isInfoEnabled = false;
            this.isAuditEnabled = false;
            this.isWarningEnabled = false;
            this.isErrorEnabled = false;
            this.isFatalEnabled = false;
            this.isServiceEnabled = false;
            this.specTraceLevel = 16;
            this.traceSpec(ts);
            if (this.trStateChangeListener != null) {
                this.trStateChangeListener.traceStateChanged();
            }
            if (this.logger != null) {
                this.logger.setLevel(this.getLoggerLevel());
            }
            TrConfigurator.traceComponentUpdated(this);
        }
    }

    public final boolean isDumpEnabled() {
        return this.isDumpEnabled;
    }

    final void setResourceBundleName(String name) {
        this.bundle = name;
    }

    public final String getResourceBundleName() {
        String rb = this.bundle;
        if (rb == null && this.logger != null) {
            rb = this.logger.getResourceBundleName();
        }
        return rb;
    }

    public final synchronized void setLoggerForCallback(TraceStateChangeListener listener) {
        this.trStateChangeListener = listener;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public final boolean isEntryEnabled() {
        return this.isEntryEnabled;
    }

    public final boolean isEventEnabled() {
        return this.isEventEnabled;
    }

    public final boolean isDetailEnabled() {
        return this.isDetailEnabled;
    }

    public final boolean isConfigEnabled() {
        return this.isConfigEnabled;
    }

    public final boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    public final boolean isAuditEnabled() {
        return this.isAuditEnabled;
    }

    public final boolean isWarningEnabled() {
        return this.isWarningEnabled;
    }

    public final boolean isErrorEnabled() {
        return this.isErrorEnabled;
    }

    public final boolean isFatalEnabled() {
        return this.isFatalEnabled;
    }

    public final boolean isServiceEnabled() {
        return this.isServiceEnabled;
    }

    private void traceSpec(TraceSpecification ts) {
        List traceSpecs = ts.getSpecs();
        Integer minimumLevel = null;
        if (ts.isSensitiveTraceSuppressed()) {
            minimumLevel = this.findMinimumSafeLevel((PackageIndex<Integer>)ts.getSafeLevelsIndex());
        }
        for (TraceSpecification.TraceElement spec : traceSpecs) {
            String clazz = spec.groupName;
            int traceElementFineLevel = spec.fineLevel;
            int specTraceLevel = spec.specTraceLevel;
            boolean setValue = spec.action;
            boolean process = false;
            if (clazz.endsWith("*")) {
                if (1 == clazz.length()) {
                    process = true;
                } else {
                    clazz = clazz.substring(0, clazz.length() - 1);
                    for (String group : this.groups) {
                        if (!group.startsWith(clazz)) continue;
                        process = true;
                        break;
                    }
                    process = process || this.name.startsWith(clazz);
                }
            } else {
                String packageName;
                int lastDot = this.name.lastIndexOf(46);
                if (lastDot > 0 && (packageName = this.name.substring(0, lastDot)).startsWith(clazz)) {
                    process = true;
                }
                for (String group : this.groups) {
                    lastDot = group.lastIndexOf(46);
                    if (lastDot <= 0) continue;
                    String packageName2 = group.substring(0, lastDot);
                    if (!packageName2.startsWith(clazz)) break;
                    process = true;
                    break;
                }
                for (String group : this.groups) {
                    if (!group.equalsIgnoreCase(clazz)) continue;
                    process = true;
                    break;
                }
                boolean bl = process = process || this.name.equalsIgnoreCase(clazz);
            }
            if (!process) continue;
            this.fineLevel = traceElementFineLevel;
            this.specTraceLevel = specTraceLevel;
            this.recalculateLevelsIfSensitive(minimumLevel);
            this.isDumpEnabled = this.fineLevel <= 0 ? setValue : this.isDumpEnabled;
            this.isDebugEnabled = this.fineLevel <= 1 ? setValue : this.isDebugEnabled;
            this.isEntryEnabled = this.fineLevel <= 2 ? setValue : this.isEntryEnabled;
            this.isEventEnabled = this.fineLevel <= 3 ? setValue : this.isEventEnabled;
            this.isDetailEnabled = this.fineLevel <= 4 ? setValue : this.isDetailEnabled;
            this.isConfigEnabled = this.fineLevel <= 5 ? setValue : this.isConfigEnabled;
            this.isInfoEnabled = this.fineLevel <= 6 ? setValue : this.isInfoEnabled;
            this.isAuditEnabled = this.fineLevel <= 7 ? setValue : this.isAuditEnabled;
            this.isServiceEnabled = this.fineLevel <= 7 ? setValue : this.isServiceEnabled;
            this.isWarningEnabled = this.fineLevel <= 8 ? setValue : this.isWarningEnabled;
            this.isErrorEnabled = this.fineLevel <= 9 ? setValue : this.isErrorEnabled;
            this.isFatalEnabled = this.fineLevel <= 10 ? setValue : this.isFatalEnabled;
            spec.setMatched(true);
        }
    }

    private void recalculateLevelsIfSensitive(Integer minimumLevel) {
        if (minimumLevel != null && this.fineLevel < minimumLevel) {
            this.fineLevel = minimumLevel;
        }
    }

    private Integer findMinimumSafeLevel(PackageIndex<Integer> index) {
        if (index == null) {
            return null;
        }
        Integer minimumLevel = (Integer)index.find(this.name);
        if (minimumLevel == null) {
            for (String group : this.groups) {
                minimumLevel = (Integer)index.find(group);
                if (minimumLevel != null) break;
            }
        }
        return minimumLevel;
    }

    public final Level getLoggerLevel() {
        if (this.fineLevel < TrLevelConstants.levels.length) {
            return TrLevelConstants.levels[this.fineLevel];
        }
        return Level.OFF;
    }

    @Override
    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.name + "," + this.aClass + "," + this.groups + "," + this.bundle + "," + this.logger + "]";
    }
}

