/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.impl.io;

import wiremock.org.apache.http.HttpRequest;
import wiremock.org.apache.http.HttpRequestFactory;
import wiremock.org.apache.http.annotation.Contract;
import wiremock.org.apache.http.annotation.ThreadingBehavior;
import wiremock.org.apache.http.config.MessageConstraints;
import wiremock.org.apache.http.impl.DefaultHttpRequestFactory;
import wiremock.org.apache.http.impl.io.DefaultHttpRequestParser;
import wiremock.org.apache.http.io.HttpMessageParser;
import wiremock.org.apache.http.io.HttpMessageParserFactory;
import wiremock.org.apache.http.io.SessionInputBuffer;
import wiremock.org.apache.http.message.BasicLineParser;
import wiremock.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

