/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Wrapper;
import java.util.regex.Pattern;

public interface Statement
extends Wrapper,
AutoCloseable {
    public static final int CLOSE_CURRENT_RESULT = 1;
    public static final int KEEP_CURRENT_RESULT = 2;
    public static final int CLOSE_ALL_RESULTS = 3;
    public static final int SUCCESS_NO_INFO = -2;
    public static final int EXECUTE_FAILED = -3;
    public static final int RETURN_GENERATED_KEYS = 1;
    public static final int NO_GENERATED_KEYS = 2;

    public ResultSet executeQuery(String var1) throws SQLException;

    public int executeUpdate(String var1) throws SQLException;

    @Override
    public void close() throws SQLException;

    public int getMaxFieldSize() throws SQLException;

    public void setMaxFieldSize(int var1) throws SQLException;

    public int getMaxRows() throws SQLException;

    public void setMaxRows(int var1) throws SQLException;

    public void setEscapeProcessing(boolean var1) throws SQLException;

    public int getQueryTimeout() throws SQLException;

    public void setQueryTimeout(int var1) throws SQLException;

    public void cancel() throws SQLException;

    public SQLWarning getWarnings() throws SQLException;

    public void clearWarnings() throws SQLException;

    public void setCursorName(String var1) throws SQLException;

    public boolean execute(String var1) throws SQLException;

    public ResultSet getResultSet() throws SQLException;

    public int getUpdateCount() throws SQLException;

    public boolean getMoreResults() throws SQLException;

    public void setFetchDirection(int var1) throws SQLException;

    public int getFetchDirection() throws SQLException;

    public void setFetchSize(int var1) throws SQLException;

    public int getFetchSize() throws SQLException;

    public int getResultSetConcurrency() throws SQLException;

    public int getResultSetType() throws SQLException;

    public void addBatch(String var1) throws SQLException;

    public void clearBatch() throws SQLException;

    public int[] executeBatch() throws SQLException;

    public Connection getConnection() throws SQLException;

    public boolean getMoreResults(int var1) throws SQLException;

    public ResultSet getGeneratedKeys() throws SQLException;

    public int executeUpdate(String var1, int var2) throws SQLException;

    public int executeUpdate(String var1, int[] var2) throws SQLException;

    public int executeUpdate(String var1, String[] var2) throws SQLException;

    public boolean execute(String var1, int var2) throws SQLException;

    public boolean execute(String var1, int[] var2) throws SQLException;

    public boolean execute(String var1, String[] var2) throws SQLException;

    public int getResultSetHoldability() throws SQLException;

    public boolean isClosed() throws SQLException;

    public void setPoolable(boolean var1) throws SQLException;

    public boolean isPoolable() throws SQLException;

    public void closeOnCompletion() throws SQLException;

    public boolean isCloseOnCompletion() throws SQLException;

    default public long getLargeUpdateCount() throws SQLException {
        throw new UnsupportedOperationException("getLargeUpdateCount not implemented");
    }

    default public void setLargeMaxRows(long max) throws SQLException {
        throw new UnsupportedOperationException("setLargeMaxRows not implemented");
    }

    default public long getLargeMaxRows() throws SQLException {
        return 0L;
    }

    default public long[] executeLargeBatch() throws SQLException {
        throw new UnsupportedOperationException("executeLargeBatch not implemented");
    }

    default public long executeLargeUpdate(String sql) throws SQLException {
        throw new UnsupportedOperationException("executeLargeUpdate not implemented");
    }

    default public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("executeLargeUpdate not implemented");
    }

    default public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("executeLargeUpdate not implemented");
    }

    default public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("executeLargeUpdate not implemented");
    }

    default public String enquoteLiteral(String val) throws SQLException {
        return "'" + val.replace("'", "''") + "'";
    }

    default public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        int len = identifier.length();
        if (len < 1 || len > 128) {
            throw new SQLException("Invalid name");
        }
        if (Pattern.compile("[\\p{Alpha}][\\p{Alnum}_]*").matcher(identifier).matches()) {
            return alwaysQuote ? "\"" + identifier + "\"" : identifier;
        }
        if (identifier.matches("^\".+\"$")) {
            identifier = identifier.substring(1, len - 1);
        }
        if (Pattern.compile("[^\u0000\"]+").matcher(identifier).matches()) {
            return "\"" + identifier + "\"";
        }
        throw new SQLException("Invalid name");
    }

    default public boolean isSimpleIdentifier(String identifier) throws SQLException {
        int len = identifier.length();
        return len >= 1 && len <= 128 && Pattern.compile("[\\p{Alpha}][\\p{Alnum}_]*").matcher(identifier).matches();
    }

    default public String enquoteNCharLiteral(String val) throws SQLException {
        return "N'" + val.replace("'", "''") + "'";
    }
}

