/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.interrogator;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.zip.ZipFile;
import org.jboss.windup.interrogator.impl.DecoratorPipeline;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.metadata.type.archive.ZipMetadata;
import org.jboss.windup.util.RecursiveZipMetaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipInterrogationEngine {
    private static final Logger LOG = LoggerFactory.getLogger(ZipInterrogationEngine.class);
    protected RecursiveZipMetaFactory recursiveExtractor;
    protected DecoratorPipeline<ZipMetadata> decoratorPipeline;

    public void setDecoratorPipeline(DecoratorPipeline<ZipMetadata> decoratorPipeline) {
        this.decoratorPipeline = decoratorPipeline;
    }

    public void setRecursiveExtractor(RecursiveZipMetaFactory recursiveExtractor) {
        this.recursiveExtractor = recursiveExtractor;
    }

    public ZipMetadata process(File outputDirectory, File targetArchive) {
        ZipMetadata archiveMeta;
        LOG.info("Processing: " + targetArchive.getName());
        try {
            ZipFile zf = new ZipFile(targetArchive);
            archiveMeta = this.recursiveExtractor.recursivelyExtract(zf);
        }
        catch (Exception e) {
            LOG.error("Error unzipping file: " + targetArchive.getPath(), (Throwable)e);
            return null;
        }
        LinkedList<ZipMetadata> archiveMetas = new LinkedList<ZipMetadata>();
        this.unfoldRecursion(archiveMeta, archiveMetas);
        int i = 1;
        int j = archiveMetas.size();
        for (ZipMetadata archive : archiveMetas) {
            LOG.info("Interrogating (" + i + " of " + j + "): " + archive.getRelativePath());
            File archiveOutputDirectory = new File(outputDirectory + File.separator + archive.getRelativePath());
            archive.setArchiveOutputDirectory(archiveOutputDirectory);
            this.decoratorPipeline.processMeta(archive);
            ++i;
        }
        this.recursiveExtractor.releaseTempFiles();
        return archiveMeta;
    }

    protected void unfoldRecursion(ZipMetadata base, Collection<ZipMetadata> archiveMetas) {
        for (ArchiveMetadata meta : base.getNestedArchives()) {
            ZipMetadata zipMeta = (ZipMetadata)meta;
            this.unfoldRecursion(zipMeta, archiveMetas);
        }
        archiveMetas.add(base);
    }
}

