/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.java;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.jboss.windup.decorator.ChainingDecorator;
import org.jboss.windup.decorator.java.JavaASTVariableResolvingVisitor;
import org.jboss.windup.metadata.type.JavaMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaASTDecorator
extends ChainingDecorator<JavaMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaASTDecorator.class);
    protected Set<String> javaLangDependencies;

    public void setJavaLangDependencies(Set<String> javaLangDependencies) {
        this.javaLangDependencies = javaLangDependencies;
    }

    @Override
    public void processMeta(JavaMetadata meta) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setBindingsRecovery(true);
        parser.setResolveBindings(true);
        try {
            parser.setSource(FileUtils.readFileToString((File)meta.getFilePointer()).toCharArray());
        }
        catch (IOException e) {
            LOG.error("Exception setting source for parser.", (Throwable)e);
            return;
        }
        parser.setKind(8);
        HashSet<String> allDependencies = new HashSet<String>(meta.getClassDependencies().size());
        allDependencies.addAll(this.javaLangDependencies);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        cu.accept((ASTVisitor)new JavaASTVariableResolvingVisitor(cu, meta.getDecorations(), meta.getQualifiedClassName(), allDependencies, meta.getBlackListedDependencies()));
        for (Object o : cu.types()) {
            TypeDeclaration td = (TypeDeclaration)o;
            String pkg = cu.getPackage() != null ? cu.getPackage().getName() + "." : "";
            String qualifiedTemp = pkg + td.getName().toString();
            if (!StringUtils.equals((String)qualifiedTemp, (String)meta.getQualifiedClassName())) {
                LOG.warn(qualifiedTemp + " did not match " + meta.getQualifiedClassName());
                continue;
            }
            LOG.debug("Matched: " + qualifiedTemp);
            meta.setInterfaceClz(td.isInterface());
            for (Object m : td.modifiers()) {
                if (!(m instanceof Modifier)) {
                    LOG.debug("Instance: " + ReflectionToStringBuilder.toString(m));
                    continue;
                }
                Modifier mod = (Modifier)m;
                if (StringUtils.equals((String)"public", (String)mod.getKeyword().toString())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Setting class: " + qualifiedTemp + " as public.");
                    }
                    meta.setPublicClz(true);
                }
                if (!StringUtils.equals((String)"abstract", (String)mod.getKeyword().toString())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting class: " + qualifiedTemp + " as abstract.");
                }
                meta.setAbstractClz(true);
            }
        }
        super.chainDecorators(meta);
    }
}

