/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.gate;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.gate.GateDecorator;
import org.jboss.windup.metadata.type.FileMetadata;

public class RegexFileGateDecorator
extends GateDecorator<FileMetadata> {
    protected Pattern regexPattern;
    protected boolean fullPath;

    public void setRegexPattern(Pattern regexPattern) {
        this.regexPattern = regexPattern;
    }

    public void setFullPath(boolean fullPath) {
        this.fullPath = fullPath;
    }

    @Override
    protected boolean continueProcessing(FileMetadata meta) {
        String fileNameText = null;
        if (this.fullPath) {
            fileNameText = meta.getFilePointer().getAbsolutePath();
            fileNameText = StringUtils.replace((String)fileNameText, (String)"\\", (String)"/");
        } else {
            fileNameText = meta.getFilePointer().getName();
        }
        return this.regexPattern.matcher(fileNameText).find();
    }
}

