/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.archive;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.metadata.decoration.archetype.JVMBuildVersionResult;
import org.jboss.windup.metadata.type.archive.ZipMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMVersionDecorator
implements MetaDecorator<ZipMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(JVMVersionDecorator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMeta(ZipMetadata meta) {
        try {
            Enumeration<? extends ZipEntry> e = meta.getZipFile().entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!StringUtils.endsWith((String)entry.getName(), (String)".class")) continue;
                String version = null;
                try (FilterInputStream in = null;){
                    in = new DataInputStream(meta.getZipFile().getInputStream(entry));
                    ((DataInputStream)in).readInt();
                    int minor = ((DataInputStream)in).readUnsignedShort();
                    int major = ((DataInputStream)in).readUnsignedShort();
                    switch (major) {
                        case 45: {
                            version = "1.1";
                            break;
                        }
                        case 46: {
                            version = "1.2";
                            break;
                        }
                        case 47: {
                            version = "1.3";
                            break;
                        }
                        case 48: {
                            version = "1.4";
                            break;
                        }
                        case 49: {
                            version = "5.0";
                            break;
                        }
                        case 50: {
                            version = "6.0";
                            break;
                        }
                        case 51: {
                            version = "7.0";
                            break;
                        }
                        default: {
                            LOG.warn("No version mapping for: " + version);
                        }
                    }
                    version = version + "." + minor;
                }
                JVMBuildVersionResult vr = new JVMBuildVersionResult();
                vr.setJdkBuildVersion(version);
                meta.getDecorations().add(vr);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Built with: " + version);
                }
                break;
            }
        }
        catch (Exception e) {
            LOG.error("Exception getting JDK version.", (Throwable)e);
        }
    }
}

