/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.jboss.windup.decorator.ChainingDecorator;
import org.jboss.windup.metadata.decoration.Line;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.util.NewLineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexDecorator
extends ChainingDecorator<FileMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(RegexDecorator.class);
    protected Pattern regexPattern;

    public void setRegexPattern(Pattern regexPattern) {
        this.regexPattern = regexPattern;
    }

    @Override
    public void processMeta(FileMetadata meta) {
        try {
            String contents = FileUtils.readFileToString((File)meta.getFilePointer());
            Matcher matcher = this.regexPattern.matcher(contents);
            while (matcher.find()) {
                String matched = matcher.group(1);
                Line lr = new Line();
                lr.setDescription("Blacklist Namespace: " + matched);
                lr.setLineNumber(Integer.valueOf(NewLineUtil.countNewLine(contents, matcher.start())));
                lr.setPattern(matched);
                meta.getDecorations().add(lr);
            }
        }
        catch (IOException e) {
            LOG.error("Exception reading content for: " + meta.getFilePointer().getAbsolutePath(), (Throwable)e);
        }
    }
}

