/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.jboss.windup.decorator.ChainingDecorator;
import org.jboss.windup.metadata.decoration.Hash;
import org.jboss.windup.metadata.type.FileMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5HashDecorator
extends ChainingDecorator<FileMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(MD5HashDecorator.class);

    @Override
    public void processMeta(FileMetadata meta) {
        try {
            FileInputStream fis = new FileInputStream(meta.getFilePointer());
            String md5 = DigestUtils.md5Hex((InputStream)fis);
            Hash result = new Hash();
            result.setHashType(Hash.HashType.MD5);
            result.setHash(md5);
            meta.getDecorations().add(result);
            if (LOG.isDebugEnabled()) {
                LOG.debug("File: " + meta.getFilePointer().getAbsolutePath() + " : MD5: " + md5);
            }
            this.chainDecorators(meta);
        }
        catch (Exception e) {
            LOG.error("Exception generating MD5.", (Throwable)e);
        }
    }
}

