/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class NumericFieldsConfiguration {
    private static final Log LOG = LoggerFactory.make();
    private final Class<?> indexedType;
    private final XProperty member;
    private final Map<String, NumericField> fieldsMarkedAsNumeric;
    private final Set<String> fieldsOfProperty = new HashSet<String>();

    NumericFieldsConfiguration(Class<?> indexedType, XProperty member, Map<String, NumericField> fieldsMarkedAsNumeric) {
        this.indexedType = indexedType;
        this.member = member;
        this.fieldsMarkedAsNumeric = fieldsMarkedAsNumeric;
    }

    NumericField getNumericFieldAnnotation(String unprefixedFieldName) {
        this.fieldsOfProperty.add(unprefixedFieldName);
        NumericField numericFieldAnnotation = this.fieldsMarkedAsNumeric.get(unprefixedFieldName);
        if (numericFieldAnnotation == null) {
            numericFieldAnnotation = this.fieldsMarkedAsNumeric.get("");
        }
        return numericFieldAnnotation;
    }

    boolean isNumericField(String unprefixedFieldName) {
        return this.getNumericFieldAnnotation(unprefixedFieldName) != null;
    }

    void validate() {
        for (String fieldMarkedAsNumeric : this.fieldsMarkedAsNumeric.keySet()) {
            if (this.fieldsOfProperty.contains(fieldMarkedAsNumeric) || fieldMarkedAsNumeric.isEmpty() && !this.fieldsOfProperty.isEmpty()) continue;
            throw LOG.numericFieldAnnotationWithoutMatchingField(this.indexedType, this.member.getName());
        }
    }
}

