/*******************************************************************************
 * Copyright (c) 2018 Red Hat, Inc.
 * Distributed under license by Red Hat, Inc. All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 ******************************************************************************/
package org.jboss.tools.windup.ui.internal.explorer;

/**
 * Constants associated with Issues.
 */
public interface IssueConstants {
	
	public static enum Severity {
		MANDATORY, POTENTIAL, OPTIONAL
	}
	
	String ISSUE_ID = "WINDUP_ISSUE_ID";
	String ELEMENT_ID = "ELEMENT_ID";
	
	/**
	 * Preview Quick Fix
	 */
	int OK = 1;
	int APPLY_FIX = 2;
	
	/**
	 * Explorer Content
	 */
	String GROUP_BY_FILE_CMD = "org.jboss.tools.windup.ui.groupByFile";
	String TOGGLE_STATE_ID = "org.eclipse.ui.commands.toggleState";
	String JDT_CONTENT = "org.eclipse.jdt.java.ui.javaContent";
}
