/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.metadata.type.archive.DirectoryMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveDirectoryMetaFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RecursiveDirectoryMetaFactory.class);
    private final File start;

    public RecursiveDirectoryMetaFactory(File dir) {
        this.start = dir;
    }

    public DirectoryMetadata recursivelyExtract() {
        DirectoryMetadata dirMeta = new DirectoryMetadata();
        dirMeta.setFilePointer(this.start);
        dirMeta.setName(this.start.getName());
        dirMeta.setRelativePath("windup");
        this.populateChildren(dirMeta);
        return dirMeta;
    }

    protected void populateChildren(DirectoryMetadata parent) {
        File[] files = parent.getFilePointer().listFiles();
        if (LOG.isDebugEnabled()) {
            LOG.debug(files.length + " Children of " + parent.getFilePointer().getAbsolutePath());
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            if (file.isHidden()) {
                LOG.debug("Skipping hidden directory: " + file.getAbsolutePath());
                continue;
            }
            DirectoryMetadata dirMeta = new DirectoryMetadata();
            parent.getNestedArchives().add(dirMeta);
            dirMeta.setArchiveMeta((ArchiveMetadata)parent);
            dirMeta.setFilePointer(file);
            dirMeta.setRelativePath(this.generateRelativePath(file));
            dirMeta.setName(file.getName());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Added child: " + dirMeta.getRelativePath());
            }
            this.populateChildren(dirMeta);
        }
    }

    protected String generateRelativePath(File dir) {
        String absPath = this.start.getParentFile().getAbsolutePath();
        String relative = StringUtils.removeStart((String)dir.getAbsolutePath(), (String)absPath);
        relative = StringUtils.replace((String)relative, (String)"\\", (String)"/");
        return relative;
    }
}

