/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.interrogator.impl;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.interrogator.Interrogator;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.ZipEntryMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtensionInterrogator<T extends FileMetadata>
extends Interrogator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionInterrogator.class);
    protected Set<Pattern> extensions;

    public void setExtensions(Set<String> extensions) {
        this.extensions = this.compilePatternSet(extensions);
    }

    @Override
    public void processMeta(T fileMeta) {
        File file = fileMeta.getFilePointer();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing Extension: " + file.getAbsolutePath());
        }
        this.decoratorPipeline.processMeta(fileMeta);
        if (this.isOfInterest(fileMeta)) {
            fileMeta.getArchiveMeta().getEntries().add(fileMeta);
        }
    }

    @Override
    public void processArchiveEntry(ZipEntryMetadata archiveEntry) {
        FileMetadata meta;
        String entryName = archiveEntry.getZipEntry().getName();
        if (this.matchesExtension(entryName) && (meta = (FileMetadata)this.archiveEntryToMeta(archiveEntry)) != null) {
            this.processMeta(meta);
            return;
        }
    }

    @Override
    public void processFile(FileMetadata entry) {
        FileMetadata meta;
        String path = StringUtils.replace((String)entry.getFilePointer().getAbsolutePath(), (String)"\\", (String)"/");
        if (this.matchesExtension(path) && (meta = (FileMetadata)this.fileEntryToMeta(entry)) != null) {
            this.processMeta(meta);
            return;
        }
    }

    public boolean isOfInterest(T fileMeta) {
        return fileMeta.getDecorations().size() > 0;
    }

    protected boolean matchesExtension(String path) {
        for (Pattern extensionPattern : this.extensions) {
            if (!extensionPattern.matcher(path).find()) continue;
            LOG.debug("Matched on extension: " + extensionPattern.pattern());
            return true;
        }
        return false;
    }

    protected Set<Pattern> compilePatternSet(Set<String> patternStringSet) {
        if (patternStringSet == null) {
            return null;
        }
        HashSet<Pattern> target = new HashSet<Pattern>(patternStringSet.size());
        for (String patternString : patternStringSet) {
            if (!StringUtils.endsWith((String)patternString, (String)"$")) {
                patternString = patternString + "$";
            }
            target.add(Pattern.compile(patternString));
        }
        return target;
    }
}

