/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.custommonkey.xmlunit.ComparisonController;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLUnit;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.metadata.decoration.effort.Effort;
import org.jboss.windup.metadata.decoration.effort.UnknownEffort;
import org.jboss.windup.metadata.type.XmlMetadata;
import org.jboss.windup.xmlunit.XmlDifferenceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlComparatorDecorator
implements MetaDecorator<XmlMetadata>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(XmlComparatorDecorator.class);
    private String xmlControlAsFile;
    private String xmlControlAsString;
    private Document controlDoc;
    private String xpathExp;
    private Effort effort = new UnknownEffort();

    public void setXpath(String xpath) {
        this.xpathExp = xpath.trim();
    }

    public void setXmlControlAsFile(String xmlControlAsFile) {
        this.xmlControlAsFile = xmlControlAsFile;
    }

    public void setXmlControlAsString(String xmlControlAsString) {
        this.xmlControlAsString = xmlControlAsString;
    }

    public Effort getEffort() {
        return this.effort;
    }

    public void setEffort(Effort effort) {
        this.effort = effort;
    }

    @Override
    public void processMeta(XmlMetadata file) {
        Document testDoc;
        if (this.controlDoc != null && this.xpathExp != null && (testDoc = this.getDocFragment(this.xpathExp, file)) != null) {
            if (this.isdifferent(testDoc, this.controlDoc)) {
                LOG.debug("XML differences found");
            } else {
                LOG.debug("Remove from list.  XML has default settings");
                LinkedList dList = new LinkedList(file.getDecorations());
                try {
                    file.getDecorations().remove(dList.removeLast());
                }
                catch (NoSuchElementException ne) {
                    LOG.debug("Nothing removed. Decoration list is empty.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        LOG.debug("Read control " + (this.xmlControlAsFile != null ? "file: " + this.xmlControlAsFile : "xmlControlAsString"));
        InputStream inStream = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            if (this.xmlControlAsFile != null) {
                inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.xmlControlAsFile);
                this.controlDoc = dBuilder.parse(inStream);
            } else if (this.xmlControlAsString != null) {
                this.controlDoc = dBuilder.parse(new InputSource(new ByteArrayInputStream(this.xmlControlAsString.getBytes("utf-8"))));
            }
        }
        catch (Exception e) {
            LOG.error("Exception error reading " + (this.xmlControlAsFile != null ? this.xmlControlAsFile : "xmlControlAsString"), (Throwable)e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private Document getDocFragment(String xpathExp, XmlMetadata file) {
        Document testDoc = null;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node node = (Node)xpath.evaluate(xpathExp, file.getParsedDocument(), XPathConstants.NODE);
            if (node != null) {
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                StringWriter buffer = new StringWriter();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(node), new StreamResult(buffer));
                String testStr = buffer.toString();
                LOG.debug("src string: " + testStr);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                testDoc = dBuilder.parse(new InputSource(new ByteArrayInputStream(testStr.getBytes("utf-8"))));
            }
        }
        catch (XPathExpressionException xee) {
            LOG.error("Invalid XPath expression: " + xpathExp);
        }
        catch (Exception e) {
            LOG.error("Error extracting XML content: ", (Throwable)e);
        }
        return testDoc;
    }

    private boolean isdifferent(Document testDoc, Document controlDoc) {
        boolean isdifferent = false;
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setNormalize((boolean)true);
        Diff myDiff = new Diff(controlDoc, testDoc);
        DetailedDiff myComparisonController = new DetailedDiff(myDiff);
        DifferenceEngine engine = new DifferenceEngine((ComparisonController)myComparisonController);
        XmlDifferenceListener listener = new XmlDifferenceListener();
        ElementNameAndAttributeQualifier myElementQualifier = new ElementNameAndAttributeQualifier();
        try {
            engine.compare((Node)controlDoc.getDocumentElement(), (Node)testDoc.getDocumentElement(), (DifferenceListener)listener, (ElementQualifier)myElementQualifier);
        }
        catch (NullPointerException ne) {
            LOG.error("NPE: " + ne.getMessage(), (Throwable)ne);
        }
        isdifferent = listener.called();
        return isdifferent;
    }
}

