/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.archive;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import org.jboss.windup.decorator.MetaDecorator;
import org.jboss.windup.interrogator.Interrogator;
import org.jboss.windup.interrogator.util.KnownArchiveProfiler;
import org.jboss.windup.metadata.type.ZipEntryMetadata;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.metadata.type.archive.ZipMetadata;
import org.jboss.windup.util.FatalWindupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipDecorator
implements MetaDecorator<ZipMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(ZipDecorator.class);
    protected KnownArchiveProfiler knownArchiveProfiler;
    protected List<Interrogator<?>> interrogators = new ArrayList();
    protected List<Interrogator<?>> versionInterrogators = new ArrayList();

    public void setVersionInterrogators(List<Interrogator<?>> versionInterrogators) {
        this.versionInterrogators = versionInterrogators;
    }

    public void setInterrogators(List<Interrogator<?>> interrogators) {
        this.interrogators = interrogators;
    }

    public void setKnownArchiveProfiler(KnownArchiveProfiler knownArchiveProfiler) {
        this.knownArchiveProfiler = knownArchiveProfiler;
    }

    @Override
    public void processMeta(ZipMetadata archive) {
        try {
            List<Interrogator<?>> loadedInterrogators = null;
            loadedInterrogators = this.knownArchiveProfiler.isExclusivelyKnownArchive(archive) ? this.versionInterrogators : this.interrogators;
            Enumeration<? extends ZipEntry> e = archive.getZipFile().entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                ZipEntryMetadata archiveEntry = new ZipEntryMetadata();
                archiveEntry.setArchiveMeta((ArchiveMetadata)archive);
                archiveEntry.setZipEntry(entry);
                for (Interrogator<?> interrogator : loadedInterrogators) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Entry: " + entry.toString() + " -> Interrogator: " + interrogator.getClass());
                    }
                    interrogator.processArchiveEntry(archiveEntry);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof FatalWindupException) {
                throw (FatalWindupException)e;
            }
            LOG.error("Exception processing archive: " + archive.getName(), (Throwable)e);
        }
    }
}

