/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.jboss.windup.decorator.ChainingDecorator;
import org.jboss.windup.metadata.decoration.Hash;
import org.jboss.windup.metadata.type.FileMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA1HashDecorator
extends ChainingDecorator<FileMetadata> {
    public static final Logger LOG = LoggerFactory.getLogger(SHA1HashDecorator.class);

    @Override
    public void processMeta(FileMetadata meta) {
        try {
            FileInputStream fis = new FileInputStream(meta.getFilePointer());
            String sha1 = DigestUtils.sha1Hex((InputStream)fis);
            Hash result = new Hash();
            result.setHashType(Hash.HashType.SHA1);
            result.setHash(sha1);
            meta.getDecorations().add(result);
            if (LOG.isDebugEnabled()) {
                LOG.debug("File: " + meta.getFilePointer().getAbsolutePath() + " : SHA1: " + sha1);
            }
            this.chainDecorators(meta);
        }
        catch (Exception e) {
            LOG.error("Exception generating MD5.", (Throwable)e);
        }
    }
}

